/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.types;

import java.io.UnsupportedEncodingException;
import java.util.List;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.db.CmsSecurityManager;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.types.A_CmsResourceTypeLinkParseable;
import org.opencms.file.types.Messages;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.util.CmsJspLinkMacroResolver;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;

public class CmsResourceTypeJsp
extends A_CmsResourceTypeLinkParseable {
    private static boolean m_staticFrozen;
    private static int m_staticTypeId;
    private static final int RESOURCE_TYPE_ID = 4;
    private static final String RESOURCE_TYPE_NAME = "jsp";

    public CmsResourceTypeJsp() {
        this.m_typeId = 4;
        this.m_typeName = RESOURCE_TYPE_NAME;
    }

    public static int getStaticTypeId() {
        return m_staticTypeId;
    }

    public static String getStaticTypeName() {
        return RESOURCE_TYPE_NAME;
    }

    public int getLoaderId() {
        return 6;
    }

    public void initConfiguration(String name, String id, String className) throws CmsConfigurationException {
        if (OpenCms.getRunLevel() > 2 && m_staticFrozen) {
            throw new CmsConfigurationException(Messages.get().container("ERR_CONFIG_FROZEN_3", this.getClass().getName(), CmsResourceTypeJsp.getStaticTypeName(), new Integer(CmsResourceTypeJsp.getStaticTypeId())));
        }
        if (!RESOURCE_TYPE_NAME.equals(name)) {
            throw new CmsConfigurationException(Messages.get().container("ERR_INVALID_RESTYPE_CONFIG_NAME_3", this.getClass().getName(), RESOURCE_TYPE_NAME, name));
        }
        m_staticFrozen = true;
        super.initConfiguration(RESOURCE_TYPE_NAME, id, className);
        m_staticTypeId = this.m_typeId;
    }

    public List parseLinks(CmsObject cms, CmsFile file) {
        CmsJspLinkMacroResolver macroResolver = new CmsJspLinkMacroResolver(cms, file.getRootPath(), false);
        String encoding = CmsLocaleManager.getResourceEncoding(cms, file);
        String content = CmsEncoder.createString(file.getContents(), encoding);
        macroResolver.resolveMacros(content);
        return macroResolver.getLinks();
    }

    public CmsFile writeFile(CmsObject cms, CmsSecurityManager securityManager, CmsFile resource) throws CmsException {
        CmsJspLinkMacroResolver macroResolver = new CmsJspLinkMacroResolver(cms, resource.getRootPath(), false);
        String encoding = CmsLocaleManager.getResourceEncoding(cms, resource);
        String content = CmsEncoder.createString(resource.getContents(), encoding);
        content = macroResolver.resolveMacros(content);
        try {
            resource.setContents(content.getBytes(encoding));
        }
        catch (UnsupportedEncodingException e) {
            resource.setContents(content.getBytes());
        }
        return super.writeFile(cms, securityManager, resource);
    }
}

