/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.db.CmsSecurityManager;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.A_CmsResourceTypeLinkParseable;
import org.opencms.file.types.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsLink;
import org.opencms.security.CmsPermissionSet;
import org.opencms.staticexport.CmsLinkTable;
import org.opencms.util.CmsHtmlConverter;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.page.CmsXmlPage;
import org.opencms.xml.page.CmsXmlPageFactory;

public class CmsResourceTypeXmlPage
extends A_CmsResourceTypeLinkParseable {
    private static final Log LOG = CmsLog.getLog(CmsResourceTypeXmlPage.class);
    private static boolean m_staticFrozen;
    private static int m_staticTypeId;
    private static final int RESOURCE_TYPE_ID = 6;
    private static final String RESOURCE_TYPE_NAME = "xmlpage";

    public CmsResourceTypeXmlPage() {
        this.m_typeId = 6;
        this.m_typeName = RESOURCE_TYPE_NAME;
    }

    public static int getStaticTypeId() {
        return m_staticTypeId;
    }

    public static String getStaticTypeName() {
        return RESOURCE_TYPE_NAME;
    }

    public static boolean isXmlPage(CmsResource resource) {
        boolean result = false;
        if (resource != null) {
            result = resource.getTypeId() == m_staticTypeId;
        }
        return result;
    }

    public String getCachePropertyDefault() {
        return "element;locale;";
    }

    public int getLoaderId() {
        return 9;
    }

    public void initConfiguration(String name, String id, String className) throws CmsConfigurationException {
        if (OpenCms.getRunLevel() > 2 && m_staticFrozen) {
            throw new CmsConfigurationException(Messages.get().container("ERR_CONFIG_FROZEN_3", this.getClass().getName(), CmsResourceTypeXmlPage.getStaticTypeName(), new Integer(CmsResourceTypeXmlPage.getStaticTypeId())));
        }
        if (!RESOURCE_TYPE_NAME.equals(name)) {
            throw new CmsConfigurationException(Messages.get().container("ERR_INVALID_RESTYPE_CONFIG_NAME_3", this.getClass().getName(), RESOURCE_TYPE_NAME, name));
        }
        m_staticFrozen = true;
        super.initConfiguration(RESOURCE_TYPE_NAME, id, className);
        m_staticTypeId = this.m_typeId;
    }

    public List parseLinks(CmsObject cms, CmsFile file) {
        HashSet<CmsLink> links = new HashSet<CmsLink>();
        try {
            CmsXmlPage xmlPage = CmsXmlPageFactory.unmarshal(cms, file);
            List locales = xmlPage.getLocales();
            Iterator i = locales.iterator();
            while (i.hasNext()) {
                Locale locale = (Locale)i.next();
                List elementNames = xmlPage.getNames(locale);
                Iterator j = elementNames.iterator();
                while (j.hasNext()) {
                    String elementName = (String)j.next();
                    CmsLinkTable linkTable = xmlPage.getLinkTable(elementName, locale);
                    Iterator k = linkTable.iterator();
                    while (k.hasNext()) {
                        CmsLink link = (CmsLink)k.next();
                        if (!link.isInternal()) continue;
                        link.checkConsistency(cms);
                        links.add(link);
                    }
                }
            }
        }
        catch (CmsXmlException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_PROCESS_HTML_CONTENT_1", cms.getSitePath(file)), (Throwable)e);
            }
            return Collections.EMPTY_LIST;
        }
        return new ArrayList(links);
    }

    public CmsFile writeFile(CmsObject cms, CmsSecurityManager securityManager, CmsFile resource) throws CmsException {
        securityManager.checkPermissions(cms.getRequestContext(), (CmsResource)resource, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.ALL);
        if (resource.getLength() > 0) {
            CmsXmlPage xmlPage = CmsXmlPageFactory.unmarshal(cms, resource, false);
            xmlPage.validateXmlStructure(new CmsXmlEntityResolver(cms));
            String contentConversion = CmsHtmlConverter.getConversionSettings(cms, resource);
            xmlPage.setConversion(contentConversion);
            resource = xmlPage.correctXmlStructure(cms);
        }
        return super.writeFile(cms, securityManager, resource);
    }
}

