/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.flex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.cache.I_CmsLruCacheObject;
import org.opencms.flex.CmsFlexCacheException;
import org.opencms.flex.CmsFlexRequest;
import org.opencms.flex.CmsFlexResponse;
import org.opencms.flex.Messages;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsLog;
import org.opencms.monitor.CmsMemoryMonitor;
import org.opencms.monitor.I_CmsMemoryMonitorable;

public class CmsFlexCacheEntry
implements I_CmsLruCacheObject,
I_CmsMemoryMonitorable {
    public static final int INITIAL_CAPACITY_LISTS = 10;
    private static final Log LOG = CmsLog.getLog(CmsFlexCacheEntry.class);
    private int m_byteSize = 1024;
    private boolean m_completed;
    private long m_dateExpires;
    private long m_dateLastModified = -1L;
    private List m_elements = new ArrayList(10);
    private Map m_headers;
    private I_CmsLruCacheObject m_next;
    private I_CmsLruCacheObject m_previous;
    private String m_redirectTarget;
    private String m_variationKey;
    private Map m_variationMap;

    public CmsFlexCacheEntry() {
        this.m_dateExpires = Long.MAX_VALUE;
        this.setNextLruObject(null);
        this.setPreviousLruObject(null);
    }

    public void add(byte[] bytes) {
        if (this.m_completed) {
            return;
        }
        if (this.m_redirectTarget == null) {
            this.m_elements.add(bytes);
            this.m_byteSize += CmsMemoryMonitor.getMemorySize(bytes);
        }
    }

    public void add(String resource, Map parameters) {
        if (this.m_completed) {
            return;
        }
        if (this.m_redirectTarget == null) {
            this.m_elements.add(resource);
            if (parameters == null) {
                parameters = Collections.EMPTY_MAP;
            }
            this.m_elements.add(parameters);
            this.m_byteSize += CmsMemoryMonitor.getMemorySize(resource);
        }
    }

    public void addHeaders(Map headers) {
        if (this.m_completed) {
            return;
        }
        this.m_headers = headers;
        Iterator allHeaders = this.m_headers.keySet().iterator();
        while (allHeaders.hasNext()) {
            this.m_byteSize += CmsMemoryMonitor.getMemorySize(allHeaders.next());
        }
    }

    public void addToLruCache() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHEENTRY_ADDED_ENTRY_1", this));
        }
    }

    public void complete() {
        this.m_completed = true;
        if (this.m_headers != null) {
            this.m_headers = Collections.unmodifiableMap(this.m_headers);
        }
        if (this.m_elements != null) {
            this.m_elements = Collections.unmodifiableList(this.m_elements);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHEENTRY_ENTRY_COMPLETED_1", this.toString()));
        }
    }

    public List elements() {
        return this.m_elements;
    }

    public long getDateExpires() {
        return this.m_dateExpires;
    }

    public long getDateLastModified() {
        return this.m_dateLastModified;
    }

    public int getLruCacheCosts() {
        return this.m_byteSize;
    }

    public int getMemorySize() {
        return this.getLruCacheCosts();
    }

    public I_CmsLruCacheObject getNextLruObject() {
        return this.m_next;
    }

    public I_CmsLruCacheObject getPreviousLruObject() {
        return this.m_previous;
    }

    public Object getValue() {
        return this.m_elements;
    }

    public void removeFromLruCache() {
        if (this.m_variationMap != null && this.m_variationKey != null) {
            this.m_variationMap.remove(this.m_variationKey);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHEENTRY_REMOVED_ENTRY_FOR_VARIATION_1", this.m_variationKey));
        }
    }

    public void service(CmsFlexRequest req, CmsFlexResponse res) throws CmsFlexCacheException, ServletException, IOException {
        if (!this.m_completed) {
            return;
        }
        if (this.m_redirectTarget != null) {
            res.setOnlyBuffering(false);
            res.sendRedirect(this.m_redirectTarget);
        } else {
            CmsFlexResponse.processHeaders(this.m_headers, (HttpServletResponse)res);
            boolean hasNoSubElements = this.m_elements.size() == 1;
            for (int i = 0; i < this.m_elements.size(); ++i) {
                Object o = this.m_elements.get(i);
                if (o instanceof String) {
                    Map map = (Map)this.m_elements.get(++i);
                    Map oldMap = null;
                    if (map.size() > 0) {
                        oldMap = req.getParameterMap();
                        req.addParameterMap(map);
                    }
                    req.getRequestDispatcher((String)o).include((ServletRequest)req, (ServletResponse)res);
                    if (oldMap == null) continue;
                    req.setParameterMap(oldMap);
                    continue;
                }
                try {
                    res.writeToOutputStream((byte[])o, hasNoSubElements);
                    continue;
                }
                catch (IOException e) {
                    CmsMessageContainer message = Messages.get().container("LOG_FLEXCACHEKEY_NOT_FOUND_1", this.getClass().getName());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)message.key());
                    }
                    throw new CmsFlexCacheException(message, (Throwable)e);
                }
            }
        }
    }

    public void setDateExpires(long dateExpires) {
        this.m_dateExpires = dateExpires;
        if (LOG.isDebugEnabled()) {
            long now = System.currentTimeMillis();
            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXCACHEENTRY_SET_EXPIRATION_DATE_3", new Long(this.m_dateExpires), new Long(now), new Long(this.m_dateExpires - now)));
        }
    }

    public void setDateExpiresToNextTimeout(long timeout) {
        if (timeout < 0L || !this.m_completed) {
            return;
        }
        long now = System.currentTimeMillis();
        long daytime = now % 86400000L;
        long timeoutMinutes = timeout * 60000L;
        this.setDateExpires(now - daytime % timeoutMinutes + timeoutMinutes);
    }

    public void setDateLastModified(long dateLastModified) {
        this.m_dateLastModified = dateLastModified;
    }

    public void setDateLastModifiedToPreviousTimeout(long timeout) {
        long now = System.currentTimeMillis();
        long daytime = now % 86400000L;
        long timeoutMinutes = timeout * 60000L;
        this.setDateLastModified(now - daytime % timeoutMinutes);
    }

    public void setNextLruObject(I_CmsLruCacheObject theNextEntry) {
        this.m_next = theNextEntry;
    }

    public void setPreviousLruObject(I_CmsLruCacheObject thePreviousEntry) {
        this.m_previous = thePreviousEntry;
    }

    public void setRedirect(String target) {
        if (this.m_completed || target == null) {
            return;
        }
        this.m_redirectTarget = target;
        this.m_byteSize = 512 + CmsMemoryMonitor.getMemorySize(target);
        this.m_elements = null;
        this.m_headers = null;
    }

    public void setVariationData(String theVariationKey, Map theVariationMap) {
        this.m_variationKey = theVariationKey;
        this.m_variationMap = theVariationMap;
    }

    public String toString() {
        String str = null;
        if (this.m_redirectTarget == null) {
            str = "CmsFlexCacheEntry [" + this.m_elements.size() + " Elements/" + this.getLruCacheCosts() + " bytes]\n";
            Iterator i = this.m_elements.iterator();
            int count = 0;
            while (i.hasNext()) {
                ++count;
                Object o = i.next();
                if (o instanceof String) {
                    str = str + "" + count + " - <cms:include target=" + o + ">\n";
                    continue;
                }
                if (o instanceof byte[]) {
                    str = str + "" + count + " - <![CDATA[" + new String((byte[])o) + "]]>\n";
                    continue;
                }
                str = str + "<!--[" + o.toString() + "]-->";
            }
        } else {
            str = "CmsFlexCacheEntry [Redirect to target=" + this.m_redirectTarget + "]";
        }
        return str;
    }
}

