/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.i18n;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.opencms.i18n.Messages;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public final class CmsEncoder {
    public static final String ENCODING_ISO_8859_1 = "ISO-8859-1";
    public static final String ENCODING_US_ASCII = "US-ASCII";
    public static final String ENCODING_UTF_8 = "UTF-8";
    private static final Pattern ENTITIY_PATTERN = Pattern.compile("\\&#\\d+;");
    private static final String ENTITY_PREFIX = "&#";
    private static final String ENTITY_REPLACEMENT = "$$";
    private static final Log LOG = CmsLog.getLog(CmsEncoder.class);
    private static Map m_encodingCache = new HashMap(16);
    private static final String PLUS_ENTITY = "&#043;";

    private CmsEncoder() {
    }

    public static String adjustHtmlEncoding(String input, String encoding) {
        return CmsEncoder.encodeHtmlEntities(CmsEncoder.decodeHtmlEntities(input, encoding), encoding);
    }

    public static byte[] changeEncoding(byte[] input, String oldEncoding, String newEncoding) {
        if (oldEncoding == null || newEncoding == null) {
            return input;
        }
        if (oldEncoding.trim().equalsIgnoreCase(newEncoding.trim())) {
            return input;
        }
        byte[] result = input;
        try {
            result = new String(input, oldEncoding).getBytes(newEncoding);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return result;
    }

    public static String createString(byte[] bytes, String encoding) {
        String enc = encoding.intern();
        if (enc != OpenCms.getSystemInfo().getDefaultEncoding()) {
            enc = CmsEncoder.lookupEncoding(enc, null);
        }
        if (enc != null) {
            try {
                return new String(bytes, enc);
            }
            catch (UnsupportedEncodingException e) {
            }
        } else {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("ERR_UNSUPPORTED_VM_ENCODING_1", encoding));
            }
            enc = OpenCms.getSystemInfo().getDefaultEncoding();
            try {
                return new String(bytes, enc);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        LOG.error((Object)Messages.get().getBundle().key("ERR_ENCODING_ISSUES_1", encoding));
        return null;
    }

    public static String decode(String source) {
        return CmsEncoder.decode(source, ENCODING_UTF_8);
    }

    public static String decode(String source, String encoding) {
        if (source == null) {
            return null;
        }
        if (encoding != null) {
            try {
                return URLDecoder.decode(source, encoding);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        try {
            return URLDecoder.decode(source, ENCODING_UTF_8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return source;
        }
    }

    public static String decodeHtmlEntities(String input, String encoding) {
        Matcher matcher = ENTITIY_PATTERN.matcher(input);
        StringBuffer result = new StringBuffer(input.length());
        Charset charset = Charset.forName(encoding);
        CharsetEncoder encoder = charset.newEncoder();
        while (matcher.find()) {
            String entity = matcher.group();
            String value = entity.substring(2, entity.length() - 1);
            int c = Integer.valueOf(value);
            if (c < 128) {
                entity = new String(new char[]{(char)c});
            } else if (encoder.canEncode((char)c)) {
                entity = new String(new char[]{(char)c});
            }
            matcher.appendReplacement(result, entity);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static String decodeParameter(String input) {
        String result = CmsStringUtil.substitute(input, ENTITY_REPLACEMENT, ENTITY_PREFIX);
        return CmsEncoder.decodeHtmlEntities(result, OpenCms.getSystemInfo().getDefaultEncoding());
    }

    public static String encode(String source) {
        return CmsEncoder.encode(source, ENCODING_UTF_8);
    }

    public static String encode(String source, String encoding) {
        if (source == null) {
            return null;
        }
        if (encoding != null) {
            try {
                return URLEncoder.encode(source, encoding);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        try {
            return URLEncoder.encode(source, ENCODING_UTF_8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return source;
        }
    }

    public static String encodeHtmlEntities(String input, String encoding) {
        StringBuffer result = new StringBuffer(input.length() * 2);
        CharBuffer buffer = CharBuffer.wrap(input.toCharArray());
        Charset charset = Charset.forName(encoding);
        CharsetEncoder encoder = charset.newEncoder();
        for (int i = 0; i < buffer.length(); ++i) {
            char c = buffer.get(i);
            if (c < '\u0080') {
                result.append(c);
                continue;
            }
            if (encoder.canEncode(c)) {
                result.append(c);
                continue;
            }
            result.append(ENTITY_PREFIX);
            result.append((int)c);
            result.append(";");
        }
        return result.toString();
    }

    public static String encodeJavaEntities(String input, String encoding) {
        StringBuffer result = new StringBuffer(input.length() * 2);
        CharBuffer buffer = CharBuffer.wrap(input.toCharArray());
        Charset charset = Charset.forName(encoding);
        CharsetEncoder encoder = charset.newEncoder();
        for (int i = 0; i < buffer.length(); ++i) {
            char c = buffer.get(i);
            if (c < '\u0080') {
                result.append(c);
                continue;
            }
            if (encoder.canEncode(c)) {
                result.append(c);
                continue;
            }
            result.append("\\u");
            String hex = Integer.toHexString(c);
            int pad = 4 - hex.length();
            for (int p = 0; p < pad; ++p) {
                result.append('0');
            }
            result.append(hex);
        }
        return result.toString();
    }

    public static String encodeParameter(String input) {
        String result = CmsEncoder.encodeHtmlEntities(input, ENCODING_US_ASCII);
        result = CmsStringUtil.substitute(result, "+", PLUS_ENTITY);
        return CmsStringUtil.substitute(result, ENTITY_PREFIX, ENTITY_REPLACEMENT);
    }

    public static String escape(String source, String encoding) {
        return CmsStringUtil.substitute(CmsEncoder.encode(source, encoding), "+", "%20");
    }

    public static String escapeHtml(String source) {
        if (source == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(source.length() * 2);
        for (int i = 0; i < source.length(); ++i) {
            int terminatorIndex;
            char ch = source.charAt(i);
            if (ch == '&' && (terminatorIndex = source.indexOf(";", i)) > 0 && source.substring(i + 1, terminatorIndex).matches("#[0-9]+|lt|gt|amp|quote")) {
                result.append(source.substring(i, terminatorIndex + 1));
                i = terminatorIndex;
                continue;
            }
            if (ch != ' ' && (ch > 'z' || ch < '0' || ch == '<' || ch == '>')) {
                result.append(ENTITY_PREFIX);
                result.append((int)ch);
                result.append(";");
                continue;
            }
            result.append(ch);
        }
        return new String(result);
    }

    public static String escapeNonAscii(String source) {
        if (source == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(source.length() * 2);
        for (int i = 0; i < source.length(); ++i) {
            char ch = source.charAt(i);
            if (ch > '\u00ff') {
                result.append(ENTITY_PREFIX);
                result.append((int)ch);
                result.append(";");
                continue;
            }
            result.append(ch);
        }
        return new String(result);
    }

    public static String escapeWBlanks(String source, String encoding) {
        if (CmsStringUtil.isEmpty(source)) {
            return source;
        }
        StringBuffer ret = new StringBuffer(source.length() * 2);
        String enc = CmsEncoder.encode(source, encoding);
        for (int z = 0; z < enc.length(); ++z) {
            char c = enc.charAt(z);
            if (c == '+') {
                ret.append("%20");
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static String escapeXml(String source) {
        return CmsEncoder.escapeXml(source, false);
    }

    public static String escapeXml(String source, boolean doubleEscape) {
        if (source == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(source.length() * 2);
        block6: for (int i = 0; i < source.length(); ++i) {
            char ch = source.charAt(i);
            switch (ch) {
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case '&': {
                    int terminatorIndex;
                    if (!doubleEscape && (terminatorIndex = source.indexOf(";", i)) > 0 && source.substring(i + 1, terminatorIndex).matches("#[0-9]+")) {
                        result.append(ch);
                        continue block6;
                    }
                    result.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block6;
                }
                default: {
                    result.append(ch);
                }
            }
        }
        return new String(result);
    }

    public static String lookupEncoding(String encoding, String fallback) {
        String result = (String)m_encodingCache.get(encoding);
        if (result != null) {
            return result;
        }
        try {
            result = Charset.forName(encoding).name();
            m_encodingCache.put(encoding, result);
            return result;
        }
        catch (Throwable throwable) {
            return fallback;
        }
    }

    public static String redecodeUriComponent(String input) {
        if (input == null) {
            return input;
        }
        return new String(CmsEncoder.changeEncoding(input.getBytes(), ENCODING_UTF_8, OpenCms.getSystemInfo().getDefaultEncoding()));
    }

    public static String unescape(String source, String encoding) {
        if (source == null) {
            return null;
        }
        int len = source.length();
        StringBuffer preparedSource = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char c = source.charAt(i);
            if (c == '+') {
                preparedSource.append("%20");
                continue;
            }
            preparedSource.append(c);
        }
        return CmsEncoder.decode(preparedSource.toString(), encoding);
    }
}

