/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.i18n;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.i18n.CmsMessageException;
import org.opencms.i18n.CmsMessages;
import org.opencms.i18n.I_CmsMessageBundle;
import org.opencms.i18n.Messages;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;

public class CmsMultiMessages
extends CmsMessages {
    public static final String MULTI_BUNDLE_NAME = CmsMultiMessages.class.getName();
    public static final String NULL_STRING = "null";
    private static final Log LOG = CmsLog.getLog(CmsMultiMessages.class);
    private Map m_messageCache;
    private List m_messages;

    public CmsMultiMessages(Locale locale) {
        this.setBundleName(MULTI_BUNDLE_NAME);
        this.setLocale(locale);
        this.m_messages = new ArrayList();
        this.m_messageCache = new Hashtable();
    }

    public void addBundle(I_CmsMessageBundle bundle) {
        this.addMessages(bundle.getBundle(this.getLocale()));
    }

    public void addMessages(CmsMessages messages) throws CmsIllegalArgumentException {
        Locale locale = messages.getLocale();
        if (!this.getLocale().equals(locale)) {
            if (!(messages instanceof CmsMultiMessages)) {
                String bundleName = messages.getBundleName();
                messages = new CmsMessages(bundleName, this.getLocale());
            } else {
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_MULTIMSG_LOCALE_DOES_NOT_MATCH_2", messages.getLocale(), this.getLocale()));
            }
        }
        if (!this.m_messages.contains(messages)) {
            if (this.m_messageCache != null && this.m_messageCache.size() > 0) {
                this.m_messageCache = new Hashtable();
            }
            this.m_messages.add(messages);
        }
    }

    public void addMessages(List messages) {
        if (messages == null) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_MULTIMSG_EMPTY_LIST_0"));
        }
        Iterator i = messages.iterator();
        while (i.hasNext()) {
            this.addMessages((CmsMessages)i.next());
        }
    }

    public List getMessages() {
        return this.m_messages;
    }

    public String getString(String keyName) {
        return this.resolveKey(keyName);
    }

    public boolean isInitialized() {
        return this.m_messages != null && !this.m_messages.isEmpty();
    }

    public String key(String keyName, boolean allowNull) {
        String result = this.resolveKey(keyName);
        if (result == null && !allowNull) {
            result = CmsMultiMessages.formatUnknownKey(keyName);
        }
        return result;
    }

    private String resolveKey(String keyName) {
        String result;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_RESOLVE_MESSAGE_KEY_1", keyName));
        }
        if ((result = (String)this.m_messageCache.get(keyName)) == NULL_STRING) {
            return null;
        }
        if (result == null) {
            for (int i = 0; result == null && i < this.m_messages.size(); ++i) {
                try {
                    result = ((CmsMessages)this.m_messages.get(i)).getString(keyName);
                    continue;
                }
                catch (CmsMessageException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_MESSAGE_KEY_FOUND_CACHED_2", keyName, result));
            }
            return result;
        }
        if (result == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_MESSAGE_KEY_NOT_FOUND_1", keyName));
            }
            this.m_messageCache.put(keyName, NULL_STRING);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_MESSAGE_KEY_FOUND_2", keyName, result));
            }
            this.m_messageCache.put(keyName, result);
        }
        return result;
    }
}

