/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.importexport;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXWriter;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsFolder;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsException;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.importexport.CmsExportParameters;
import org.opencms.importexport.CmsImportExportException;
import org.opencms.importexport.Messages;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.report.CmsShellReport;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.util.CmsDataTypeUtil;
import org.opencms.util.CmsDateUtil;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsUUID;
import org.opencms.util.CmsXmlSaxWriter;
import org.opencms.workplace.CmsWorkplace;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class CmsExport {
    private static final Log LOG = CmsLog.getLog(CmsExport.class);
    private static final int SUB_LENGTH = 4096;
    private int m_exportCount;
    private Set m_exportedResources;
    private ZipOutputStream m_exportZipStream;
    private CmsExportParameters m_parameters;
    private Element m_resourceNode;
    private SAXWriter m_saxWriter;
    private List m_superFolders;
    private CmsObject m_cms;
    private I_CmsReport m_report;

    public CmsExport() {
    }

    public CmsExport(CmsObject cms, I_CmsReport report) throws CmsRoleViolationException {
        this.m_cms = cms;
        this.m_report = report;
        OpenCms.getRoleManager().checkRole(this.getCms(), CmsRole.DATABASE_MANAGER);
    }

    public void exportData(CmsExportParameters parameters) throws CmsImportExportException {
        this.m_parameters = parameters;
        this.m_exportCount = 0;
        this.getReport().println(Messages.get().container("RPT_CLEARCACHE_0"), 3);
        OpenCms.fireCmsEvent(new CmsEvent(5, Collections.EMPTY_MAP));
        try {
            Element exportNode = this.openExportFile();
            if (this.m_parameters.getModuleInfo() != null) {
                exportNode.add(this.m_parameters.getModuleInfo());
                this.digestElement(exportNode, this.m_parameters.getModuleInfo());
            }
            if (this.m_parameters.isExportAccountData()) {
                Element accountsElement = exportNode.addElement("accounts");
                this.getSaxWriter().writeOpen(accountsElement);
                this.exportOrgUnits(accountsElement);
                this.getSaxWriter().writeClose(accountsElement);
                exportNode.remove(accountsElement);
            }
            if (this.m_parameters.isExportResourceData()) {
                this.exportAllResources(exportNode, this.m_parameters.getResources());
            }
            if (this.m_parameters.isExportProjectData()) {
                Element projectsElement = exportNode.addElement("projects");
                this.getSaxWriter().writeOpen(projectsElement);
                this.exportProjects(projectsElement);
                this.getSaxWriter().writeClose(projectsElement);
                exportNode.remove(projectsElement);
            }
            this.closeExportFile(exportNode);
        }
        catch (SAXException se) {
            this.getReport().println(se);
            CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_EXPORTING_TO_FILE_1", this.getExportFileName());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key(), (Throwable)se);
            }
            throw new CmsImportExportException(message, (Throwable)se);
        }
        catch (IOException ioe) {
            this.getReport().println(ioe);
            CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_EXPORTING_TO_FILE_1", this.getExportFileName());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key(), (Throwable)ioe);
            }
            throw new CmsImportExportException(message, (Throwable)ioe);
        }
    }

    public CmsExport(CmsObject cms, String exportFile, List resourcesToExport, boolean includeSystem, boolean includeUnchanged) throws CmsImportExportException, CmsRoleViolationException {
        this(cms, exportFile, resourcesToExport, includeSystem, includeUnchanged, null, false, 0L, new CmsShellReport(cms.getRequestContext().getLocale()));
    }

    public CmsExport(CmsObject cms, String exportFile, List resourcesToExport, boolean includeSystem, boolean includeUnchanged, Element moduleElement, boolean exportUserdata, long contentAge, I_CmsReport report) throws CmsImportExportException, CmsRoleViolationException {
        this(cms, exportFile, resourcesToExport, includeSystem, includeUnchanged, moduleElement, exportUserdata, contentAge, report, true);
    }

    public CmsExport(CmsObject cms, String exportFile, List resourcesToExport, boolean includeSystem, boolean includeUnchanged, Element moduleElement, boolean exportUserdata, long contentAge, I_CmsReport report, boolean recursive) throws CmsImportExportException, CmsRoleViolationException {
        this(cms, report);
        this.exportData(new CmsExportParameters(exportFile, moduleElement, true, exportUserdata, false, resourcesToExport, includeSystem, includeUnchanged, contentAge, recursive, false));
    }

    protected void addChildResources(String folderName) throws CmsImportExportException, IOException, SAXException {
        try {
            long age;
            int i;
            List subFolders = this.getCms().getSubFolders(folderName, CmsResourceFilter.IGNORE_EXPIRATION);
            List subFiles = this.getCms().getFilesInFolder(folderName, CmsResourceFilter.IGNORE_EXPIRATION);
            for (i = 0; i < subFiles.size(); ++i) {
                String export;
                CmsResource file = (CmsResource)subFiles.get(i);
                CmsResourceState state = file.getState();
                long l = age = file.getDateLastModified() < file.getDateCreated() ? file.getDateCreated() : file.getDateLastModified();
                if ((this.getCms().getRequestContext().currentProject().isOnlineProject() || this.m_parameters.isIncludeUnchangedResources() || state.isNew() || state.isChanged()) && !state.isDeleted() && !CmsWorkplace.isTemporaryFile(file) && age >= this.m_parameters.getContentAge() && this.checkExportResource(export = this.getCms().getSitePath(file)) && this.isInExportableProject(file)) {
                    this.exportFile(this.getCms().readFile(export, CmsResourceFilter.IGNORE_EXPIRATION));
                }
                subFiles.set(i, null);
            }
            subFiles = null;
            for (i = 0; i < subFolders.size(); ++i) {
                String export;
                CmsResource folder = (CmsResource)subFolders.get(i);
                if (folder.getState() != CmsResource.STATE_DELETED && this.checkExportResource(export = this.getCms().getSitePath(folder))) {
                    long l = age = folder.getDateLastModified() < folder.getDateCreated() ? folder.getDateCreated() : folder.getDateLastModified();
                    if (age >= this.m_parameters.getContentAge()) {
                        this.appendResourceToManifest(folder, false);
                    }
                    this.addChildResources(this.getCms().getSitePath(folder));
                }
                subFolders.set(i, null);
            }
        }
        catch (CmsImportExportException e) {
            throw e;
        }
        catch (CmsException e) {
            CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_ADDING_CHILD_RESOURCES_1", folderName);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key(), (Throwable)e);
            }
            throw new CmsImportExportException(message, (Throwable)e);
        }
    }

    protected void addFiles(List fileNames) throws CmsImportExportException, IOException, SAXException {
        if (fileNames != null) {
            for (int i = 0; i < fileNames.size(); ++i) {
                String fileName = (String)fileNames.get(i);
                try {
                    CmsFile file = this.getCms().readFile(fileName, CmsResourceFilter.IGNORE_EXPIRATION);
                    if (file.getState().isDeleted() || CmsWorkplace.isTemporaryFile(file) || !this.checkExportResource(fileName)) continue;
                    if (this.m_parameters.isRecursive()) {
                        this.addParentFolders(fileName);
                    }
                    if (!this.isInExportableProject(file)) continue;
                    this.exportFile(file);
                    continue;
                }
                catch (CmsImportExportException e) {
                    throw e;
                }
                catch (CmsException e) {
                    if (!(e instanceof CmsVfsException)) continue;
                    CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_ADDING_FILE_1", fileName);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)message.key(), (Throwable)e);
                    }
                    throw new CmsImportExportException(message, (Throwable)e);
                }
            }
        }
    }

    protected void addParentFolders(String resourceName) throws CmsImportExportException, SAXException {
        try {
            if (!this.checkExportResource(resourceName)) {
                return;
            }
            if (this.m_superFolders == null) {
                this.m_superFolders = new ArrayList();
            }
            ArrayList<String> superFolders = new ArrayList<String>();
            if (resourceName.lastIndexOf("/") != resourceName.length() - 1) {
                resourceName = resourceName.substring(0, resourceName.lastIndexOf("/") + 1);
            }
            while (resourceName.length() > "/".length()) {
                superFolders.add(resourceName);
                resourceName = resourceName.substring(0, resourceName.length() - 1);
                resourceName = resourceName.substring(0, resourceName.lastIndexOf("/") + 1);
            }
            for (int i = superFolders.size() - 1; i >= 0; --i) {
                String addFolder = (String)superFolders.get(i);
                if (this.m_superFolders.contains(addFolder)) continue;
                CmsFolder folder = this.getCms().readFolder(addFolder, CmsResourceFilter.IGNORE_EXPIRATION);
                this.appendResourceToManifest(folder, false);
                this.m_superFolders.add(addFolder);
            }
        }
        catch (CmsImportExportException e) {
            throw e;
        }
        catch (CmsException e) {
            CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_ADDING_PARENT_FOLDERS_1", resourceName);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key(), (Throwable)e);
            }
            throw new CmsImportExportException(message, (Throwable)e);
        }
    }

    protected void addPropertyNode(Element propertiesElement, String propertyName, String propertyValue, boolean shared) {
        if (propertyValue != null) {
            Element propertyElement = propertiesElement.addElement("property");
            if (shared) {
                propertyElement.addAttribute("type", "shared");
            }
            propertyElement.addElement("name").addText(propertyName);
            propertyElement.addElement("value").addCDATA(propertyValue);
        }
    }

    protected void addRelationNode(Element relationsElement, String structureId, String sitePath, String relationType) {
        if (structureId != null && sitePath != null && relationType != null) {
            Element relationElement = relationsElement.addElement("relation");
            relationElement.addElement("id").addText(structureId);
            relationElement.addElement("path").addText(sitePath);
            relationElement.addElement("type").addText(relationType);
        }
    }

    protected void appendResourceToManifest(CmsResource resource, boolean source) throws CmsImportExportException, SAXException {
        try {
            String fileName = this.trimResourceName(this.getCms().getSitePath(resource));
            if (fileName.startsWith("system/orgunits")) {
                return;
            }
            Element fileElement = this.m_resourceNode.addElement("file");
            if (resource.isFile()) {
                if (source) {
                    fileElement.addElement("source").addText(fileName);
                }
            } else {
                ++this.m_exportCount;
                I_CmsReport report = this.getReport();
                report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_1", String.valueOf(this.m_exportCount)), 3);
                report.print(Messages.get().container("RPT_EXPORT_0"), 3);
                report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", this.getCms().getSitePath(resource)));
                report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)Messages.get().getBundle().key("LOG_EXPORTING_OK_2", String.valueOf(this.m_exportCount), this.getCms().getSitePath(resource)));
                }
            }
            fileElement.addElement("destination").addText(fileName);
            fileElement.addElement("type").addText(OpenCms.getResourceManager().getResourceType(resource.getTypeId()).getTypeName());
            fileElement.addElement("uuidstructure").addText(resource.getStructureId().toString());
            if (resource.isFile()) {
                fileElement.addElement("uuidresource").addText(resource.getResourceId().toString());
            }
            fileElement.addElement("datelastmodified").addText(CmsDateUtil.getHeaderDate(resource.getDateLastModified()));
            String userNameLastModified = null;
            try {
                userNameLastModified = this.getCms().readUser(resource.getUserLastModified()).getName();
            }
            catch (CmsException e) {
                userNameLastModified = OpenCms.getDefaultUsers().getUserAdmin();
            }
            fileElement.addElement("userlastmodified").addText(userNameLastModified);
            fileElement.addElement("datecreated").addText(CmsDateUtil.getHeaderDate(resource.getDateCreated()));
            String userNameCreated = null;
            try {
                userNameCreated = this.getCms().readUser(resource.getUserCreated()).getName();
            }
            catch (CmsException e) {
                userNameCreated = OpenCms.getDefaultUsers().getUserAdmin();
            }
            fileElement.addElement("usercreated").addText(userNameCreated);
            if (resource.getDateReleased() != 0L) {
                fileElement.addElement("datereleased").addText(CmsDateUtil.getHeaderDate(resource.getDateReleased()));
            }
            if (resource.getDateExpired() != Long.MAX_VALUE) {
                fileElement.addElement("dateexpired").addText(CmsDateUtil.getHeaderDate(resource.getDateExpired()));
            }
            int resFlags = resource.getFlags();
            fileElement.addElement("flags").addText(Integer.toString(resFlags &= 0xFFFFFFFD));
            Element propertiesElement = fileElement.addElement("properties");
            List properties = this.getCms().readPropertyObjects(this.getCms().getSitePath(resource), false);
            Collections.sort(properties);
            int n = properties.size();
            for (int i = 0; i < n; ++i) {
                CmsProperty property = (CmsProperty)properties.get(i);
                if (this.isIgnoredProperty(property)) continue;
                this.addPropertyNode(propertiesElement, property.getName(), property.getStructureValue(), false);
                this.addPropertyNode(propertiesElement, property.getName(), property.getResourceValue(), true);
            }
            List relations = this.getCms().getRelationsForResource(this.getCms().getSitePath(resource), CmsRelationFilter.TARGETS.filterNotDefinedInContent());
            CmsRelation relation = null;
            Element relationsElement = fileElement.addElement("relations");
            Iterator iter = relations.iterator();
            while (iter.hasNext()) {
                relation = (CmsRelation)iter.next();
                CmsResource target = relation.getTarget(this.getCms(), CmsResourceFilter.ALL);
                String structureId = target.getStructureId().toString();
                String sitePath = this.getCms().getSitePath(target);
                String relationType = relation.getType().getName();
                this.addRelationNode(relationsElement, structureId, sitePath, relationType);
            }
            Element acl = fileElement.addElement("accesscontrol");
            List fileAcEntries = this.getCms().getAccessControlEntries(this.getCms().getSitePath(resource), false);
            Iterator i = fileAcEntries.iterator();
            while (i.hasNext()) {
                CmsAccessControlEntry ace = (CmsAccessControlEntry)i.next();
                Element a = acl.addElement("accessentry");
                int flags = ace.getFlags();
                String acePrincipalName = "";
                CmsUUID acePrincipal = ace.getPrincipal();
                acePrincipalName = (flags & 0x80) > 0 ? "ALL_OTHERS" : ((flags & 0x100) > 0 ? "OVERWRITE_ALL" : ((flags & 0x20) > 0 ? this.getCms().readGroup(acePrincipal).getPrefixedName() : ((flags & 0x10) > 0 ? this.getCms().readUser(acePrincipal).getPrefixedName() : "ROLE." + CmsRole.valueOfId(acePrincipal).getRoleName())));
                a.addElement("uuidprincipal").addText(acePrincipalName);
                a.addElement("flags").addText(Integer.toString(flags));
                Element b = a.addElement("permissionset");
                b.addElement("allowed").addText(Integer.toString(ace.getAllowedPermissions()));
                b.addElement("denied").addText(Integer.toString(ace.getDeniedPermissions()));
            }
            this.digestElement(this.m_resourceNode, fileElement);
        }
        catch (CmsImportExportException e) {
            throw e;
        }
        catch (CmsException e) {
            CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_APPENDING_RESOURCE_TO_MANIFEST_1", resource.getRootPath());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key(), (Throwable)e);
            }
            throw new CmsImportExportException(message, (Throwable)e);
        }
    }

    protected boolean checkExportResource(String resourcename) {
        return !resourcename.startsWith("/system/") || resourcename.equalsIgnoreCase("/system/") || resourcename.startsWith("/system/galleries/") || this.m_parameters.isIncludeSystemFolder() && resourcename.startsWith("/system/");
    }

    protected void closeExportFile(Element exportNode) throws IOException, SAXException {
        this.getSaxWriter().writeClose(exportNode);
        CmsXmlSaxWriter xmlSaxWriter = (CmsXmlSaxWriter)this.getSaxWriter().getContentHandler();
        xmlSaxWriter.endDocument();
        ZipEntry entry = new ZipEntry("manifest.xml");
        this.getExportZipStream().putNextEntry(entry);
        StringBuffer result = ((StringWriter)xmlSaxWriter.getWriter()).getBuffer();
        int steps = result.length() / 4096;
        int rest = result.length() % 4096;
        int pos = 0;
        for (int i = 0; i < steps; ++i) {
            String sub = result.substring(pos, pos + 4096);
            this.getExportZipStream().write(sub.getBytes(OpenCms.getSystemInfo().getDefaultEncoding()));
            pos += 4096;
        }
        if (rest > 0) {
            String sub = result.substring(pos, pos + rest);
            this.getExportZipStream().write(sub.getBytes(OpenCms.getSystemInfo().getDefaultEncoding()));
        }
        this.getExportZipStream().closeEntry();
        this.getExportZipStream().close();
    }

    protected void digestElement(Element parent, Element output) throws SAXException {
        this.m_saxWriter.write(output);
        parent.remove(output);
    }

    protected void exportAllResources(Element parent, List resourcesToExport) throws CmsImportExportException, IOException, SAXException {
        String resourceNodeName = this.getResourceNodeName();
        this.m_resourceNode = parent.addElement(resourceNodeName);
        this.getSaxWriter().writeOpen(this.m_resourceNode);
        if (this.m_parameters.isRecursive()) {
            resourcesToExport = CmsFileUtil.removeRedundancies(resourcesToExport);
        }
        ArrayList<String> folderNames = new ArrayList<String>();
        ArrayList<String> fileNames = new ArrayList<String>();
        Iterator it = resourcesToExport.iterator();
        while (it.hasNext()) {
            String resource = (String)it.next();
            if (CmsResource.isFolder(resource)) {
                folderNames.add(resource);
                continue;
            }
            fileNames.add(resource);
        }
        this.m_exportedResources = new HashSet();
        for (int i = 0; i < folderNames.size(); ++i) {
            String export;
            long age;
            CmsFolder folder;
            String path = (String)folderNames.get(i);
            if (this.m_parameters.isRecursive()) {
                this.addParentFolders(path);
                this.addChildResources(path);
                continue;
            }
            try {
                folder = this.getCms().readFolder(path, CmsResourceFilter.IGNORE_EXPIRATION);
            }
            catch (CmsException e) {
                CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_ADDING_PARENT_FOLDERS_1", path);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)message.key(), (Throwable)e);
                }
                throw new CmsImportExportException(message, (Throwable)e);
            }
            CmsResourceState state = folder.getState();
            long l = age = folder.getDateLastModified() < folder.getDateCreated() ? folder.getDateCreated() : folder.getDateLastModified();
            if (!this.getCms().getRequestContext().currentProject().isOnlineProject() && !this.m_parameters.isIncludeUnchangedResources() && !state.isNew() && !state.isChanged() || state.isDeleted() || age < this.m_parameters.getContentAge() || !this.checkExportResource(export = this.getCms().getSitePath(folder))) continue;
            this.appendResourceToManifest(folder, false);
        }
        this.addFiles(fileNames);
        this.getSaxWriter().writeClose(this.m_resourceNode);
        parent.remove(this.m_resourceNode);
        this.m_resourceNode = null;
    }

    protected void exportFile(CmsFile file) throws CmsImportExportException, SAXException, IOException {
        String source = this.trimResourceName(this.getCms().getSitePath(file));
        I_CmsReport report = this.getReport();
        ++this.m_exportCount;
        report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_1", String.valueOf(this.m_exportCount)), 3);
        report.print(Messages.get().container("RPT_EXPORT_0"), 3);
        report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", this.getCms().getSitePath(file)));
        report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
        if (!this.m_exportedResources.contains(file.getResourceId())) {
            ZipEntry entry = new ZipEntry(source);
            entry.setTime(file.getDateLastModified());
            this.getExportZipStream().putNextEntry(entry);
            this.getExportZipStream().write(file.getContents());
            this.getExportZipStream().closeEntry();
            this.m_exportedResources.add(file.getResourceId());
            this.appendResourceToManifest(file, true);
        } else {
            this.appendResourceToManifest(file, false);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_EXPORTING_OK_2", String.valueOf(this.m_exportCount), source));
        }
        report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
    }

    protected void exportGroup(Element parent, CmsGroup group) throws CmsImportExportException, SAXException {
        try {
            String parentgroup = group.getParentId() == null || group.getParentId().isNullUUID() ? "" : this.getCms().getParent(group.getName()).getName();
            Element e = parent.addElement("group");
            e.addElement("name").addText(group.getSimpleName());
            e.addElement("description").addCDATA(group.getDescription());
            e.addElement("flags").addText(Integer.toString(group.getFlags()));
            e.addElement("parentgroup").addText(parentgroup);
            this.digestElement(parent, e);
        }
        catch (CmsException e) {
            CmsMessageContainer message = org.opencms.db.Messages.get().container("ERR_GET_PARENT_GROUP_1", group.getName());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key(), (Throwable)e);
            }
            throw new CmsImportExportException(message, (Throwable)e);
        }
    }

    protected void exportGroups(Element parent, CmsOrganizationalUnit orgunit) throws CmsImportExportException, SAXException {
        try {
            I_CmsReport report = this.getReport();
            List allGroups = OpenCms.getOrgUnitManager().getGroups(this.getCms(), orgunit.getName(), false);
            int l = allGroups.size();
            for (int i = 0; i < l; ++i) {
                CmsGroup group = (CmsGroup)allGroups.get(i);
                report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", String.valueOf(i + 1), String.valueOf(l)), 3);
                report.print(Messages.get().container("RPT_EXPORT_GROUP_0"), 3);
                report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", group.getName()));
                report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                this.exportGroup(parent, group);
                report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
            }
        }
        catch (CmsImportExportException e) {
            throw e;
        }
        catch (CmsException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            throw new CmsImportExportException(e.getMessageContainer(), (Throwable)e);
        }
    }

    protected void exportOrgUnit(Element parent, CmsOrganizationalUnit orgunit) throws SAXException, CmsException {
        Element orgunitElement = parent.addElement("orgunit");
        this.getSaxWriter().writeOpen(orgunitElement);
        Element name = orgunitElement.addElement("name").addText(orgunit.getName());
        this.digestElement(orgunitElement, name);
        Element description = orgunitElement.addElement("description").addCDATA(orgunit.getDescription());
        this.digestElement(orgunitElement, description);
        Element flags = orgunitElement.addElement("flags").addText(Integer.toString(orgunit.getFlags()));
        this.digestElement(orgunitElement, flags);
        Element resources = orgunitElement.addElement("resources");
        Iterator it = OpenCms.getOrgUnitManager().getResourcesForOrganizationalUnit(this.getCms(), orgunit.getName()).iterator();
        while (it.hasNext()) {
            CmsResource resource = (CmsResource)it.next();
            resources.addElement("resource").addText(resource.getRootPath());
        }
        this.digestElement(orgunitElement, resources);
        this.getReport().println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
        Element groupsElement = parent.addElement("groups");
        this.getSaxWriter().writeOpen(groupsElement);
        this.exportGroups(groupsElement, orgunit);
        this.getSaxWriter().writeClose(groupsElement);
        Element usersElement = parent.addElement("users");
        this.getSaxWriter().writeOpen(usersElement);
        this.exportUsers(usersElement, orgunit);
        this.getSaxWriter().writeClose(usersElement);
        this.getSaxWriter().writeClose(orgunitElement);
    }

    protected void exportOrgUnits(Element parent) throws CmsImportExportException, SAXException {
        try {
            Element orgunitsElement = parent.addElement("orgunits");
            this.getSaxWriter().writeOpen(orgunitsElement);
            I_CmsReport report = this.getReport();
            ArrayList<CmsOrganizationalUnit> allOUs = new ArrayList<CmsOrganizationalUnit>();
            allOUs.add(OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), ""));
            allOUs.addAll(OpenCms.getOrgUnitManager().getOrganizationalUnits(this.getCms(), "", true));
            for (int i = 0; i < allOUs.size(); ++i) {
                CmsOrganizationalUnit ou = (CmsOrganizationalUnit)allOUs.get(i);
                report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", String.valueOf(i + 1), String.valueOf(allOUs.size())), 3);
                report.print(Messages.get().container("RPT_EXPORT_ORGUNIT_0"), 3);
                report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", ou.getName()));
                report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                this.exportOrgUnit(orgunitsElement, ou);
            }
            this.getSaxWriter().writeClose(orgunitsElement);
        }
        catch (CmsImportExportException e) {
            throw e;
        }
        catch (CmsException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            throw new CmsImportExportException(e.getMessageContainer(), (Throwable)e);
        }
    }

    protected void exportProject(Element parent, CmsProject project) throws CmsImportExportException, SAXException {
        String managers;
        String users;
        try {
            users = this.getCms().readGroup(project.getGroupId()).getName();
        }
        catch (CmsException e) {
            CmsMessageContainer message = org.opencms.db.Messages.get().container("ERR_READ_GROUP_FOR_ID_1", project.getGroupId());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key(), (Throwable)e);
            }
            throw new CmsImportExportException(message, (Throwable)e);
        }
        try {
            managers = this.getCms().readGroup(project.getManagerGroupId()).getName();
        }
        catch (CmsException e) {
            CmsMessageContainer message = org.opencms.db.Messages.get().container("ERR_READ_GROUP_FOR_ID_1", project.getManagerGroupId());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key(), (Throwable)e);
            }
            throw new CmsImportExportException(message, (Throwable)e);
        }
        Element e = parent.addElement("project");
        e.addElement("name").addText(project.getSimpleName());
        e.addElement("description").addCDATA(project.getDescription());
        e.addElement("usersgroup").addText(users);
        e.addElement("managersgroup").addText(managers);
        Element resources = e.addElement("resources");
        try {
            Iterator it = this.getCms().readProjectResources(project).iterator();
            while (it.hasNext()) {
                String resName = (String)it.next();
                resources.addElement("resource").addText(resName);
            }
        }
        catch (CmsException exc) {
            CmsMessageContainer message = org.opencms.db.Messages.get().container("ERR_READ_PROJECT_RESOURCES_2", project.getName(), project.getUuid());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key(), (Throwable)exc);
            }
            throw new CmsImportExportException(message, (Throwable)exc);
        }
        this.digestElement(parent, e);
    }

    protected void exportProjects(Element parent) throws CmsImportExportException, SAXException {
        try {
            I_CmsReport report = this.getReport();
            List allProjects = OpenCms.getOrgUnitManager().getAllManageableProjects(this.getCms(), "", true);
            for (int i = 0; i < allProjects.size(); ++i) {
                CmsProject project = (CmsProject)allProjects.get(i);
                report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", String.valueOf(i + 1), String.valueOf(allProjects.size())), 3);
                report.print(Messages.get().container("RPT_EXPORT_PROJECT_0"), 3);
                report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", project.getName()));
                report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                this.exportProject(parent, project);
                report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
            }
        }
        catch (CmsImportExportException e) {
            throw e;
        }
        catch (CmsException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            throw new CmsImportExportException(e.getMessageContainer(), (Throwable)e);
        }
    }

    protected void exportUser(Element parent, CmsUser user) throws CmsImportExportException, SAXException {
        try {
            Element e = parent.addElement("user");
            e.addElement("name").addText(user.getSimpleName());
            String passwd = new String(Base64.encodeBase64((byte[])user.getPassword().getBytes()));
            e.addElement("password").addCDATA(passwd);
            e.addElement("firstname").addText(user.getFirstname());
            e.addElement("lastname").addText(user.getLastname());
            e.addElement("email").addText(user.getEmail());
            e.addElement("flags").addText(Integer.toString(user.getFlags()));
            e.addElement("datecreated").addText(Long.toString(user.getDateCreated()));
            Element userInfoNode = e.addElement("userinfo");
            ArrayList keys = new ArrayList(user.getAdditionalInfo().keySet());
            Collections.sort(keys);
            Iterator itInfoKeys = keys.iterator();
            while (itInfoKeys.hasNext()) {
                Object value;
                String key = (String)itInfoKeys.next();
                if (key == null || (value = user.getAdditionalInfo(key)) == null) continue;
                Element entryNode = userInfoNode.addElement("entry");
                entryNode.addAttribute("name", key);
                entryNode.addAttribute("type", value.getClass().getName());
                try {
                    entryNode.addCDATA(CmsDataTypeUtil.dataExport(value));
                }
                catch (IOException ioe) {
                    this.getReport().println(ioe);
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)Messages.get().getBundle().key("ERR_IMPORTEXPORT_ERROR_EXPORTING_USER_1", user.getName()), (Throwable)ioe);
                }
            }
            Element userRoles = e.addElement("userroles");
            List roles = OpenCms.getRoleManager().getRolesOfUser(this.getCms(), user.getName(), "", true, true, true);
            for (int i = 0; i < roles.size(); ++i) {
                String roleName = ((CmsRole)roles.get(i)).getFqn();
                userRoles.addElement("userrole").addText(roleName);
            }
            Element userGroups = e.addElement("usergroups");
            List groups = this.getCms().getGroupsOfUser(user.getName(), true, true);
            for (int i = 0; i < groups.size(); ++i) {
                String groupName = ((CmsGroup)groups.get(i)).getName();
                userGroups.addElement("usergroup").addText(groupName);
            }
            this.digestElement(parent, e);
        }
        catch (CmsException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            throw new CmsImportExportException(e.getMessageContainer(), (Throwable)e);
        }
    }

    protected void exportUsers(Element parent, CmsOrganizationalUnit orgunit) throws CmsImportExportException, SAXException {
        try {
            I_CmsReport report = this.getReport();
            List allUsers = OpenCms.getOrgUnitManager().getUsers(this.getCms(), orgunit.getName(), false);
            int l = allUsers.size();
            for (int i = 0; i < l; ++i) {
                CmsUser user = (CmsUser)allUsers.get(i);
                report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", String.valueOf(i + 1), String.valueOf(l)), 3);
                report.print(Messages.get().container("RPT_EXPORT_USER_0"), 3);
                report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", user.getName()));
                report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                this.exportUser(parent, user);
                report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
            }
        }
        catch (CmsImportExportException e) {
            throw e;
        }
        catch (CmsException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            throw new CmsImportExportException(e.getMessageContainer(), (Throwable)e);
        }
    }

    protected CmsObject getCms() {
        return this.m_cms;
    }

    protected String getExportFileName() {
        return this.m_parameters.getPath();
    }

    protected String getExportNodeName() {
        return "export";
    }

    protected ZipOutputStream getExportZipStream() {
        return this.m_exportZipStream;
    }

    protected I_CmsReport getReport() {
        return this.m_report;
    }

    protected String getResourceNodeName() {
        return "files";
    }

    protected SAXWriter getSaxWriter() {
        return this.m_saxWriter;
    }

    protected boolean isIgnoredProperty(CmsProperty property) {
        return property == null;
    }

    protected boolean isInExportableProject(CmsResource res) {
        boolean retValue = true;
        if (this.m_parameters.isInProject()) {
            if (res.getState() == CmsResource.STATE_CHANGED || res.getState() == CmsResource.STATE_NEW) {
                if (!res.getProjectLastModified().equals(this.getCms().getRequestContext().currentProject().getUuid())) {
                    retValue = false;
                }
            } else {
                retValue = false;
            }
        }
        return retValue;
    }

    protected Element openExportFile() throws IOException, SAXException {
        this.setExportZipStream(new ZipOutputStream(new FileOutputStream(this.getExportFileName())));
        CmsXmlSaxWriter saxHandler = new CmsXmlSaxWriter(new StringWriter(4096), OpenCms.getSystemInfo().getDefaultEncoding());
        saxHandler.setEscapeXml(true);
        saxHandler.setEscapeUnknownChars(true);
        this.setSaxWriter(new SAXWriter((ContentHandler)saxHandler, (LexicalHandler)saxHandler));
        Document doc = DocumentHelper.createDocument();
        saxHandler.startDocument();
        if (this.m_parameters.isXmlValidation()) {
            saxHandler.startDTD(this.getExportNodeName(), null, "http://www.opencms.org/dtd/6.0/opencms-import7.dtd");
            saxHandler.endDTD();
        }
        String exportNodeName = this.getExportNodeName();
        Element exportNode = doc.addElement(exportNodeName);
        this.getSaxWriter().writeOpen(exportNode);
        Element info = exportNode.addElement("info");
        info.addElement("creator").addText(this.getCms().getRequestContext().currentUser().getName());
        info.addElement("opencms_version").addText(OpenCms.getSystemInfo().getVersionNumber());
        info.addElement("createdate").addText(CmsDateUtil.getHeaderDate(System.currentTimeMillis()));
        info.addElement("infoproject").addText(this.getCms().getRequestContext().currentProject().getName());
        info.addElement("export_version").addText("7");
        this.digestElement(exportNode, info);
        return exportNode;
    }

    protected void setExportZipStream(ZipOutputStream exportZipStream) {
        this.m_exportZipStream = exportZipStream;
    }

    protected void setSaxWriter(SAXWriter saxWriter) {
        this.m_saxWriter = saxWriter;
    }

    protected String trimResourceName(String resourceName) {
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        }
        if (resourceName.endsWith("/")) {
            resourceName = resourceName.substring(0, resourceName.length() - 1);
        }
        return resourceName;
    }
}

