/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.importexport;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.importexport.CmsImportExportException;
import org.opencms.importexport.CmsImportParameters;
import org.opencms.importexport.I_CmsImport;
import org.opencms.importexport.Messages;
import org.opencms.main.CmsEvent;
import org.opencms.main.OpenCms;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.xml.CmsXmlException;

public class CmsImport {
    protected CmsObject m_cms;
    protected I_CmsReport m_report;
    protected List m_importImplementations;

    public CmsImport() {
    }

    public CmsImport(CmsObject cms, I_CmsReport report) throws CmsRoleViolationException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.DATABASE_MANAGER);
        this.m_importImplementations = OpenCms.getImportExportManager().getImportVersionClasses();
        this.m_cms = cms;
        this.m_report = report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importData(CmsImportParameters parameters) throws CmsImportExportException, CmsXmlException {
        boolean run = false;
        try {
            Iterator i = this.m_importImplementations.iterator();
            while (i.hasNext()) {
                I_CmsImport importVersion = (I_CmsImport)i.next();
                if (!importVersion.matches(parameters)) continue;
                this.m_report.println(Messages.get().container("RPT_IMPORT_VERSION_1", String.valueOf(importVersion.getVersion())), 3);
                importVersion.importData(this.m_cms, this.m_report, parameters);
                run = true;
                break;
            }
            if (!run) {
                this.m_report.println(Messages.get().container("RPT_IMPORT_DB_NO_CLASS_1", parameters.getPath()), 1);
            }
        }
        finally {
            OpenCms.fireCmsEvent(new CmsEvent(16, Collections.EMPTY_MAP));
        }
    }
}

