/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.importexport;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.db.CmsUserExportSettings;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.importexport.CmsExtendedHtmlImportDefault;
import org.opencms.importexport.CmsImportExportException;
import org.opencms.importexport.CmsImportHelper;
import org.opencms.importexport.CmsImportParameters;
import org.opencms.importexport.I_CmsImport;
import org.opencms.importexport.I_CmsImportExportHandler;
import org.opencms.importexport.Messages;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.xml.CmsXmlException;

public class CmsImportExportManager {
    public static final String A_NAME = "name";
    public static final String A_TYPE = "type";
    public static final String EXPORT_MANIFEST = "manifest.xml";
    public static final String EXPORT_VERSION = "7";
    public static final String EXPORT_XMLFILENAME = "manifest.xml";
    public static final String N_ACCESS = "access";
    public static final String N_ACCESSCONTROL_ALLOWEDPERMISSIONS = "allowed";
    public static final String N_ACCESSCONTROL_DENIEDPERMISSIONS = "denied";
    public static final String N_ACCESSCONTROL_ENTRIES = "accesscontrol";
    public static final String N_ACCESSCONTROL_ENTRY = "accessentry";
    public static final String N_ACCESSCONTROL_PERMISSIONSET = "permissionset";
    public static final String N_ACCESSCONTROL_PRINCIPAL = "uuidprincipal";
    public static final String N_CREATOR = "creator";
    public static final String N_DATE = "createdate";
    public static final String N_DATECREATED = "datecreated";
    public static final String N_DATEEXPIRED = "dateexpired";
    public static final String N_DATELASTMODIFIED = "datelastmodified";
    public static final String N_DATERELEASED = "datereleased";
    public static final String N_DEFAULTGROUP = "defaultgroup";
    public static final String N_DESCRIPTION = "description";
    public static final String N_DESTINATION = "destination";
    public static final String N_EMAIL = "email";
    public static final String N_EXPORT = "export";
    public static final String N_FILE = "file";
    public static final String N_FIRSTNAME = "firstname";
    public static final String N_FLAGS = "flags";
    public static final String N_GROUPDATA = "groupdata";
    public static final String N_GROUPNAME = "groupname";
    public static final String N_ID = "id";
    public static final String N_INFO = "info";
    public static final String N_LASTMODIFIED = "lastmodified";
    public static final String N_LASTNAME = "lastname";
    public static final String N_NAME = "name";
    public static final String N_OC_VERSION = "opencms_version";
    public static final String N_PARENTGROUP = "parentgroup";
    public static final String N_PASSWORD = "password";
    public static final String N_INFO_PROJECT = "infoproject";
    public static final String N_PROPERTIES = "properties";
    public static final String N_PROPERTY = "property";
    public static final String N_PROPERTY_ATTRIB_TYPE = "type";
    public static final String N_PROPERTY_ATTRIB_TYPE_SHARED = "shared";
    public static final String N_RELATION = "relation";
    public static final String N_RELATION_ATTRIBUTE_ID = "id";
    public static final String N_RELATION_ATTRIBUTE_PATH = "path";
    public static final String N_RELATION_ATTRIBUTE_TYPE = "type";
    public static final String N_RELATIONS = "relations";
    public static final String N_SOURCE = "source";
    public static final String N_TAG_ADDRESS = "address";
    public static final String N_TYPE = "type";
    public static final String N_USER = "user";
    public static final String N_USERCREATED = "usercreated";
    public static final String N_USERDATA = "userdata";
    public static final String N_USERGROUPDATA = "usergroupdata";
    public static final String N_ORGUNITDATA = "orgunitdata";
    public static final String N_USERGROUPS = "usergroups";
    public static final String N_USERINFO = "userinfo";
    public static final String N_USERINFO_ENTRY = "entry";
    public static final String N_USERLASTMODIFIED = "userlastmodified";
    public static final String N_UUIDRESOURCE = "uuidresource";
    public static final String N_UUIDSTRUCTURE = "uuidstructure";
    public static final String N_VALUE = "value";
    public static final String N_VERSION = "export_version";
    private static final Log LOG = CmsLog.getLog(CmsImportExportManager.class);
    private boolean m_convertToXmlPage;
    private CmsExtendedHtmlImportDefault m_extendedHtmlImportDefault;
    private List m_ignoredProperties;
    private List m_immutableResources;
    private List m_importExportHandlers;
    private Map m_importGroupTranslations;
    private Map m_importUserTranslations;
    private List m_importVersionClasses;
    private boolean m_overwriteCollidingResources;
    private CmsUserExportSettings m_userExportSettings;
    private String m_webAppUrl;

    public CmsImportExportManager() {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("INIT_IMPORTEXPORT_INITIALIZING_0"));
        }
        this.m_importExportHandlers = new ArrayList();
        this.m_immutableResources = new ArrayList();
        this.m_ignoredProperties = new ArrayList();
        this.m_convertToXmlPage = true;
        this.m_importGroupTranslations = new HashMap();
        this.m_importUserTranslations = new HashMap();
        this.m_overwriteCollidingResources = true;
        this.m_importVersionClasses = new ArrayList();
    }

    public void addIgnoredProperty(String propertyName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_IGNORING_PROPERTY_1", propertyName));
        }
        this.m_ignoredProperties.add(propertyName);
    }

    public void addImmutableResource(String immutableResource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_ADDED_IMMUTABLE_RESOURCE_1", immutableResource));
        }
        this.m_immutableResources.add(immutableResource);
    }

    public void addImportExportHandler(I_CmsImportExportHandler handler) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_ADDED_IMPORTEXPORT_HANDLER_1", handler));
        }
        this.m_importExportHandlers.add(handler);
    }

    public void addImportPrincipalTranslation(String type, String from, String to) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_ADDED_PRINCIPAL_TRANSLATION_3", type, from, to));
        }
        if ("GROUP".equalsIgnoreCase(type)) {
            this.m_importGroupTranslations.put(from, to);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)Messages.get().getBundle().key("INIT_IMPORTEXPORT_ADDED_GROUP_TRANSLATION_2", from, to));
            }
        } else if ("USER".equalsIgnoreCase(type)) {
            this.m_importUserTranslations.put(from, to);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)Messages.get().getBundle().key("INIT_IMPORTEXPORT_ADDED_USER_TRANSLATION_2", from, to));
            }
        }
    }

    public void addImportVersionClass(I_CmsImport importVersionClass) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_ADDED_IMPORT_VERSION_1", importVersionClass));
        }
        this.m_importVersionClasses.add(importVersionClass);
    }

    public boolean convertToXmlPage() {
        return this.m_convertToXmlPage;
    }

    public void exportData(CmsObject cms, I_CmsImportExportHandler handler, I_CmsReport report) throws CmsConfigurationException, CmsImportExportException, CmsRoleViolationException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.DATABASE_MANAGER);
        handler.exportData(cms, report);
    }

    public CmsExtendedHtmlImportDefault getExtendedHtmlImportDefault() {
        return this.getExtendedHtmlImportDefault(false);
    }

    public CmsExtendedHtmlImportDefault getExtendedHtmlImportDefault(boolean withNull) {
        return withNull || this.m_extendedHtmlImportDefault != null ? this.m_extendedHtmlImportDefault : new CmsExtendedHtmlImportDefault();
    }

    public List getIgnoredProperties() {
        return this.m_ignoredProperties;
    }

    public List getImmutableResources() {
        return this.m_immutableResources;
    }

    /*
     * Loose catch block
     */
    public I_CmsImportExportHandler getImportExportHandler(CmsImportParameters parameters) throws CmsImportExportException {
        Document manifest;
        CmsImportHelper helper;
        block11: {
            InputStream stream = null;
            helper = new CmsImportHelper(parameters);
            helper.openFile();
            stream = helper.getFileStream("manifest.xml");
            SAXReader reader = new SAXReader(false);
            reader.setValidation(false);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            manifest = reader.read(stream);
            Object var7_9 = null;
            try {
                if (stream != null) {
                    stream.close();
                }
                break block11;
            }
            catch (Exception e) {
                // empty catch block
            }
            {
                break block11;
                catch (Throwable e) {
                    throw new CmsImportExportException(Messages.get().container("ERR_IMPORTEXPORT_FILE_NOT_FOUND_1", "manifest.xml"), e);
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                helper.closeFile();
                throw throwable;
            }
        }
        helper.closeFile();
        for (int i = 0; i < this.m_importExportHandlers.size(); ++i) {
            I_CmsImportExportHandler handler = (I_CmsImportExportHandler)this.m_importExportHandlers.get(i);
            if (!handler.matches(manifest)) continue;
            return handler;
        }
        CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_NO_HANDLER_FOUND_1", "manifest.xml");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)message.key());
        }
        throw new CmsImportExportException(message);
    }

    public List getImportExportHandlers() {
        return this.m_importExportHandlers;
    }

    public Map getImportGroupTranslations() {
        return this.m_importGroupTranslations;
    }

    public Map getImportUserTranslations() {
        return this.m_importUserTranslations;
    }

    public List getImportVersionClasses() {
        return this.m_importVersionClasses;
    }

    public String getOldWebAppUrl() {
        return this.m_webAppUrl;
    }

    public CmsUserExportSettings getUserExportSettings() {
        return this.m_userExportSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importData(CmsObject cms, I_CmsReport report, CmsImportParameters parameters) throws CmsImportExportException, CmsXmlException, CmsRoleViolationException, CmsException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.DATABASE_MANAGER);
        try {
            OpenCms.fireCmsEvent(new CmsEvent(5, Collections.EMPTY_MAP));
            I_CmsImportExportHandler handler = this.getImportExportHandler(parameters);
            handler.setImportParameters(parameters);
            handler.importData(cms, report);
        }
        finally {
            OpenCms.fireCmsEvent(new CmsEvent(5, Collections.EMPTY_MAP));
        }
    }

    public void importData(CmsObject cms, String importFile, String importPath, I_CmsReport report) throws CmsImportExportException, CmsXmlException, CmsRoleViolationException, CmsException {
        CmsImportParameters parameters = new CmsImportParameters(importFile, importPath, false);
        this.importData(cms, report, parameters);
    }

    public boolean overwriteCollidingResources() {
        return this.m_overwriteCollidingResources;
    }

    public void setConvertToXmlPage(boolean convertToXmlPage) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_SET_CONVERT_PARAMETER_1", Boolean.toString(convertToXmlPage)));
        }
        this.m_convertToXmlPage = convertToXmlPage;
    }

    public void setConvertToXmlPage(String convertToXmlPage) {
        this.setConvertToXmlPage(Boolean.valueOf(convertToXmlPage));
    }

    public void setExtendedHtmlImportDefault(CmsExtendedHtmlImportDefault extendedHtmlImportDefault) {
        this.m_extendedHtmlImportDefault = extendedHtmlImportDefault;
    }

    public void setOldWebAppUrl(String webAppUrl) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_SET_OLD_WEBAPP_URL_1", webAppUrl));
        }
        this.m_webAppUrl = webAppUrl;
    }

    public void setOverwriteCollidingResources(boolean overwriteCollidingResources) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_SET_OVERWRITE_PARAMETER_1", Boolean.toString(overwriteCollidingResources)));
        }
        this.m_overwriteCollidingResources = overwriteCollidingResources;
    }

    public void setOverwriteCollidingResources(String overwriteCollidingResources) {
        this.setOverwriteCollidingResources(Boolean.valueOf(overwriteCollidingResources));
    }

    public void setUserExportSettings(CmsUserExportSettings userExportSettings) {
        this.m_userExportSettings = userExportSettings;
    }

    public String translateGroup(String name) {
        if (this.m_importGroupTranslations == null) {
            return name;
        }
        String match = (String)this.m_importGroupTranslations.get(name);
        if (match != null) {
            return match;
        }
        return name;
    }

    public String translateUser(String name) {
        if (this.m_importUserTranslations == null) {
            return name;
        }
        String match = (String)this.m_importUserTranslations.get(name);
        if (match != null) {
            return match;
        }
        return name;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.m_immutableResources != null) {
                this.m_immutableResources.clear();
            }
            if (this.m_ignoredProperties != null) {
                this.m_ignoredProperties.clear();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }
}

