/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.importexport;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.importexport.CmsImport;
import org.opencms.importexport.CmsImportExportException;
import org.opencms.importexport.CmsImportParameters;
import org.opencms.importexport.Messages;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsFileUtil;
import org.opencms.xml.CmsXmlEntityResolver;

public class CmsImportHelper {
    private static final Log LOG = CmsLog.getLog(CmsImport.class);
    private File m_folder;
    private CmsImportParameters m_params;
    private ZipFile m_zipFile;

    public CmsImportHelper(CmsImportParameters parameters) {
        this.m_params = parameters;
    }

    public void cacheDtdSystemId(String dtdSystemLocation, String dtdFilename, String dtdUrlPrefix) {
        if (dtdSystemLocation != null) {
            try {
                String file = CmsFileUtil.readFile(dtdSystemLocation + dtdFilename, "UTF-8");
                CmsXmlEntityResolver.cacheSystemId(dtdUrlPrefix + dtdFilename, file.getBytes("UTF-8"));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)org.opencms.configuration.Messages.get().getBundle().key("LOG_CACHE_DTD_SYSTEM_ID_1", new Object[]{dtdUrlPrefix + dtdFilename + " --> " + dtdSystemLocation + dtdFilename}));
                }
            }
            catch (IOException e) {
                LOG.error((Object)org.opencms.configuration.Messages.get().getBundle().key("LOG_CACHE_DTD_SYSTEM_ID_FAILURE_1", new Object[]{dtdSystemLocation + dtdFilename}), (Throwable)e);
            }
        }
    }

    public void closeFile() {
        block3: {
            if (this.getZipFile() != null) {
                try {
                    this.getZipFile().close();
                }
                catch (IOException e) {
                    CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_CLOSING_ZIP_ARCHIVE_1", this.getZipFile().getName());
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug((Object)message.key(), (Throwable)e);
                }
            }
        }
    }

    public byte[] getFileBytes(String filename) throws CmsImportExportException {
        try {
            if (this.getZipFile() != null) {
                ZipEntry entry = this.getZipFile().getEntry(filename);
                if (entry == null && filename.startsWith("/")) {
                    entry = this.m_zipFile.getEntry(filename.substring(1));
                }
                if (entry == null) {
                    throw new ZipException(Messages.get().getBundle().key("LOG_IMPORTEXPORT_FILE_NOT_FOUND_IN_ZIP_1", filename));
                }
                InputStream stream = this.getZipFile().getInputStream(entry);
                int size = new Long(entry.getSize()).intValue();
                return CmsFileUtil.readFully(stream, size);
            }
            File file = new File(this.getFolder(), filename);
            return CmsFileUtil.readFile(file);
        }
        catch (FileNotFoundException fnfe) {
            CmsMessageContainer msg = Messages.get().container("ERR_IMPORTEXPORT_FILE_NOT_FOUND_1", filename);
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)msg.key(), (Throwable)fnfe);
            }
            throw new CmsImportExportException(msg, (Throwable)fnfe);
        }
        catch (IOException ioe) {
            CmsMessageContainer msg = Messages.get().container("ERR_IMPORTEXPORT_ERROR_READING_FILE_1", filename);
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)msg.key(), (Throwable)ioe);
            }
            throw new CmsImportExportException(msg, (Throwable)ioe);
        }
    }

    public String getFileName() {
        String result;
        String fileName = this.m_params.getPath().replace('\\', '/');
        String zipName = fileName.substring(fileName.lastIndexOf(47) + 1);
        if (zipName.toLowerCase().endsWith(".zip")) {
            result = zipName.substring(0, zipName.lastIndexOf(46));
            int pos = result.lastIndexOf(95);
            if (pos > 0) {
                result = result.substring(0, pos);
            }
        } else {
            result = zipName;
        }
        return result;
    }

    public InputStream getFileStream(String fileName) throws CmsImportExportException {
        try {
            InputStream stream = null;
            if (this.getZipFile() != null) {
                ZipEntry entry = this.getZipFile().getEntry(fileName);
                if (entry == null && fileName.startsWith("/")) {
                    entry = this.getZipFile().getEntry(fileName.substring(1));
                }
                if (entry == null) {
                    throw new ZipException(Messages.get().getBundle().key("LOG_IMPORTEXPORT_FILE_NOT_FOUND_IN_ZIP_1", fileName));
                }
                stream = this.getZipFile().getInputStream(entry);
            } else {
                File file = new File(this.getFolder(), "manifest.xml");
                stream = new FileInputStream(file);
            }
            return stream;
        }
        catch (Exception ioe) {
            CmsMessageContainer msg = Messages.get().container("ERR_IMPORTEXPORT_ERROR_READING_FILE_1", fileName);
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)msg.key(), (Throwable)ioe);
            }
            throw new CmsImportExportException(msg, (Throwable)ioe);
        }
    }

    public File getFolder() {
        return this.m_folder;
    }

    public String getLocation(Class clazz) {
        String filename = clazz.getName().replace('.', '/');
        int pos = filename.lastIndexOf(47) + 1;
        return pos > 0 ? filename.substring(0, pos) : "";
    }

    public ZipFile getZipFile() {
        return this.m_zipFile;
    }

    public void openFile() throws IOException {
        this.m_folder = new File(OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(this.m_params.getPath()));
        if (this.m_folder.isFile()) {
            this.m_zipFile = new ZipFile(this.m_params.getPath());
            this.m_folder = null;
        }
    }
}

