/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.importexport;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.Element;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.file.types.CmsResourceTypePointer;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.importexport.A_CmsImport;
import org.opencms.importexport.CmsImportExportException;
import org.opencms.importexport.CmsImportHelper;
import org.opencms.importexport.CmsImportParameters;
import org.opencms.importexport.CmsXmlPageConverter;
import org.opencms.importexport.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsUUID;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.page.CmsXmlPage;

public class CmsImportVersion3
extends A_CmsImport {
    private static final int IMPORT_VERSION = 3;
    private static final Log LOG = CmsLog.getLog(CmsImportVersion3.class);

    public CmsImportVersion3() {
        this.m_convertToXmlPage = true;
    }

    public int getVersion() {
        return 3;
    }

    public void importResources(CmsObject cms, String importPath, I_CmsReport report, File importResource, ZipFile importZip, Document docXml) throws CmsImportExportException {
        CmsImportParameters params = new CmsImportParameters(importResource != null ? importResource.getAbsolutePath() : importZip.getName(), importPath, true);
        try {
            this.importData(cms, report, params);
        }
        catch (CmsXmlException e) {
            throw new CmsImportExportException(e.getMessageContainer(), (Throwable)e);
        }
    }

    public void importData(CmsObject cms, I_CmsReport report, CmsImportParameters params) throws CmsImportExportException, CmsXmlException {
        this.initialize();
        this.m_cms = cms;
        this.m_importPath = params.getDestinationPath();
        this.m_report = report;
        this.m_linkStorage = new HashMap();
        this.m_linkPropertyStorage = new HashMap();
        CmsImportHelper helper = new CmsImportHelper(params);
        try {
            helper.openFile();
            this.m_importResource = helper.getFolder();
            this.m_importZip = helper.getZipFile();
            this.m_docXml = CmsXmlUtils.unmarshalHelper(helper.getFileBytes("manifest.xml"), null);
            if (OpenCms.getRoleManager().hasRole(this.m_cms, CmsRole.ACCOUNT_MANAGER)) {
                this.importGroups();
                this.importUsers();
            }
            this.importAllResources();
            this.convertPointerToSiblings();
        }
        catch (IOException ioe) {
            CmsMessageContainer msg = Messages.get().container("ERR_IMPORTEXPORT_ERROR_READING_FILE_1", "manifest.xml");
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)msg.key(), (Throwable)ioe);
            }
            throw new CmsImportExportException(msg, (Throwable)ioe);
        }
        finally {
            helper.closeFile();
            this.cleanUp();
        }
    }

    protected void importUser(String name, String flags, String password, String firstname, String lastname, String email, long dateCreated, Map userInfo, List userGroups) throws CmsImportExportException {
        boolean convert = false;
        Map config = OpenCms.getPasswordHandler().getConfiguration();
        if (config != null && config.containsKey("compatibility.convert.digestencoding")) {
            convert = Boolean.valueOf((String)config.get("compatibility.convert.digestencoding"));
        }
        if (convert) {
            password = this.convertDigestEncoding(password);
        }
        super.importUser(name, flags, password, firstname, lastname, email, dateCreated, userInfo, userGroups);
    }

    private void importAllResources() throws CmsImportExportException {
        List immutableResources;
        List properties = null;
        ArrayList deleteProperties = OpenCms.getImportExportManager().getIgnoredProperties();
        if (deleteProperties == null) {
            deleteProperties = new ArrayList();
        }
        if ((immutableResources = OpenCms.getImportExportManager().getImmutableResources()) == null) {
            immutableResources = Collections.EMPTY_LIST;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_IMMUTABLE_RESOURCES_SIZE_1", Integer.toString(immutableResources.size())));
        }
        this.m_convertToXmlPage = OpenCms.getImportExportManager().convertToXmlPage();
        try {
            List fileNodes = this.m_docXml.selectNodes("//file");
            int importSize = fileNodes.size();
            for (int i = 0; i < fileNodes.size(); ++i) {
                this.m_report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", String.valueOf(i + 1), String.valueOf(importSize)));
                Element currentElement = (Element)fileNodes.get(i);
                String source = this.getChildElementTextValue(currentElement, "source");
                String destination = this.getChildElementTextValue(currentElement, "destination");
                String type = this.getChildElementTextValue(currentElement, "type");
                String uuidresource = this.getChildElementTextValue(currentElement, "uuidresource");
                String timestamp = this.getChildElementTextValue(currentElement, "datelastmodified");
                long datelastmodified = timestamp != null ? Long.parseLong(timestamp) : System.currentTimeMillis();
                String userlastmodified = this.getChildElementTextValue(currentElement, "userlastmodified");
                timestamp = this.getChildElementTextValue(currentElement, "datecreated");
                long datecreated = timestamp != null ? Long.parseLong(timestamp) : System.currentTimeMillis();
                String usercreated = this.getChildElementTextValue(currentElement, "usercreated");
                String flags = this.getChildElementTextValue(currentElement, "flags");
                String translatedName = this.m_cms.getRequestContext().addSiteRoot(this.m_importPath + destination);
                if ("folder".equals(type)) {
                    translatedName = translatedName + "/";
                }
                translatedName = this.m_cms.getRequestContext().getDirectoryTranslator().translateResource(translatedName);
                boolean resourceNotImmutable = this.checkImmutable(translatedName, immutableResources);
                translatedName = this.m_cms.getRequestContext().removeSiteRoot(translatedName);
                if (resourceNotImmutable) {
                    this.m_report.print(Messages.get().container("RPT_IMPORTING_0"), 3);
                    this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", translatedName));
                    properties = this.readPropertiesFromManifest(currentElement, deleteProperties);
                    CmsResource res = this.importResource(source, destination, type, uuidresource, datelastmodified, userlastmodified, datecreated, usercreated, flags, properties);
                    ArrayList<CmsAccessControlEntry> aceList = new ArrayList<CmsAccessControlEntry>();
                    if (res != null) {
                        List acentryNodes = currentElement.selectNodes("*/accessentry");
                        for (int j = 0; j < acentryNodes.size(); ++j) {
                            Element currentEntry = (Element)acentryNodes.get(j);
                            String id = this.getChildElementTextValue(currentEntry, "uuidprincipal");
                            String acflags = this.getChildElementTextValue(currentEntry, "flags");
                            String allowed = this.getChildElementTextValue(currentEntry, "permissionset/allowed");
                            String denied = this.getChildElementTextValue(currentEntry, "permissionset/denied");
                            try {
                                String principalId = new CmsUUID().toString();
                                String principal = id.substring(id.indexOf(46) + 1, id.length());
                                if (id.startsWith("GROUP")) {
                                    principal = OpenCms.getImportExportManager().translateGroup(principal);
                                    principalId = this.m_cms.readGroup(principal).getId().toString();
                                } else {
                                    principal = OpenCms.getImportExportManager().translateUser(principal);
                                    principalId = this.m_cms.readUser(principal).getId().toString();
                                }
                                aceList.add(this.getImportAccessControlEntry(res, principalId, allowed, denied, acflags));
                                continue;
                            }
                            catch (CmsDataAccessException e) {
                                // empty catch block
                            }
                        }
                        this.importAccessControlEntries(res, aceList);
                        continue;
                    }
                    this.m_report.print(Messages.get().container("RPT_SKIPPING_0"), 3);
                    this.m_report.println(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", translatedName));
                    continue;
                }
                this.m_report.print(Messages.get().container("RPT_SKIPPING_0"), 3);
                this.m_report.println(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", translatedName));
            }
        }
        catch (Exception e) {
            this.m_report.println(e);
            this.m_report.addError(e);
            CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_RESOURCES_0");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key(), (Throwable)e);
            }
            throw new CmsImportExportException(message, (Throwable)e);
        }
    }

    private CmsResource importResource(String source, String destination, String type, String uuidresource, long datelastmodified, String userlastmodified, long datecreated, String usercreated, String flags, List properties) {
        byte[] content = null;
        CmsResource result = null;
        try {
            I_CmsResourceType resType;
            CmsUUID newUsercreated;
            CmsUUID newUserlastmodified;
            if (source != null) {
                content = this.getFileBytes(source);
            }
            int size = 0;
            if (content != null) {
                size = content.length;
            }
            try {
                newUserlastmodified = this.m_cms.readUser(userlastmodified).getId();
            }
            catch (CmsException e) {
                newUserlastmodified = this.m_cms.getRequestContext().currentUser().getId();
            }
            try {
                newUsercreated = this.m_cms.readUser(usercreated).getId();
            }
            catch (CmsException e) {
                newUsercreated = this.m_cms.getRequestContext().currentUser().getId();
            }
            if (this.m_convertToXmlPage && type.equals("newpage")) {
                if (content != null) {
                    String encoding = null;
                    encoding = CmsProperty.get("content-encoding", properties).getValue();
                    if (encoding == null) {
                        encoding = OpenCms.getSystemInfo().getDefaultEncoding();
                    }
                    CmsXmlPage xmlPage = CmsXmlPageConverter.convertToXmlPage(this.m_cms, content, this.getLocale(destination, properties), encoding);
                    content = xmlPage.marshal();
                }
                resType = OpenCms.getResourceManager().getResourceType(CmsResourceTypeXmlPage.getStaticTypeId());
            } else {
                resType = type.equals("link") ? OpenCms.getResourceManager().getResourceType(CmsResourceTypePointer.getStaticTypeId()) : (type.equals("page") ? OpenCms.getResourceManager().getResourceType(CmsResourceTypePlain.getStaticTypeId()) : OpenCms.getResourceManager().getResourceType(type));
            }
            CmsUUID newUuidresource = null;
            newUuidresource = uuidresource != null && !resType.isFolder() ? new CmsUUID(uuidresource) : new CmsUUID();
            CmsResource resource = new CmsResource(new CmsUUID(), newUuidresource, destination, resType.getTypeId(), resType.isFolder(), new Integer(flags), this.m_cms.getRequestContext().currentProject().getUuid(), CmsResource.STATE_NEW, datecreated, newUsercreated, datelastmodified, newUserlastmodified, 0L, Long.MAX_VALUE, 1, size, System.currentTimeMillis(), 0);
            if (type.equals("link")) {
                this.m_report.print(Messages.get().container("RPT_STORING_LINK_0"), 3);
                this.m_linkStorage.put(this.m_importPath + destination, new String(content));
                this.m_linkPropertyStorage.put(this.m_importPath + destination, properties);
                result = resource;
            } else {
                result = this.m_cms.importResource(destination, resource, content, properties);
            }
            if (result != null) {
                this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
            }
        }
        catch (Exception exc) {
            this.m_report.println(exc);
            this.m_report.addError(exc);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }
}

