/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import org.opencms.util.CmsStringUtil;

public class CmsContentInfoBean {
    public static final String PAGE_CONTEXT_ATTRIBUTE_NAME = "CollectorInfo";
    private String m_locale;
    private int m_pageCount = 1;
    private int m_pageIndex = 1;
    private int m_pageNavEndIndex = 1;
    private int m_pageNavLength = 10;
    private int m_pageNavStartIndex = 1;
    private int m_pageSize = -1;
    private int m_resultIndex = -1;
    private int m_resultSize = -1;

    public String getLocale() {
        return this.m_locale;
    }

    public int getPageCount() {
        return this.m_pageCount;
    }

    public int getPageIndex() {
        return this.m_pageIndex;
    }

    public int getPageNavEndIndex() {
        return this.m_pageNavEndIndex;
    }

    public int getPageNavLength() {
        return this.m_pageNavLength;
    }

    public int getPageNavStartIndex() {
        return this.m_pageNavStartIndex;
    }

    public int getPageSize() {
        return this.m_pageSize;
    }

    public int getResultIndex() {
        return this.m_resultIndex;
    }

    public int getResultSize() {
        return this.m_resultSize;
    }

    public boolean isEmptyResult() {
        return this.m_resultSize <= 0;
    }

    public boolean isFirstOnPage() {
        return this.m_resultIndex == this.m_pageCount * this.m_pageSize + 1;
    }

    public boolean isFirstResult() {
        return this.m_resultIndex == 1;
    }

    public boolean isLastOnPage() {
        return this.m_resultIndex == (this.m_pageCount + 1) * this.m_pageSize || this.isLastResult();
    }

    public boolean isLastResult() {
        return this.m_resultIndex == this.m_resultSize;
    }

    public void setLocale(String locale) {
        this.m_locale = locale;
    }

    void incResultIndex() {
        ++this.m_resultIndex;
    }

    void initPageNavIndexes() {
        if (this.m_pageIndex < this.m_pageNavLength) {
            this.m_pageNavStartIndex = 1;
            this.m_pageNavEndIndex = this.m_pageCount < this.m_pageNavLength ? this.m_pageCount : this.m_pageNavLength;
        } else {
            int middle = this.m_pageNavLength / 2;
            this.m_pageNavStartIndex = this.m_pageIndex - middle;
            this.m_pageNavEndIndex = this.m_pageNavStartIndex + this.m_pageNavLength - 1;
            if (this.m_pageNavStartIndex < 1) {
                this.m_pageNavStartIndex = 1;
            } else if (this.m_pageNavEndIndex < 1) {
                this.m_pageNavEndIndex = this.m_pageCount;
            } else if (this.m_pageNavEndIndex > this.m_pageCount) {
                this.m_pageNavEndIndex = this.m_pageCount;
                this.m_pageNavStartIndex = this.m_pageNavEndIndex - this.m_pageNavLength + 1;
                if (this.m_pageNavStartIndex < 1) {
                    this.m_pageNavStartIndex = 1;
                }
            }
        }
    }

    void initResultIndex() {
        int startIndex = 0;
        if (this.m_pageIndex > 0 && this.m_pageSize > 0) {
            startIndex = (this.m_pageIndex - 1) * this.m_pageSize;
        }
        this.m_resultIndex = startIndex > this.m_resultSize ? this.m_resultSize : startIndex;
    }

    void setPageCount(int pageCount) {
        this.m_pageCount = pageCount;
    }

    void setPageIndex(int pageIndex) {
        this.m_pageIndex = pageIndex;
    }

    void setPageIndexAsString(String pageIndex) {
        if (CmsStringUtil.isEmpty(pageIndex)) {
            return;
        }
        try {
            this.m_pageIndex = Integer.parseInt(pageIndex);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    void setPageNavEndIndex(int index) {
        this.m_pageNavEndIndex = index;
    }

    void setPageNavLength(int length) {
        this.m_pageNavLength = length;
    }

    void setPageNavLengthAsString(String pageNavLength) {
        if (CmsStringUtil.isEmpty(pageNavLength)) {
            return;
        }
        try {
            this.m_pageNavLength = Integer.parseInt(pageNavLength);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    void setPageNavStartIndex(int index) {
        this.m_pageNavStartIndex = index;
    }

    void setPageSize(int pageSize) {
        this.m_pageSize = pageSize;
    }

    void setPageSizeAsString(String pageSize) {
        if (CmsStringUtil.isEmpty(pageSize)) {
            return;
        }
        try {
            this.m_pageSize = Integer.parseInt(pageSize);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    void setResultSize(int size) {
        this.m_resultSize = size;
    }
}

