/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.jsp.CmsJspNavElement;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;

public class CmsJspNavBuilder {
    private CmsObject m_cms;
    private String m_requestUri;
    private String m_requestUriFolder;

    public CmsJspNavBuilder() {
    }

    public CmsJspNavBuilder(CmsObject cms) {
        this.init(cms);
    }

    public static String getDefaultFile(CmsObject cms, String folder) {
        if (folder.endsWith("/")) {
            ArrayList<String> defaultFolders = new ArrayList<String>();
            try {
                CmsProperty p = cms.readPropertyObject(folder, "default-file", false);
                if (!p.isNullProperty()) {
                    defaultFolders.add(p.getValue());
                }
            }
            catch (CmsException exc) {
                // empty catch block
            }
            defaultFolders.addAll(OpenCms.getDefaultFiles());
            Iterator i = defaultFolders.iterator();
            while (i.hasNext()) {
                String defaultName = (String)i.next();
                if (!cms.existsResource(folder + defaultName)) continue;
                return folder + defaultName;
            }
            return folder;
        }
        return null;
    }

    public static List getNavigationForFolder(CmsObject cms, String folder) {
        List resources;
        folder = CmsResource.getFolderPath(folder);
        ArrayList<CmsJspNavElement> result = new ArrayList<CmsJspNavElement>();
        try {
            resources = cms.getResourcesInFolder(folder, CmsResourceFilter.DEFAULT);
        }
        catch (Exception e) {
            return Collections.EMPTY_LIST;
        }
        for (int i = 0; i < resources.size(); ++i) {
            CmsResource r = (CmsResource)resources.get(i);
            CmsJspNavElement element = CmsJspNavBuilder.getNavigationForResource(cms, cms.getSitePath(r));
            if (element == null || !element.isInNavigation()) continue;
            result.add(element);
        }
        Collections.sort(result);
        return result;
    }

    public static List getNavigationForFolder(CmsObject cms, String folder, int level) {
        folder = CmsResource.getFolderPath(folder);
        if (level == 0) {
            return CmsJspNavBuilder.getNavigationForFolder(cms, "/");
        }
        String navfolder = CmsResource.getPathPart(folder, level);
        if (navfolder != null) {
            return CmsJspNavBuilder.getNavigationForFolder(cms, navfolder);
        }
        return Collections.EMPTY_LIST;
    }

    public static CmsJspNavElement getNavigationForResource(CmsObject cms, String resource) {
        List properties;
        try {
            properties = cms.readPropertyObjects(resource, false);
        }
        catch (Exception e) {
            return null;
        }
        int level = CmsResource.getPathLevel(resource);
        if (resource.endsWith("/")) {
            --level;
        }
        return new CmsJspNavElement(resource, CmsProperty.toMap(properties), level);
    }

    public static List getNavigationTreeForFolder(CmsObject cms, String folder, int startlevel, int endlevel) {
        folder = CmsResource.getFolderPath(folder);
        if (endlevel < startlevel) {
            return Collections.EMPTY_LIST;
        }
        int currentlevel = CmsResource.getPathLevel(folder);
        if (currentlevel < endlevel) {
            endlevel = currentlevel;
        }
        if (startlevel == endlevel) {
            return CmsJspNavBuilder.getNavigationForFolder(cms, CmsResource.getPathPart(folder, startlevel), startlevel);
        }
        ArrayList result = new ArrayList();
        float parentcount = 0.0f;
        for (int i = startlevel; i <= endlevel; ++i) {
            String currentfolder = CmsResource.getPathPart(folder, i);
            List entries = CmsJspNavBuilder.getNavigationForFolder(cms, currentfolder);
            if (parentcount > 0.0f) {
                for (int it = 0; it < entries.size(); ++it) {
                    CmsJspNavElement e = (CmsJspNavElement)entries.get(it);
                    e.setNavPosition(e.getNavPosition() + parentcount);
                }
            }
            result.addAll(entries);
            Collections.sort(result);
            float pos = 0.0f;
            int count = 0;
            String nextfolder = CmsResource.getPathPart(folder, i + 1);
            parentcount = 0.0f;
            for (int it = 0; it < result.size(); ++it) {
                pos = 10000 * ++count;
                CmsJspNavElement e = (CmsJspNavElement)result.get(it);
                e.setNavPosition(pos);
                if (!e.getResourceName().startsWith(nextfolder)) continue;
                parentcount = pos;
            }
            if (parentcount != 0.0f) continue;
            parentcount = pos;
        }
        return result;
    }

    public static List getSiteNavigation(CmsObject cms, String folder, int endLevel) {
        boolean noLimit = false;
        if (endLevel < 0) {
            noLimit = true;
        }
        ArrayList<CmsJspNavElement> list = new ArrayList<CmsJspNavElement>();
        List curnav = CmsJspNavBuilder.getNavigationForFolder(cms, folder);
        for (int i = 0; i < curnav.size(); ++i) {
            CmsJspNavElement ne = (CmsJspNavElement)curnav.get(i);
            list.add(ne);
            if (!ne.isFolderLink() || !noLimit && ne.getNavTreeLevel() >= endLevel) continue;
            List subnav = CmsJspNavBuilder.getSiteNavigation(cms, ne.getResourceName(), endLevel);
            list.addAll(subnav);
        }
        return list;
    }

    public List getNavigationBreadCrumb() {
        return this.getNavigationBreadCrumb(this.m_requestUriFolder, 0, -1, true);
    }

    public List getNavigationBreadCrumb(int startlevel, boolean currentFolder) {
        return this.getNavigationBreadCrumb(this.m_requestUriFolder, startlevel, -1, currentFolder);
    }

    public List getNavigationBreadCrumb(int startlevel, int endlevel) {
        return this.getNavigationBreadCrumb(this.m_requestUriFolder, startlevel, endlevel, true);
    }

    public List getNavigationBreadCrumb(String folder, int startlevel, int endlevel, boolean currentFolder) {
        ArrayList<CmsJspNavElement> result = new ArrayList<CmsJspNavElement>();
        int level = CmsResource.getPathLevel(folder);
        if (!currentFolder) {
            --level;
        }
        if (level < endlevel || endlevel == -1) {
            endlevel = level;
        }
        if (startlevel < 0 && (startlevel = endlevel + startlevel + 1) < 0) {
            startlevel = 0;
        }
        for (int i = startlevel; i <= endlevel; ++i) {
            String navFolder = CmsResource.getPathPart(folder, i);
            CmsJspNavElement e = this.getNavigationForResource(navFolder);
            result.add(e);
        }
        return result;
    }

    public List getNavigationForFolder() {
        return CmsJspNavBuilder.getNavigationForFolder(this.m_cms, this.m_requestUriFolder);
    }

    public List getNavigationForFolder(int level) {
        return CmsJspNavBuilder.getNavigationForFolder(this.m_cms, this.m_requestUriFolder, level);
    }

    public List getNavigationForFolder(String folder) {
        return CmsJspNavBuilder.getNavigationForFolder(this.m_cms, folder);
    }

    public List getNavigationForFolder(String folder, int level) {
        return CmsJspNavBuilder.getNavigationForFolder(this.m_cms, folder, level);
    }

    public CmsJspNavElement getNavigationForResource() {
        return CmsJspNavBuilder.getNavigationForResource(this.m_cms, this.m_requestUri);
    }

    public CmsJspNavElement getNavigationForResource(String resource) {
        return CmsJspNavBuilder.getNavigationForResource(this.m_cms, resource);
    }

    public List getNavigationTreeForFolder(int startlevel, int endlevel) {
        return CmsJspNavBuilder.getNavigationTreeForFolder(this.m_cms, this.m_requestUriFolder, startlevel, endlevel);
    }

    public List getNavigationTreeForFolder(String folder, int startlevel, int endlevel) {
        return CmsJspNavBuilder.getNavigationTreeForFolder(this.m_cms, folder, startlevel, endlevel);
    }

    public List getSiteNavigation() {
        return CmsJspNavBuilder.getSiteNavigation(this.m_cms, "/", -1);
    }

    public List getSiteNavigation(String folder, int endLevel) {
        return CmsJspNavBuilder.getSiteNavigation(this.m_cms, folder, endLevel);
    }

    public void init(CmsObject cms) {
        this.m_cms = cms;
        this.m_requestUri = this.m_cms.getRequestContext().getUri();
        this.m_requestUriFolder = CmsResource.getFolderPath(this.m_requestUri);
    }
}

