/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.Map;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessages;
import org.opencms.workplace.CmsWorkplace;

public class CmsJspNavElement
implements Comparable {
    private String m_fileName;
    private Boolean m_hasNav;
    private int m_navTreeLevel = Integer.MIN_VALUE;
    private float m_position;
    private Map m_properties;
    private String m_resource;
    private String m_text;

    public CmsJspNavElement() {
    }

    public CmsJspNavElement(String resource, Map properties) {
        this.init(resource, properties, -1);
    }

    public CmsJspNavElement(String resource, Map properties, int navTreeLevel) {
        this.init(resource, properties, navTreeLevel);
    }

    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (obj instanceof CmsJspNavElement) {
            float pos = ((CmsJspNavElement)obj).getNavPosition();
            if (this.m_position == pos) {
                return 0;
            }
            return this.m_position < pos ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsJspNavElement) {
            return ((CmsJspNavElement)obj).m_resource.equals(this.m_resource);
        }
        return false;
    }

    public String getDescription() {
        return (String)this.m_properties.get("Description");
    }

    public String getFileName() {
        if (this.m_fileName == null) {
            this.m_fileName = !this.m_resource.endsWith("/") ? this.m_resource.substring(this.m_resource.lastIndexOf("/") + 1, this.m_resource.length()) : this.m_resource.substring(this.m_resource.substring(0, this.m_resource.length() - 1).lastIndexOf("/") + 1, this.m_resource.length());
        }
        return this.m_fileName;
    }

    public String getInfo() {
        return (String)this.m_properties.get("NavInfo");
    }

    public String getLocale() {
        return (String)this.m_properties.get("locale");
    }

    public String getNavImage() {
        return (String)this.m_properties.get("NavImage");
    }

    public float getNavPosition() {
        return this.m_position;
    }

    public String getNavText() {
        if (this.m_text == null) {
            this.m_text = (String)this.m_properties.get("NavText");
            if (this.m_text == null) {
                this.m_text = CmsMessages.formatUnknownKey("NavText");
            }
        }
        return this.m_text;
    }

    public int getNavTreeLevel() {
        if (this.m_navTreeLevel < 0) {
            this.m_navTreeLevel = CmsResource.getPathLevel(this.m_resource);
        }
        return this.m_navTreeLevel;
    }

    public String getParentFolderName() {
        return CmsResource.getParentFolder(this.m_resource);
    }

    public Map getProperties() {
        return this.m_properties;
    }

    public String getProperty(String key) {
        return (String)this.m_properties.get(key);
    }

    public String getResourceName() {
        return this.m_resource;
    }

    public String getTitle() {
        return (String)this.m_properties.get("Title");
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void init(String resource, Map properties) {
        this.init(resource, properties, -1);
    }

    public void init(String resource, Map properties, int navTreeLevel) {
        this.m_resource = resource;
        this.m_properties = properties;
        this.m_navTreeLevel = navTreeLevel;
        this.m_position = Float.MAX_VALUE;
        try {
            this.m_position = Float.parseFloat((String)this.m_properties.get("NavPos"));
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public boolean isFolderLink() {
        return this.m_resource.endsWith("/");
    }

    public boolean isInNavigation() {
        if (this.m_hasNav == null) {
            Object o1 = this.m_properties.get("NavText");
            Object o2 = this.m_properties.get("NavPos");
            this.m_hasNav = (o1 != null || o2 != null) && !CmsWorkplace.isTemporaryFileName(this.m_resource);
        }
        return this.m_hasNav;
    }

    public void setNavPosition(float value) {
        this.m_position = value;
    }
}

