/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.Locale;
import java.util.Properties;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsMessages;
import org.opencms.jsp.util.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsMultiException;
import org.opencms.main.I_CmsThrowable;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;

public class CmsErrorBean {
    public static final String ERRORPAGE = "org/opencms/jsp/util/errorpage.properties";
    private String m_buttons;
    private CmsObject m_cms;
    private String m_errorMessage;
    private String m_hiddenParams;
    private Locale m_locale;
    private CmsMessages m_messages;
    private String m_paramAction;
    private Throwable m_throwable;
    private String m_title;

    public CmsErrorBean(CmsObject cms, Throwable throwable) {
        this.m_cms = cms;
        CmsUser user = cms.getRequestContext().currentUser();
        CmsUserSettings settings = new CmsUserSettings(user);
        this.m_locale = settings.getLocale();
        this.m_throwable = throwable;
        this.m_messages = Messages.get().getBundle(this.m_locale);
    }

    public String getDefaultButtonsHtml() {
        StringBuffer result = new StringBuffer();
        String closeLabel = this.m_messages.key("GUI_CLOSE_0", new Object[0]);
        String detailsLabel = this.m_messages.key("GUI_DETAILS_0", new Object[0]);
        result.append("<div class=\"dialogbuttons\" unselectable=\"on\">");
        result.append("<input name=\"close\" type=\"button\" value=\"").append(closeLabel).append("\" onclick=\"closeDialog();\" class=\"dialogbutton\">");
        result.append("<input name=\"details\" type=\"button\" value=\"").append(detailsLabel).append("\" class=\"dialogbutton\" onclick=\"toggleElement('errordetails');\">");
        result.append("</div>");
        return result.toString();
    }

    public String getErrorMessage() {
        StringBuffer result = new StringBuffer(512);
        String reason = this.m_messages.key("GUI_REASON_0", new Object[0]);
        if (CmsStringUtil.isNotEmpty(this.m_errorMessage)) {
            result.append(this.m_errorMessage);
            result.append("\n").append(reason).append(": ");
        }
        result.append(this.getMessage(this.m_throwable));
        for (Throwable cause = this.m_throwable.getCause(); cause != null; cause = cause.getCause()) {
            result.append("\n").append(reason).append(": ");
            result.append(this.getMessage(cause));
        }
        return result.toString();
    }

    public String getMessage(Throwable t) {
        if (t instanceof I_CmsThrowable && ((I_CmsThrowable)((Object)t)).getMessageContainer() != null) {
            CmsMultiException exc;
            String message;
            StringBuffer result = new StringBuffer(256);
            if (this.m_throwable instanceof CmsMultiException && CmsStringUtil.isNotEmpty(message = (exc = (CmsMultiException)this.m_throwable).getMessage(this.m_locale))) {
                result.append(message);
                result.append('\n');
            }
            I_CmsThrowable cmsThrowable = (I_CmsThrowable)((Object)t);
            result.append(cmsThrowable.getLocalizedMessage(this.m_locale));
            return result.toString();
        }
        String message = t.getMessage();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(message)) {
            message = this.m_messages.key("GUI_ERROR_UNKNOWN_0");
        }
        return message;
    }

    public void setButtons(String buttons) {
        this.m_buttons = buttons;
    }

    public void setErrorMessage(String errorMessage) {
        this.m_errorMessage = errorMessage;
    }

    public void setHiddenParams(String hiddenParams) {
        this.m_hiddenParams = hiddenParams;
    }

    public void setParamAction(String paramAction) {
        this.m_paramAction = paramAction;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public String toHtml() {
        CmsMacroResolver resolver = new CmsMacroResolver();
        if (CmsStringUtil.isEmpty(this.m_title)) {
            this.m_title = this.m_messages.key("GUI_ERROR_0", new Object[0]);
        }
        resolver.addMacro("title", this.m_title);
        resolver.addMacro("label_error", this.m_messages.key("GUI_ERROR_0", new Object[0]));
        resolver.addMacro("errorstack", CmsException.getFormattedErrorstack(this.m_throwable));
        resolver.addMacro("message", CmsStringUtil.escapeHtml(this.getErrorMessage()));
        resolver.addMacro("styleuri", OpenCms.getLinkManager().substituteLink(this.m_cms, "/system/workplace/commons/style/workplace.css"));
        if (CmsStringUtil.isEmpty(this.m_buttons)) {
            resolver.addMacro("buttons", this.getDefaultButtonsHtml());
        } else {
            resolver.addMacro("buttons", this.m_buttons);
            resolver.addMacro("paramaction", this.m_paramAction);
        }
        if (CmsStringUtil.isNotEmpty(this.m_hiddenParams)) {
            resolver.addMacro("hiddenparams", this.m_hiddenParams);
        }
        resolver.addMacro("erroricon", OpenCms.getLinkManager().substituteLink(this.m_cms, "/system/workplace/resources/commons/error.png"));
        Properties errorpage = new Properties();
        try {
            errorpage.load(CmsErrorBean.class.getClassLoader().getResourceAsStream(ERRORPAGE));
        }
        catch (Throwable th) {
            CmsLog.INIT.error((Object)org.opencms.main.Messages.get().getBundle().key("INIT_ERR_LOAD_HTML_PROPERTY_FILE_1", ERRORPAGE), th);
        }
        return resolver.resolveMacros(errorpage.getProperty("ERRORPAGE"));
    }
}

