/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.LazyMap;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.jsp.util.CmsJspContentAccessBean;
import org.opencms.jsp.util.CmsJspElFunctions;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.staticexport.CmsLinkManager;

public final class CmsJspVfsAccessBean {
    public static final String ATTRIBUTE_VFS_ACCESS_BEAN = CmsJspVfsAccessBean.class.getName() + ".VFS_ACCESS_BEAN";
    private CmsObject m_cms;
    private Map m_existsResource;
    private Map m_existsXml;
    private Map m_links;
    private Map m_properties;
    private Map m_propertiesSearch;
    private Map m_resources;
    private Map m_xmlContent;

    private CmsJspVfsAccessBean(CmsObject cms) {
        this.m_cms = cms;
    }

    public static CmsJspVfsAccessBean create(CmsObject cms) {
        CmsJspVfsAccessBean result;
        Object attribute = cms.getRequestContext().getAttribute(ATTRIBUTE_VFS_ACCESS_BEAN);
        if (attribute != null) {
            result = (CmsJspVfsAccessBean)attribute;
        } else {
            result = new CmsJspVfsAccessBean(cms);
            cms.getRequestContext().setAttribute(ATTRIBUTE_VFS_ACCESS_BEAN, result);
        }
        return result;
    }

    public CmsObject getCmsObject() {
        return this.m_cms;
    }

    public CmsRequestContext getContext() {
        return this.getRequestContext();
    }

    public Map getExists() {
        return this.getExistsResource();
    }

    public Map getExistsResource() {
        if (this.m_existsResource == null) {
            this.m_existsResource = LazyMap.decorate(new HashMap(), (Transformer)new CmsExistsResourceTransformer());
        }
        return this.m_existsResource;
    }

    public Map getExistsXml() {
        if (this.m_existsXml == null) {
            this.m_existsXml = LazyMap.decorate(new HashMap(), (Transformer)new CmsExistsXmlTransformer());
        }
        return this.m_existsXml;
    }

    public boolean getFlushCaches() {
        this.m_resources = null;
        this.m_properties = null;
        this.m_propertiesSearch = null;
        return true;
    }

    public Map getLink() {
        if (this.m_links == null) {
            this.m_links = LazyMap.decorate(new HashMap(), (Transformer)new CmsVfsLinkTransformer());
        }
        return this.m_links;
    }

    public Map getProperty() {
        return this.getReadProperties();
    }

    public Map getPropertySearch() {
        return this.getReadPropertiesSearch();
    }

    public Map getReadProperties() {
        if (this.m_properties == null) {
            this.m_properties = LazyMap.decorate(new HashMap(), (Transformer)new CmsPropertyLoaderTransformer(false));
        }
        return this.m_properties;
    }

    public Map getReadPropertiesSearch() {
        if (this.m_propertiesSearch == null) {
            this.m_propertiesSearch = LazyMap.decorate(new HashMap(), (Transformer)new CmsPropertyLoaderTransformer(true));
        }
        return this.m_propertiesSearch;
    }

    public Map getReadResource() {
        if (this.m_resources == null) {
            this.m_resources = LazyMap.decorate(new HashMap(), (Transformer)new CmsResourceLoaderTransformer());
        }
        return this.m_resources;
    }

    public Map getReadXml() {
        if (this.m_xmlContent == null) {
            this.m_xmlContent = LazyMap.decorate(new HashMap(), (Transformer)new CmsXmlContentAccessTransformer());
        }
        return this.m_xmlContent;
    }

    public CmsRequestContext getRequestContext() {
        return this.m_cms.getRequestContext();
    }

    public Map getResource() {
        return this.getReadResource();
    }

    public Map getXml() {
        return this.getReadXml();
    }

    public class CmsXmlContentAccessTransformer
    implements Transformer {
        public Object transform(Object input) {
            CmsJspContentAccessBean result = null;
            CmsResource resource = (CmsResource)CmsJspVfsAccessBean.this.getReadResource().get(input);
            if (resource != null && (CmsResourceTypeXmlPage.isXmlPage(resource) || CmsResourceTypeXmlContent.isXmlContent(resource))) {
                result = new CmsJspContentAccessBean(CmsJspVfsAccessBean.this.getCmsObject(), resource);
            }
            return result;
        }
    }

    public class CmsVfsLinkTransformer
    implements Transformer {
        public Object transform(Object input) {
            return OpenCms.getLinkManager().substituteLink(CmsJspVfsAccessBean.this.getCmsObject(), CmsLinkManager.getAbsoluteUri(String.valueOf(input), CmsJspVfsAccessBean.this.getCmsObject().getRequestContext().getUri()));
        }
    }

    public class CmsResourceLoaderTransformer
    implements Transformer {
        public Object transform(Object input) {
            CmsResource result;
            try {
                result = CmsJspElFunctions.convertResource(CmsJspVfsAccessBean.this.getCmsObject(), input);
            }
            catch (CmsException e) {
                result = null;
            }
            return result;
        }
    }

    public class CmsPropertyLoaderTransformer
    implements Transformer {
        private boolean m_search;

        public CmsPropertyLoaderTransformer(boolean search) {
            this.m_search = search;
        }

        public Object transform(Object input) {
            Map result = null;
            CmsResource resource = (CmsResource)CmsJspVfsAccessBean.this.getReadResource().get(input);
            if (resource != null) {
                result = LazyMap.decorate(new HashMap(), (Transformer)new CmsPropertyLoaderSingleTransformer(resource, this.m_search));
            }
            return result == null ? Collections.EMPTY_MAP : result;
        }
    }

    public class CmsPropertyLoaderSingleTransformer
    implements Transformer {
        private CmsResource m_resource;
        private boolean m_search;

        public CmsPropertyLoaderSingleTransformer(CmsResource resource, boolean search) {
            this.m_resource = resource;
            this.m_search = search;
        }

        public Object transform(Object input) {
            String result;
            try {
                result = CmsJspVfsAccessBean.this.getCmsObject().readPropertyObject(this.m_resource, String.valueOf(input), this.m_search).getValue();
            }
            catch (CmsException e) {
                result = null;
            }
            return result;
        }
    }

    public class CmsExistsXmlTransformer
    implements Transformer {
        public Object transform(Object input) {
            CmsResource resource = (CmsResource)CmsJspVfsAccessBean.this.getReadResource().get(input);
            return resource != null && (CmsResourceTypeXmlPage.isXmlPage(resource) || CmsResourceTypeXmlContent.isXmlContent(resource));
        }
    }

    public class CmsExistsResourceTransformer
    implements Transformer {
        public Object transform(Object input) {
            return CmsJspVfsAccessBean.this.getReadResource().get(input) != null;
        }
    }
}

