/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.loader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.SocketException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.history.CmsHistoryResourceHandler;
import org.opencms.flex.CmsFlexCache;
import org.opencms.flex.CmsFlexController;
import org.opencms.flex.CmsFlexRequest;
import org.opencms.flex.CmsFlexResponse;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.util.CmsJspLinkMacroResolver;
import org.opencms.loader.CmsLoaderException;
import org.opencms.loader.I_CmsFlexCacheEnabledLoader;
import org.opencms.loader.I_CmsResourceLoader;
import org.opencms.loader.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationType;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsRequestUtil;
import org.opencms.workplace.CmsWorkplaceManager;

public class CmsJspLoader
implements I_CmsResourceLoader,
I_CmsFlexCacheEnabledLoader {
    public static final String CACHE_PROPERTY_BYPASS = "bypass";
    public static final String CACHE_PROPERTY_STREAM = "stream";
    public static final String DEFAULT_JSP_FOLDER = "/WEB-INF/jsp/";
    public static final String DIRECTIVE_END = "%>";
    public static final String DIRECTIVE_START = "<%@";
    public static final String JSP_EXTENSION = ".jsp";
    public static final String PARAM_CLIENT_CACHE_MAXAGE = "client.cache.maxage";
    public static final String PARAM_JSP_ERRORPAGE_COMMITTED = "jsp.errorpage.committed";
    public static final String PARAM_JSP_FOLDER = "jsp.folder";
    public static final String PARAM_JSP_REPOSITORY = "jsp.repository";
    public static final int RESOURCE_LOADER_ID = 6;
    private static final Log LOG = CmsLog.getLog(CmsJspLoader.class);
    private static long m_clientCacheMaxAge;
    private static String m_jspRepository;
    private static String m_jspWebAppRepository;
    private static Set m_processingFiles;
    private CmsFlexCache m_cache;
    private Map m_configuration = new TreeMap();
    private boolean m_errorPagesAreNotCommited;

    public static String getJspRepository() {
        return m_jspRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String updateJsp(CmsResource resource, CmsFlexController controller, Set updatedFiles) throws IOException, ServletException, CmsLoaderException {
        boolean isHardInclude;
        String extension;
        String jspVfsName = resource.getRootPath();
        int loaderId = OpenCms.getResourceManager().getResourceType(resource.getTypeId()).getLoaderId();
        if (loaderId == 6 && !jspVfsName.endsWith(JSP_EXTENSION)) {
            extension = JSP_EXTENSION;
            isHardInclude = false;
        } else {
            extension = "";
            isHardInclude = loaderId != 6;
        }
        String jspTargetName = CmsFileUtil.getRepositoryName(m_jspWebAppRepository, jspVfsName + extension, controller.getCurrentRequest().isOnline());
        if (updatedFiles.contains(jspTargetName)) {
            return jspTargetName;
        }
        String jspPath = CmsFileUtil.getRepositoryName(m_jspRepository, jspVfsName + extension, controller.getCurrentRequest().isOnline());
        File d = new File(jspPath).getParentFile();
        if (d == null || d.exists() && (!d.isDirectory() || !d.canRead())) {
            CmsMessageContainer message = Messages.get().container("LOG_ACCESS_DENIED_1", jspPath);
            LOG.error((Object)message.key());
            throw new ServletException(message.key());
        }
        if (!d.exists()) {
            d.mkdirs();
        }
        try {
            while (m_processingFiles.contains(jspVfsName)) {
                try {
                    Set message = m_processingFiles;
                    synchronized (message) {
                        m_processingFiles.wait(100L);
                    }
                }
                catch (InterruptedException e) {
                }
            }
            m_processingFiles.add(jspVfsName);
            boolean mustUpdate = false;
            File f = new File(jspPath);
            if (!f.exists()) {
                boolean success;
                mustUpdate = true;
                File folder = f.getParentFile();
                if (!folder.exists() && !(success = folder.mkdirs())) {
                    LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("LOG_CREATE_FOLDER_FAILED_1", folder.getAbsolutePath()));
                }
            } else if (f.lastModified() <= resource.getDateLastModified()) {
                mustUpdate = true;
            } else if (controller.getCurrentRequest().isDoRecompile()) {
                mustUpdate = true;
            } else {
                updatedFiles.add(jspTargetName);
                mustUpdate = CmsJspLoader.updateStrongLinks(resource, controller, updatedFiles);
            }
            if (mustUpdate) {
                String encoding;
                byte[] contents;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_WRITING_JSP_1", jspTargetName));
                }
                updatedFiles.add(jspTargetName);
                try {
                    CmsObject cms = controller.getCmsObject();
                    contents = cms.readFile(resource).getContents();
                    encoding = cms.readPropertyObject(resource, "content-encoding", true).getValue();
                    encoding = encoding == null ? OpenCms.getSystemInfo().getDefaultEncoding() : CmsEncoder.lookupEncoding(encoding.trim(), encoding);
                }
                catch (CmsException e) {
                    controller.setThrowable(e, jspVfsName);
                    throw new ServletException(Messages.get().getBundle().key("ERR_LOADER_JSP_ACCESS_1", jspVfsName), (Throwable)e);
                }
                try {
                    contents = CmsJspLoader.parseJsp(contents, encoding, controller, updatedFiles, isHardInclude);
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)Messages.get().getBundle().key("LOG_JSP_PERMCHECK_4", new Object[]{f.getAbsolutePath(), f.exists(), f.isFile(), f.canWrite()}));
                    }
                    Class e = CmsJspLoader.class;
                    synchronized (e) {
                        FileOutputStream fs = new FileOutputStream(f);
                        fs.write(contents);
                        fs.close();
                    }
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)Messages.get().getBundle().key("LOG_UPDATED_JSP_2", jspTargetName, jspVfsName));
                    }
                }
                catch (FileNotFoundException e) {
                    throw new ServletException(Messages.get().getBundle().key("ERR_LOADER_JSP_WRITE_1", f.getName()), (Throwable)e);
                }
            }
            controller.updateDates(f.lastModified(), Long.MAX_VALUE);
        }
        finally {
            m_processingFiles.remove(jspVfsName);
        }
        return jspTargetName;
    }

    public static void updateJspFromRequest(String servletPath, CmsFlexRequest request) {
        block11: {
            String jspUri = servletPath;
            String pathInfo = request.getPathInfo();
            if (pathInfo != null) {
                jspUri = jspUri + pathInfo;
            }
            if (jspUri == null || !jspUri.startsWith(m_jspWebAppRepository)) {
                return;
            }
            if ((jspUri = jspUri.substring(m_jspWebAppRepository.length())).startsWith("online")) {
                jspUri = jspUri.substring("online".length());
            } else if (jspUri.startsWith("offline")) {
                jspUri = jspUri.substring("offline".length());
            } else {
                return;
            }
            CmsFlexController controller = CmsFlexController.getController((ServletRequest)request);
            try {
                CmsResource includeResource;
                try {
                    includeResource = CmsJspLoader.readJspResource(controller, jspUri);
                }
                catch (CmsVfsResourceNotFoundException e) {
                    if (jspUri.endsWith(JSP_EXTENSION)) {
                        jspUri = jspUri.substring(0, jspUri.length() - JSP_EXTENSION.length());
                    }
                    includeResource = CmsJspLoader.readJspResource(controller, jspUri);
                }
                CmsJspLoader.updateJsp(includeResource, controller, new HashSet(8));
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block11;
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private static byte[] parseJsp(byte[] byteContent, String encoding, CmsFlexController controller, Set updatedFiles, boolean isHardInclude) {
        String content;
        try {
            content = new String(byteContent, encoding);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_UNSUPPORTED_ENC_1", controller.getCurrentRequest().getElementUri()), (Throwable)e);
            try {
                encoding = OpenCms.getSystemInfo().getDefaultEncoding();
                content = new String(byteContent, encoding);
            }
            catch (UnsupportedEncodingException e2) {
                content = new String(byteContent);
            }
        }
        content = CmsJspLoader.parseJspLinkMacros(content, controller);
        content = CmsJspLoader.parseJspCmsTag(content, controller, updatedFiles);
        content = CmsJspLoader.parseJspIncludes(content, controller, updatedFiles);
        content = CmsJspLoader.parseJspEncoding(content, encoding, isHardInclude);
        try {
            return content.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            return content.getBytes();
        }
    }

    private static String parseJspCmsTag(String content, CmsFlexController controller, Set updatedFiles) {
        int i1 = content.indexOf(DIRECTIVE_START);
        if (i1 < 0) {
            return content;
        }
        StringBuffer buf = new StringBuffer(content.length());
        int p0 = 0;
        int i2 = 0;
        int slen = DIRECTIVE_START.length();
        int elen = DIRECTIVE_END.length();
        while (i1 >= 0) {
            i2 = content.indexOf(DIRECTIVE_END, i1 + slen);
            if (i2 < 0) {
                return content;
            }
            if (i2 <= i1) continue;
            String directive = content.substring(i1 + slen, i2);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DIRECTIVE_DETECTED_3", DIRECTIVE_START, directive, DIRECTIVE_END));
            }
            int t1 = 0;
            int t2 = 0;
            int t3 = 0;
            int t4 = 0;
            int t5 = 0;
            while (directive.charAt(t1) == ' ') {
                ++t1;
            }
            String argument = null;
            if (directive.startsWith("cms", t1)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_X_DIRECTIVE_DETECTED_1", "cms"));
                }
                t2 = directive.indexOf("file", t1 + 3);
                t5 = 4;
            }
            if (t2 > 0) {
                String sub = directive.substring(t2 + t5);
                char c1 = sub.charAt(t3);
                while (c1 == ' ' || c1 == '=' || c1 == '\"') {
                    c1 = sub.charAt(++t3);
                }
                t4 = t3;
                while (c1 != '\"') {
                    c1 = sub.charAt(++t4);
                }
                if (t4 > t3) {
                    argument = sub.substring(t3, t4);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DIRECTIVE_ARG_1", argument));
                }
            }
            if (argument != null) {
                String jspname = CmsJspLoader.updateJsp(argument, controller, updatedFiles);
                if (jspname != null) {
                    directive = jspname;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_DIRECTIVE_CHANGED_3", DIRECTIVE_START, directive, DIRECTIVE_END));
                    }
                }
                buf.append(content.substring(p0, i1));
                buf.append(directive);
                p0 = i2 + elen;
                i1 = content.indexOf(DIRECTIVE_START, p0);
                continue;
            }
            buf.append(content.substring(p0, i1 + slen));
            buf.append(directive);
            p0 = i2;
            i1 = content.indexOf(DIRECTIVE_START, p0);
        }
        if (i2 > 0) {
            buf.append(content.substring(p0, content.length()));
            content = buf.toString();
        }
        return content;
    }

    private static String parseJspEncoding(String content, String encoding, boolean isHardInclude) {
        int i1 = content.indexOf(DIRECTIVE_START);
        if (i1 < 0 && isHardInclude) {
            return content;
        }
        StringBuffer buf = new StringBuffer(content.length() + 64);
        int p0 = 0;
        int i2 = 0;
        int slen = DIRECTIVE_START.length();
        boolean found = false;
        if (i1 < 0) {
            buf.append(content);
        }
        while (i1 >= 0) {
            i2 = content.indexOf(DIRECTIVE_END, i1 + slen);
            if (i2 < 0) {
                return content;
            }
            if (i2 <= i1) continue;
            String directive = content.substring(i1 + slen, i2);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DIRECTIVE_DETECTED_3", DIRECTIVE_START, directive, DIRECTIVE_END));
            }
            int t1 = 0;
            int t2 = 0;
            int t3 = 0;
            int t4 = 0;
            int t5 = 0;
            while (directive.charAt(t1) == ' ') {
                ++t1;
            }
            String argument = null;
            if (directive.startsWith("page", t1)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_X_DIRECTIVE_DETECTED_1", "page"));
                }
                t2 = directive.indexOf("pageEncoding", t1 + 4);
                t5 = 12;
                if (t2 > 0) {
                    found = true;
                }
            }
            if (t2 > 0) {
                String sub = directive.substring(t2 + t5);
                char c1 = sub.charAt(t3);
                while (c1 == ' ' || c1 == '=' || c1 == '\"') {
                    c1 = sub.charAt(++t3);
                }
                t4 = t3;
                while (c1 != '\"') {
                    c1 = sub.charAt(++t4);
                }
                if (t4 > t3) {
                    argument = sub.substring(t3, t4);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DIRECTIVE_ARG_1", argument));
                }
            }
            if (argument != null) {
                String pre = directive.substring(0, t2 + t3 + t5);
                String suf = directive.substring(t2 + t3 + t5 + argument.length());
                directive = pre + encoding + suf;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DIRECTIVE_CHANGED_3", DIRECTIVE_START, directive, DIRECTIVE_END));
                }
            }
            buf.append(content.substring(p0, i1 + slen));
            buf.append(directive);
            p0 = i2;
            i1 = content.indexOf(DIRECTIVE_START, p0);
        }
        if (i2 > 0) {
            buf.append(content.substring(p0, content.length()));
        }
        if (found) {
            content = buf.toString();
        } else if (!isHardInclude) {
            StringBuffer buf2 = new StringBuffer(buf.length() + 32);
            buf2.append("<%@ page pageEncoding=\"");
            buf2.append(encoding);
            buf2.append("\" %>");
            buf2.append(buf);
            content = buf2.toString();
        }
        return content;
    }

    private static String parseJspIncludes(String content, CmsFlexController controller, Set updatedFiles) {
        int i1 = content.indexOf(DIRECTIVE_START);
        if (i1 < 0) {
            return content;
        }
        StringBuffer buf = new StringBuffer(content.length());
        int p0 = 0;
        int i2 = 0;
        int slen = DIRECTIVE_START.length();
        while (i1 >= 0) {
            i2 = content.indexOf(DIRECTIVE_END, i1 + slen);
            if (i2 < 0) {
                return content;
            }
            if (i2 <= i1) continue;
            String directive = content.substring(i1 + slen, i2);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DIRECTIVE_DETECTED_3", DIRECTIVE_START, directive, DIRECTIVE_END));
            }
            int t1 = 0;
            int t2 = 0;
            int t3 = 0;
            int t4 = 0;
            int t5 = 0;
            while (directive.charAt(t1) == ' ') {
                ++t1;
            }
            String argument = null;
            if (directive.startsWith("include", t1)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_X_DIRECTIVE_DETECTED_1", "include"));
                }
                t2 = directive.indexOf("file", t1 + 7);
                t5 = 6;
            } else if (directive.startsWith("page", t1)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_X_DIRECTIVE_DETECTED_1", "page"));
                }
                t2 = directive.indexOf("errorPage", t1 + 4);
                t5 = 11;
            }
            if (t2 > 0) {
                String sub = directive.substring(t2 + t5);
                char c1 = sub.charAt(t3);
                while (c1 == ' ' || c1 == '=' || c1 == '\"') {
                    c1 = sub.charAt(++t3);
                }
                t4 = t3;
                while (c1 != '\"') {
                    c1 = sub.charAt(++t4);
                }
                if (t4 > t3) {
                    argument = sub.substring(t3, t4);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DIRECTIVE_ARG_1", argument));
                }
            }
            if (argument != null) {
                String pre = directive.substring(0, t2 + t3 + t5);
                String suf = directive.substring(t2 + t3 + t5 + argument.length());
                String jspname = CmsJspLoader.updateJsp(argument, controller, updatedFiles);
                if (jspname != null) {
                    directive = pre + jspname + suf;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_DIRECTIVE_CHANGED_3", DIRECTIVE_START, directive, DIRECTIVE_END));
                    }
                }
            }
            buf.append(content.substring(p0, i1 + slen));
            buf.append(directive);
            p0 = i2;
            i1 = content.indexOf(DIRECTIVE_START, p0);
        }
        if (i2 > 0) {
            buf.append(content.substring(p0, content.length()));
            content = buf.toString();
        }
        return content;
    }

    private static String parseJspLinkMacros(String content, CmsFlexController controller) {
        CmsJspLinkMacroResolver macroResolver = new CmsJspLinkMacroResolver(controller.getCmsObject(), null, true);
        return macroResolver.resolveMacros(content);
    }

    private static CmsResource readJspResource(CmsFlexController controller, String jspName) throws CmsException {
        CmsObject cms = OpenCms.initCmsObject(controller.getCmsObject());
        cms.getRequestContext().setSiteRoot("");
        return cms.readResource(jspName);
    }

    private static String updateJsp(String vfsName, CmsFlexController controller, Set updatedFiles) {
        String jspRfsName;
        block4: {
            String jspVfsName = CmsLinkManager.getAbsoluteUri(vfsName, controller.getCurrentRequest().getElementRootPath());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_UPDATE_JSP_1", jspVfsName));
            }
            try {
                CmsResource includeResource = CmsJspLoader.readJspResource(controller, jspVfsName);
                jspRfsName = CmsJspLoader.updateJsp(includeResource, controller, updatedFiles);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_NAME_REAL_FS_1", jspRfsName));
                }
            }
            catch (Exception e) {
                jspRfsName = null;
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ERR_UPDATE_1", jspVfsName), (Throwable)e);
            }
        }
        return jspRfsName;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean updateStrongLinks(CmsResource resource, CmsFlexController controller, Set updatedFiles) throws CmsLoaderException, IOException, ServletException {
        void var6_6;
        int numberOfUpdates = updatedFiles.size();
        CmsObject cms = controller.getCmsObject();
        CmsRelationFilter filter = CmsRelationFilter.TARGETS.filterType(CmsRelationType.JSP_STRONG);
        try {
            Iterator it = cms.getRelationsForResource(cms.getSitePath(resource), filter).iterator();
        }
        catch (CmsException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return false;
        }
        while (var6_6.hasNext()) {
            CmsRelation relation = (CmsRelation)var6_6.next();
            CmsResource target = null;
            try {
                target = relation.getTarget(cms, CmsResourceFilter.DEFAULT);
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                continue;
            }
            if (updatedFiles.contains(target.getRootPath())) continue;
            CmsJspLoader.updateJsp(target, controller, updatedFiles);
        }
        return numberOfUpdates < updatedFiles.size();
    }

    public void addConfigurationParameter(String paramName, String paramValue) {
        this.m_configuration.put(paramName, paramValue);
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] dump(CmsObject cms, CmsResource file, String element, Locale locale, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        byte[] result;
        block5: {
            CmsFlexController controller = CmsFlexController.getController((ServletRequest)req);
            CmsFlexController oldController = null;
            if (controller != null) {
                oldController = controller;
            }
            result = null;
            try {
                controller = this.getController(cms, file, req, res, false, false);
                if (element != null) {
                    String[] value = new String[]{element};
                    Map<String, String[]> parameters = Collections.singletonMap("__element", value);
                    controller.getCurrentRequest().addParameterMap(parameters);
                }
                result = this.dispatchJsp(controller);
                CmsFlexController.removeController((ServletRequest)req);
                Object var13_12 = null;
                if (oldController == null || controller == null) break block5;
                oldController.updateDates(controller.getDateLastModified(), controller.getDateExpires());
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                if (oldController != null && controller != null) {
                    oldController.updateDates(controller.getDateLastModified(), controller.getDateExpires());
                    CmsFlexController.setController((ServletRequest)req, oldController);
                }
                throw throwable;
            }
            CmsFlexController.setController((ServletRequest)req, oldController);
            {
            }
        }
        return result;
    }

    public byte[] export(CmsObject cms, CmsResource resource, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        CmsFlexController controller = this.getController(cms, resource, req, res, false, true);
        byte[] result = this.dispatchJsp(controller);
        CmsFlexController.removeController((ServletRequest)req);
        return result;
    }

    public Map getConfiguration() {
        return Collections.unmodifiableMap(this.m_configuration);
    }

    public int getLoaderId() {
        return 6;
    }

    public String getResourceLoaderInfo() {
        return Messages.get().getBundle().key("GUI_LOADER_JSP_DEFAULT_DESC_0");
    }

    public void initConfiguration() {
        ExtendedProperties config = new ExtendedProperties();
        config.putAll(this.m_configuration);
        m_jspRepository = config.getString(PARAM_JSP_REPOSITORY);
        if (m_jspRepository == null) {
            m_jspRepository = OpenCms.getSystemInfo().getWebApplicationRfsPath();
        }
        if (!(m_jspWebAppRepository = config.getString(PARAM_JSP_FOLDER, DEFAULT_JSP_FOLDER)).endsWith("/")) {
            m_jspWebAppRepository = m_jspWebAppRepository + "/";
        }
        m_jspRepository = CmsFileUtil.normalizePath(m_jspRepository + m_jspWebAppRepository);
        String maxAge = config.getString(PARAM_CLIENT_CACHE_MAXAGE);
        m_clientCacheMaxAge = maxAge == null ? -1L : Long.parseLong(maxAge);
        this.m_errorPagesAreNotCommited = config.getBoolean(PARAM_JSP_ERRORPAGE_COMMITTED, true);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_JSP_REPOSITORY_ABS_PATH_1", m_jspRepository));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_WEBAPP_PATH_1", m_jspWebAppRepository));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_JSP_REPOSITORY_ERR_PAGE_COMMOTED_1", (Object)this.m_errorPagesAreNotCommited));
            if (maxAge != null) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_CLIENT_CACHE_MAX_AGE_1", maxAge));
            }
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_LOADER_INITIALIZED_1", this.getClass().getName()));
        }
    }

    public boolean isStaticExportEnabled() {
        return true;
    }

    public boolean isStaticExportProcessable() {
        return true;
    }

    public boolean isUsableForTemplates() {
        return true;
    }

    public boolean isUsingUriWhenLoadingTemplate() {
        return false;
    }

    public void load(CmsObject cms, CmsResource file, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException, CmsException {
        CmsRequestContext context = cms.getRequestContext();
        if (CmsHistoryResourceHandler.isHistoryRequest((ServletRequest)req) && context.getUri().equals(context.removeSiteRoot(file.getRootPath()))) {
            this.showSource(cms, file, req, res);
        } else {
            boolean streaming = false;
            boolean bypass = false;
            String cacheProperty = cms.readPropertyObject(file, "cache", true).getValue();
            if (cacheProperty != null) {
                if (CACHE_PROPERTY_STREAM.equals(cacheProperty = cacheProperty.trim())) {
                    streaming = true;
                } else if (CACHE_PROPERTY_BYPASS.equals(cacheProperty)) {
                    streaming = true;
                    bypass = true;
                }
            }
            CmsFlexController controller = this.getController(cms, file, req, res, streaming, true);
            if (bypass || controller.isForwardMode()) {
                controller.setForwardMode(true);
                String target = CmsJspLoader.updateJsp(file, controller, new HashSet());
                req.getRequestDispatcher(target).forward((ServletRequest)controller.getCurrentRequest(), (ServletResponse)res);
            } else {
                this.dispatchJsp(controller);
            }
            if (!controller.isForwardMode()) {
                CmsFlexController.removeController((ServletRequest)req);
            }
        }
    }

    public void service(CmsObject cms, CmsResource resource, ServletRequest req, ServletResponse res) throws ServletException, IOException, CmsLoaderException {
        CmsFlexController controller = CmsFlexController.getController(req);
        String target = CmsJspLoader.updateJsp(resource, controller, new HashSet(8));
        controller.getCurrentResponse().setOnlyBuffering(true);
        controller.getCurrentRequest().getRequestDispatcherToExternal(cms.getSitePath(resource), target).include(req, res);
    }

    public void setFlexCache(CmsFlexCache cache) {
        this.m_cache = cache;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_FLEX_CACHE_0"));
        }
    }

    private byte[] dispatchJsp(CmsFlexController controller) throws ServletException, IOException {
        CmsFlexRequest f_req = controller.getCurrentRequest();
        CmsFlexResponse f_res = controller.getCurrentResponse();
        try {
            f_req.getRequestDispatcher(controller.getCmsObject().getSitePath(controller.getCmsResource())).include((ServletRequest)f_req, (ServletResponse)f_res);
        }
        catch (SocketException e) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_IGNORING_EXC_1", e.getClass().getName()), (Throwable)e);
        }
        byte[] result = null;
        HttpServletResponse res = controller.getTopResponse();
        if (!controller.isStreaming() && !f_res.isSuspended()) {
            try {
                if (!res.isCommitted() || this.m_errorPagesAreNotCommited) {
                    boolean isWorkplaceUser = CmsWorkplaceManager.isWorkplaceUser((HttpServletRequest)f_req);
                    if (controller.isTop() && !isWorkplaceUser && CmsFlexController.isNotModifiedSince((HttpServletRequest)f_req, controller.getDateLastModified())) {
                        if (f_req.getParameterMap().size() == 0) {
                            CmsFlexController.setDateExpiresHeader(res, controller.getDateExpires(), m_clientCacheMaxAge);
                        }
                        res.setStatus(304);
                        return null;
                    }
                    result = f_res.getWriterBytes();
                    HttpServletRequest req = controller.getTopRequest();
                    if (req.getHeader("OpenCms-Export") != null) {
                        req.setAttribute("OpenCms-Export", (Object)new Long(controller.getDateLastModified()));
                    } else if (controller.isTop()) {
                        res.setContentLength(result.length);
                        Integer errorCode = (Integer)req.getAttribute("org.opencms.util.CmsErrorCode");
                        if (errorCode == null) {
                            if (isWorkplaceUser) {
                                res.setDateHeader("Last-Modified", System.currentTimeMillis());
                                CmsRequestUtil.setNoCacheHeaders(res);
                            } else {
                                CmsFlexController.setDateLastModifiedHeader(res, controller.getDateLastModified());
                                if (f_req.getParameterMap().size() == 0 && controller.getDateLastModified() > -1L) {
                                    CmsFlexController.setDateExpiresHeader(res, controller.getDateExpires(), m_clientCacheMaxAge);
                                }
                            }
                            res.setStatus(200);
                        } else {
                            res.setStatus(errorCode.intValue());
                        }
                        CmsFlexResponse.processHeaders(f_res.getHeaders(), res);
                        res.getOutputStream().write(result);
                        res.getOutputStream().flush();
                    }
                }
            }
            catch (IllegalStateException e) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_IGNORING_EXC_1", e.getClass().getName()), (Throwable)e);
            }
            catch (SocketException e) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_IGNORING_EXC_1", e.getClass().getName()), (Throwable)e);
            }
        }
        return result;
    }

    private CmsFlexController getController(CmsObject cms, CmsResource resource, HttpServletRequest req, HttpServletResponse res, boolean streaming, boolean top) {
        CmsFlexController controller = null;
        if (top) {
            controller = CmsFlexController.getController((ServletRequest)req);
        }
        if (controller == null) {
            controller = new CmsFlexController(cms, resource, this.m_cache, req, res, streaming, top);
            CmsFlexController.setController((ServletRequest)req, controller);
            CmsFlexRequest f_req = new CmsFlexRequest(req, controller);
            CmsFlexResponse f_res = new CmsFlexResponse(res, controller, streaming, true);
            controller.push(f_req, f_res);
        } else if (controller.isForwardMode()) {
            controller = new CmsFlexController(cms, controller);
            CmsFlexController.setController((ServletRequest)req, controller);
        }
        return controller;
    }

    private void showSource(CmsObject cms, CmsResource file, HttpServletRequest req, HttpServletResponse res) throws CmsException, IOException {
        CmsResource historyResource = (CmsResource)((Object)CmsHistoryResourceHandler.getHistoryResource((ServletRequest)req));
        if (historyResource == null) {
            historyResource = file;
        }
        CmsFile historyFile = cms.readFile(historyResource);
        String content = new String(historyFile.getContents());
        res.setContentLength(content.length());
        res.setContentType("text/plain");
        PrintWriter out = res.getWriter();
        ((Writer)out).write(content);
    }

    static {
        m_processingFiles = Collections.synchronizedSet(new HashSet());
    }
}

