/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.loader;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.loader.CmsLoaderException;
import org.opencms.loader.I_CmsResourceLoader;
import org.opencms.loader.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public class CmsPointerLoader
implements I_CmsResourceLoader {
    public static final int RESOURCE_LOADER_ID = 4;
    private static String EXPORT_PREFIX = "<html>\n<head>\n<meta http-equiv=\"refresh\" content=\"0; url=";
    private static String EXPORT_SUFFIX = "\">\n</head>\n<body></body>\n</html>";

    public void addConfigurationParameter(String paramName, String paramValue) {
    }

    public void destroy() {
    }

    public byte[] dump(CmsObject cms, CmsResource resource, String element, Locale locale, HttpServletRequest req, HttpServletResponse res) throws CmsException {
        return cms.readFile(resource).getContents();
    }

    public byte[] export(CmsObject cms, CmsResource resource, HttpServletRequest req, HttpServletResponse res) throws IOException, CmsException {
        String pointer = new String(cms.readFile(resource).getContents());
        StringBuffer result = new StringBuffer(128);
        result.append(EXPORT_PREFIX);
        if (pointer.indexOf(58) < 0) {
            result.append(OpenCms.getLinkManager().substituteLink(cms, pointer));
        } else {
            result.append(pointer);
        }
        result.append(EXPORT_SUFFIX);
        this.load(cms, resource, req, res);
        return result.toString().getBytes(OpenCms.getSystemInfo().getDefaultEncoding());
    }

    public Map getConfiguration() {
        return null;
    }

    public int getLoaderId() {
        return 4;
    }

    public String getResourceLoaderInfo() {
        return Messages.get().getBundle().key("GUI_LOADER_POINTER_DEFAULT_DESC_0");
    }

    public void initConfiguration() {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_LOADER_INITIALIZED_1", this.getClass().getName()));
        }
    }

    public boolean isStaticExportEnabled() {
        return true;
    }

    public boolean isStaticExportProcessable() {
        return false;
    }

    public boolean isUsableForTemplates() {
        return false;
    }

    public boolean isUsingUriWhenLoadingTemplate() {
        return false;
    }

    public void load(CmsObject cms, CmsResource resource, HttpServletRequest req, HttpServletResponse res) throws IOException, CmsException {
        if (res == null || res.isCommitted()) {
            return;
        }
        String pointer = new String(cms.readFile(resource).getContents());
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(pointer)) {
            throw new CmsLoaderException(Messages.get().container("ERR_INVALID_POINTER_FILE_1", resource.getName()));
        }
        if (pointer.indexOf(58) < 0) {
            pointer = OpenCms.getLinkManager().substituteLink(cms, pointer);
        }
        res.sendRedirect(pointer);
    }

    public void service(CmsObject cms, CmsResource file, ServletRequest req, ServletResponse res) {
        throw new CmsRuntimeException(Messages.get().container("ERR_SERVICE_UNSUPPORTED_1", this.getClass().getName()));
    }
}

