/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.lock;

import org.opencms.file.CmsProject;
import org.opencms.file.CmsUser;
import org.opencms.lock.CmsLockType;
import org.opencms.util.CmsUUID;

public class CmsLock {
    private static final CmsLock NULL_LOCK = new CmsLock("", CmsUUID.getNullUUID(), new CmsProject(), CmsLockType.UNLOCKED);
    private CmsProject m_project;
    private CmsLock m_relatedLock;
    private String m_resourceName;
    private CmsLockType m_type;
    private CmsUUID m_userId;

    public CmsLock(String resourceName, CmsUUID userId, CmsProject project, CmsLockType type) {
        this.m_resourceName = resourceName;
        this.m_userId = userId;
        this.m_project = project;
        this.m_type = type;
    }

    public static CmsLock getNullLock() {
        return NULL_LOCK;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsLock) {
            CmsLock other = (CmsLock)obj;
            return other.m_resourceName.equals(this.m_resourceName) && other.m_userId.equals(this.m_userId) && other.m_project.equals(this.m_project) && other.m_type.equals(this.m_type);
        }
        return false;
    }

    public CmsLock getEditionLock() {
        if (this.isSystemLock()) {
            return this.getRelatedLock();
        }
        return this;
    }

    public CmsProject getProject() {
        return this.m_project;
    }

    public CmsUUID getProjectId() {
        return this.m_project.getUuid();
    }

    public String getResourceName() {
        return this.m_resourceName;
    }

    public CmsLock getSystemLock() {
        if (!this.isSystemLock()) {
            return this.getRelatedLock();
        }
        return this;
    }

    public CmsLockType getType() {
        return this.m_type;
    }

    public CmsUUID getUserId() {
        return this.m_userId;
    }

    public int hashCode() {
        return this.m_project.hashCode() + this.m_resourceName.hashCode() + this.m_userId.hashCode() + this.m_type.hashCode();
    }

    public boolean isDirectlyInherited() {
        return this.m_type.isDirectlyInherited();
    }

    public boolean isExclusive() {
        return this.m_type.isExclusive();
    }

    public boolean isExclusiveOwnedBy(CmsUser user) {
        return this.isExclusive() && this.isOwnedBy(user);
    }

    public boolean isExclusiveOwnedInProjectBy(CmsUser user, CmsProject project) {
        return this.isExclusive() && this.isOwnedInProjectBy(user, project);
    }

    public boolean isInherited() {
        return this.m_type.isInherited();
    }

    public boolean isInProject(CmsProject project) {
        return this.m_project.equals(project);
    }

    public boolean isLockableBy(CmsUser user) {
        if (this.getSystemLock().isPublish()) {
            return false;
        }
        if (this.getEditionLock().isUnlocked() && this.getSystemLock().isUnlocked()) {
            return true;
        }
        return this.getEditionLock().isOwnedBy(user);
    }

    public boolean isNullLock() {
        return this.isUnlocked();
    }

    public boolean isOwnedBy(CmsUser user) {
        return this.m_userId.equals(user.getId());
    }

    public boolean isOwnedInProjectBy(CmsUser user, CmsProject project) {
        return this.isOwnedBy(user) && this.isInProject(project);
    }

    public boolean isPersistent() {
        return this.m_type.isPersistent();
    }

    public boolean isPublish() {
        return this.m_type.isPublish();
    }

    public boolean isShared() {
        return this.m_type.isShared();
    }

    public boolean isSystemLock() {
        return this.m_type.isSystem();
    }

    public boolean isTemporary() {
        return this.m_type.isTemporary();
    }

    public boolean isUnlocked() {
        return this.m_type.isUnlocked();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[CmsLock: resource: ");
        buf.append(this.getResourceName());
        buf.append(", type: ");
        buf.append(this.getType());
        buf.append(", project: ");
        buf.append(this.getProjectId());
        buf.append(", user: ");
        buf.append(this.getUserId());
        if (this.getRelatedLock() != null) {
            buf.append(", related lock: ");
            buf.append(this.getRelatedLock().getType());
        }
        buf.append("]");
        return buf.toString();
    }

    protected Object clone() {
        CmsLock lock = new CmsLock(this.m_resourceName, this.m_userId, this.m_project, this.m_type);
        if (this.m_relatedLock != null && !this.m_relatedLock.isNullLock()) {
            lock.setRelatedLock(new CmsLock(this.m_relatedLock.m_resourceName, this.m_relatedLock.m_userId, this.m_relatedLock.m_project, this.m_relatedLock.m_type));
        }
        return lock;
    }

    protected CmsLock getRelatedLock() {
        if (this.m_relatedLock == null) {
            CmsLockType type = this.isSystemLock() ? CmsLockType.UNLOCKED : CmsLockType.SYSTEM_UNLOCKED;
            CmsLock lock = new CmsLock(this.getResourceName(), this.getUserId(), this.getProject(), type);
            lock.setRelatedLock(this);
            if (this.isUnlocked()) {
                return lock;
            }
            this.m_relatedLock = lock;
        }
        return this.m_relatedLock;
    }

    protected void setRelatedLock(CmsLock relatedLock) {
        if (this == NULL_LOCK) {
            throw new RuntimeException("null lock");
        }
        if (relatedLock == null || relatedLock.isUnlocked()) {
            this.m_relatedLock = null;
        } else {
            this.m_relatedLock = relatedLock;
            this.m_relatedLock.m_relatedLock = this;
        }
    }
}

