/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.mail;

public class CmsMailHost
implements Comparable {
    private String m_hostname;
    private Integer m_order;
    private String m_password;
    private String m_protocol;
    private String m_username;

    public CmsMailHost(String hostname, Integer order, String protocol, String username, String password) {
        this.m_hostname = hostname;
        this.m_protocol = protocol != null ? protocol : "smtp";
        this.m_username = username;
        this.m_password = password;
        this.m_order = order;
    }

    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (obj instanceof CmsMailHost) {
            return this.m_order.compareTo(((CmsMailHost)obj).m_order);
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsMailHost) {
            CmsMailHost other = (CmsMailHost)obj;
            return this.m_hostname.equals(other.m_hostname) && this.m_protocol.equals(other.m_protocol) && this.m_username.equals(other.m_username);
        }
        return false;
    }

    public String getHostname() {
        return this.m_hostname;
    }

    public Integer getOrder() {
        return this.m_order;
    }

    public String getPassword() {
        return this.m_password;
    }

    public String getProtocol() {
        return this.m_protocol;
    }

    public String getUsername() {
        return this.m_username;
    }

    public int hashCode() {
        return this.m_hostname.hashCode() * 1117 + this.m_protocol.hashCode() * 2003 + this.m_username.hashCode();
    }

    public boolean isAuthenticating() {
        return this.m_username != null && this.m_password != null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append(this.getClass().getName());
        buf.append(" hostname=");
        buf.append(this.getHostname());
        buf.append(" order=");
        buf.append(this.m_order);
        buf.append(" protocol=");
        buf.append(this.getProtocol());
        if (this.isAuthenticating()) {
            buf.append(" user=");
            buf.append(this.getUsername());
            buf.append(" password=");
            buf.append(this.getPassword());
        }
        return buf.toString();
    }
}

