/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.mail;

import javax.mail.MessagingException;
import org.apache.commons.logging.Log;
import org.apache.commons.mail.MultiPartEmail;
import org.opencms.mail.CmsMailHost;
import org.opencms.mail.Messages;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public class CmsMultiPartMail
extends MultiPartEmail {
    private static final Log LOG = CmsLog.getLog(CmsMultiPartMail.class);

    public CmsMultiPartMail() {
        CmsMailHost host = OpenCms.getSystemInfo().getMailSettings().getDefaultMailHost();
        this.setHostName(host.getHostname());
        String userName = host.getUsername();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(userName)) {
            this.setAuthentication(userName, host.getPassword());
        }
        try {
            this.setFrom(OpenCms.getSystemInfo().getMailSettings().getMailFromDefault());
        }
        catch (MessagingException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_INVALID_SENDER_ADDRESS_0"), (Throwable)e);
        }
    }
}

