/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.mail;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;

public class CmsVfsDataSource
implements DataSource {
    private String m_contentType;
    private CmsFile m_file;

    public CmsVfsDataSource(CmsObject cms, CmsResource resource) throws CmsException {
        this.m_file = cms.readFile(resource);
        this.m_contentType = OpenCms.getResourceManager().getMimeType(this.m_file.getName(), cms.getRequestContext().getEncoding());
    }

    public String getContentType() {
        return this.m_contentType;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.m_file.getContents());
    }

    public String getName() {
        return this.m_file.getRootPath();
    }

    public OutputStream getOutputStream() {
        return new ByteArrayOutputStream();
    }
}

