/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.FastHashMap;
import org.opencms.main.CmsSessionInfo;
import org.opencms.main.I_CmsSessionStorageProvider;
import org.opencms.util.CmsUUID;

public class CmsDefaultSessionStorageProvider
implements I_CmsSessionStorageProvider {
    private FastHashMap m_sessions;

    public CmsSessionInfo get(CmsUUID sessionId) {
        return (CmsSessionInfo)this.m_sessions.get((Object)sessionId);
    }

    public List getAll() {
        ArrayList<CmsSessionInfo> result = new ArrayList<CmsSessionInfo>();
        Iterator i = this.m_sessions.keySet().iterator();
        while (i.hasNext()) {
            CmsSessionInfo sessionInfo = (CmsSessionInfo)this.m_sessions.get(i.next());
            if (sessionInfo == null) continue;
            result.add(sessionInfo);
        }
        return result;
    }

    public List getAllOfUser(CmsUUID userId) {
        ArrayList<CmsSessionInfo> userSessions = new ArrayList<CmsSessionInfo>();
        Iterator i = this.m_sessions.keySet().iterator();
        while (i.hasNext()) {
            CmsSessionInfo sessionInfo = (CmsSessionInfo)this.m_sessions.get(i.next());
            if (!userId.equals(sessionInfo.getUserId())) continue;
            userSessions.add(sessionInfo);
        }
        return userSessions;
    }

    public int getSize() {
        return this.m_sessions.size();
    }

    public void initialize() {
        this.m_sessions = new FastHashMap();
        this.m_sessions.setFast(true);
    }

    public CmsSessionInfo put(CmsSessionInfo sessionInfo) {
        return (CmsSessionInfo)this.m_sessions.put((Object)sessionInfo.getSessionId(), (Object)sessionInfo);
    }

    public CmsSessionInfo remove(CmsUUID sessionId) {
        return (CmsSessionInfo)this.m_sessions.remove((Object)sessionId);
    }

    public void shutdown() {
        this.m_sessions.clear();
        this.m_sessions = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validate() {
        try {
            try {
                this.m_sessions.setFast(false);
                Iterator itSessions = this.m_sessions.entrySet().iterator();
                while (itSessions.hasNext()) {
                    Map.Entry entry = (Map.Entry)itSessions.next();
                    CmsUUID sessionId = (CmsUUID)entry.getKey();
                    CmsSessionInfo sessionInfo = (CmsSessionInfo)entry.getValue();
                    if (sessionInfo == null || this.m_sessions.get((Object)sessionId) == null || !sessionInfo.isExpired()) continue;
                    try {
                        itSessions.remove();
                    }
                    catch (ConcurrentModificationException ex) {}
                }
                Object var7_7 = null;
                if (this.m_sessions == null) return;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                Object var7_8 = null;
                if (this.m_sessions == null) return;
                this.m_sessions.setFast(true);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (this.m_sessions == null) throw throwable;
            this.m_sessions.setFast(true);
            throw throwable;
        }
        this.m_sessions.setFast(true);
    }
}

