/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.io.File;
import java.net.URL;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.Loader;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsSystemInfo;
import org.opencms.util.CmsFileUtil;

public final class CmsLog {
    public static final String FILE_LOG = "opencms.log";
    public static final String FOLDER_LOGS = "logs" + File.separatorChar;
    public static final Log INIT = LogFactory.getLog((String)"org.opencms.init");
    private static String m_logFileRfsPath;

    private CmsLog() {
    }

    public static Log getLog(Object obj) {
        if (obj instanceof String) {
            return LogFactory.getLog((String)((String)obj));
        }
        if (obj instanceof Class) {
            return LogFactory.getLog((Class)((Class)obj));
        }
        return LogFactory.getLog(obj.getClass());
    }

    protected static String getLogFileRfsPath() {
        return m_logFileRfsPath;
    }

    static {
        try {
            URL url = Loader.getResource((String)"log4j.properties");
            if (url != null) {
                ExtendedProperties configuration;
                boolean setLogFile;
                String path = CmsFileUtil.normalizePath(url, '/');
                String webInfPath = CmsResource.getParentFolder(CmsResource.getFolderPath(path));
                String configFilePath = webInfPath + CmsSystemInfo.FOLDER_CONFIG + "opencms.xml";
                File configFile = new File(configFilePath);
                if (configFile.exists() && (setLogFile = (configuration = new ExtendedProperties(path)).getBoolean("opencms.set.logfile", false))) {
                    String logFilePath = CmsFileUtil.normalizePath(webInfPath + FOLDER_LOGS + FILE_LOG, '/');
                    File logFile = new File(logFilePath);
                    m_logFileRfsPath = logFile.getAbsolutePath();
                    System.setProperty("opencms.logfile", m_logFileRfsPath);
                    PropertyConfigurator.configure((String)path);
                }
                INIT.info((Object)(". Log4j config file    : " + path));
            }
        }
        catch (SecurityException e) {
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

