/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import org.opencms.db.CmsDbEntryNotFoundException;
import org.opencms.db.CmsLoginMessage;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMessages;
import org.opencms.importexport.CmsExportParameters;
import org.opencms.importexport.CmsImportParameters;
import org.opencms.importexport.CmsVfsImportExportHandler;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsShell;
import org.opencms.main.CmsSystemInfo;
import org.opencms.main.I_CmsShellCommands;
import org.opencms.main.Messages;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.module.CmsModuleImportExportHandler;
import org.opencms.report.CmsShellReport;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsAccessControlList;
import org.opencms.security.CmsRole;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsUUID;

class CmsShellCommands
implements I_CmsShellCommands {
    private CmsObject m_cms;
    private CmsShell m_shell;

    protected CmsShellCommands() {
    }

    public void cd(String target) throws Exception {
        String resolvedTarget;
        CmsResource res;
        String folder = CmsResource.getFolderPath(this.m_cms.getRequestContext().getUri());
        if (!target.endsWith("/")) {
            target = target + "/";
        }
        if (!(res = this.m_cms.readResource(resolvedTarget = CmsLinkManager.getAbsoluteUri(target, folder))).isFolder()) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_NOT_A_FOLDER_1", resolvedTarget));
        }
        this.m_cms.getRequestContext().setUri(resolvedTarget);
        System.out.println('\n' + this.getMessages().key("GUI_SHELL_CURRENT_FOLDER_1", new Object[]{resolvedTarget}));
        System.out.println();
    }

    public void chacc(String resourceName, String principalType, String principalName, String permissionString) throws CmsException {
        this.m_cms.lockResource(resourceName);
        principalName = "GROUP".equalsIgnoreCase(principalType.trim()) ? OpenCms.getImportExportManager().translateGroup(principalName) : OpenCms.getImportExportManager().translateUser(principalName);
        this.m_cms.chacc(resourceName, principalType, principalName, permissionString);
    }

    public void clearCaches() throws Exception {
        OpenCms.fireCmsEvent(new CmsEvent(5, Collections.EMPTY_MAP));
    }

    public void copyright() {
        String[] copy = Messages.COPYRIGHT_BY_ALKACON;
        for (int i = 0; i < copy.length; ++i) {
            System.out.println(copy[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDefaultProject(String name, String description) throws Exception {
        String storedSiteRoot = this.m_cms.getRequestContext().getSiteRoot();
        try {
            this.m_cms.getRequestContext().setSiteRoot("/");
            CmsProject project = this.m_cms.createProject(name, description, OpenCms.getDefaultUsers().getGroupUsers(), OpenCms.getDefaultUsers().getGroupProjectmanagers(), CmsProject.PROJECT_TYPE_NORMAL);
            this.m_cms.getRequestContext().setCurrentProject(project);
            this.m_cms.copyResourceToProject("/");
        }
        finally {
            this.m_cms.getRequestContext().setSiteRoot(storedSiteRoot);
        }
        if (OpenCms.getRoleManager().hasRole(this.m_cms, CmsRole.WORKPLACE_MANAGER)) {
            OpenCms.getSearchManager().initialize(this.m_cms);
        }
    }

    public CmsResource createFolder(String targetFolder, String folderName) throws Exception {
        return this.m_cms.createResource(targetFolder + folderName, 0);
    }

    public CmsGroup createGroup(String name, String description) throws Exception {
        return this.m_cms.createGroup(name, description, 0, null);
    }

    public CmsPropertyDefinition createPropertydefinition(String name) throws Exception {
        return this.m_cms.createPropertyDefinition(name);
    }

    public CmsUser createUser(String name, String password, String description) throws Exception {
        return this.m_cms.createUser(name, password, description, new Hashtable());
    }

    public CmsUser createUser(String name, String password, String description, String firstname, String lastname, String email) throws Exception {
        CmsUser user = this.m_cms.createUser(name, password, description, new Hashtable());
        user.setEmail(email);
        user.setFirstname(firstname);
        user.setLastname(lastname);
        this.m_cms.writeUser(user);
        return user;
    }

    public void deleteBackups(int versionsToKeep) throws Exception {
        this.deleteHistoricalVersions("/", versionsToKeep, versionsToKeep, -1L);
    }

    public void deleteHistoricalVersions(String folderName, int versionsToKeep, int versionsDeleted, long timeDeleted) throws Exception {
        this.m_cms.deleteHistoricalVersions(folderName, versionsToKeep, versionsDeleted, timeDeleted, new CmsShellReport(this.m_cms.getRequestContext().getLocale()));
    }

    public void deleteModule(String moduleName) throws Exception {
        OpenCms.getModuleManager().deleteModule(this.m_cms, moduleName, false, new CmsShellReport(this.m_cms.getRequestContext().getLocale()));
    }

    public void deleteProject(String name) throws Exception {
        this.m_cms.deleteProject(this.m_cms.readProject(name).getUuid());
    }

    public void deletepropertydefinition(String name) throws Exception {
        this.m_cms.deletePropertyDefinition(name);
    }

    public void echo(String echo) {
        if (echo == null) {
            return;
        }
        boolean b = "on".equalsIgnoreCase(echo.trim());
        this.m_shell.setEcho(b);
        if (b) {
            System.out.println(this.getMessages().key("GUI_SHELL_ECHO_ON_0"));
        } else {
            System.out.println(this.getMessages().key("GUI_SHELL_ECHO_OFF_0"));
        }
    }

    public void exit() {
        this.m_shell.exit();
    }

    public void exportAllResources(String exportFile) throws Exception {
        ArrayList<String> exportPaths = new ArrayList<String>(1);
        exportPaths.add("/");
        CmsVfsImportExportHandler vfsExportHandler = new CmsVfsImportExportHandler();
        CmsExportParameters params = new CmsExportParameters(exportFile, null, true, false, false, exportPaths, true, true, 0L, true, false);
        vfsExportHandler.setExportParams(params);
        OpenCms.getImportExportManager().exportData(this.m_cms, vfsExportHandler, new CmsShellReport(this.m_cms.getRequestContext().getLocale()));
    }

    public void exportModule(String moduleName) throws Exception {
        CmsModule module = OpenCms.getModuleManager().getModule(moduleName);
        if (module == null) {
            throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_UNKNOWN_MODULE_1", moduleName));
        }
        String filename = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(OpenCms.getSystemInfo().getPackagesRfsPath() + CmsSystemInfo.FOLDER_MODULES + moduleName + "_" + OpenCms.getModuleManager().getModule(moduleName).getVersion().toString());
        String[] resources = new String[module.getResources().size()];
        System.arraycopy(module.getResources().toArray(), 0, resources, 0, resources.length);
        CmsModuleImportExportHandler moduleExportHandler = new CmsModuleImportExportHandler();
        moduleExportHandler.setFileName(filename);
        moduleExportHandler.setAdditionalResources(resources);
        moduleExportHandler.setModuleName(module.getName().replace('\\', '/'));
        moduleExportHandler.setDescription(this.getMessages().key("GUI_SHELL_IMPORTEXPORT_MODULE_HANDLER_NAME_1", new Object[]{moduleExportHandler.getModuleName()}));
        OpenCms.getImportExportManager().exportData(this.m_cms, moduleExportHandler, new CmsShellReport(this.m_cms.getRequestContext().getLocale()));
    }

    public void exportResources(String exportFile, String pathList) throws Exception {
        StringTokenizer tok = new StringTokenizer(pathList, ";");
        ArrayList<String> exportPaths = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            exportPaths.add(tok.nextToken());
        }
        boolean includeSystem = false;
        if (pathList.startsWith("/system/") || pathList.indexOf(";/system/") > -1) {
            includeSystem = true;
        }
        CmsVfsImportExportHandler vfsExportHandler = new CmsVfsImportExportHandler();
        CmsExportParameters params = new CmsExportParameters(exportFile, null, true, false, false, exportPaths, includeSystem, true, 0L, true, false);
        vfsExportHandler.setExportParams(params);
        OpenCms.getImportExportManager().exportData(this.m_cms, vfsExportHandler, new CmsShellReport(this.m_cms.getRequestContext().getLocale()));
    }

    public void exportResourcesAndUserdata(String exportFile, String pathList) throws Exception {
        StringTokenizer tok = new StringTokenizer(pathList, ";");
        ArrayList<String> exportPaths = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            exportPaths.add(tok.nextToken());
        }
        boolean includeSystem = false;
        if (pathList.startsWith("/system/") || pathList.indexOf(";/system/") > -1) {
            includeSystem = true;
        }
        CmsVfsImportExportHandler vfsExportHandler = new CmsVfsImportExportHandler();
        CmsExportParameters params = new CmsExportParameters(exportFile, null, true, true, false, exportPaths, includeSystem, true, 0L, true, false);
        vfsExportHandler.setExportParams(params);
        OpenCms.getImportExportManager().exportData(this.m_cms, vfsExportHandler, new CmsShellReport(this.m_cms.getRequestContext().getLocale()));
    }

    public void getAcl(String resourceName) throws Exception {
        CmsAccessControlList acList = this.m_cms.getAccessControlList(resourceName);
        Iterator principals = acList.getPrincipals().iterator();
        while (principals.hasNext()) {
            I_CmsPrincipal p = this.m_cms.lookupPrincipal((CmsUUID)principals.next());
            System.out.println(p.getName() + ": " + acList.getPermissions(p.getId()).getPermissionString());
        }
    }

    public void getLocales() {
        System.out.println(this.getMessages().key("GUI_SHELL_LOCALES_AVAILABLE_0"));
        Locale[] locales = Locale.getAvailableLocales();
        for (int i = locales.length - 1; i >= 0; --i) {
            System.out.println("  \"" + locales[i].toString() + "\"");
        }
    }

    public void help() {
        System.out.println();
        System.out.println(this.getMessages().key("GUI_SHELL_HELP1_0"));
        System.out.println(this.getMessages().key("GUI_SHELL_HELP2_0"));
        System.out.println(this.getMessages().key("GUI_SHELL_HELP3_0"));
        System.out.println(this.getMessages().key("GUI_SHELL_HELP4_0"));
        System.out.println();
    }

    public void help(String command) {
        if ("*".equalsIgnoreCase(command)) {
            this.m_shell.help(null);
        } else if ("help".equalsIgnoreCase(command)) {
            this.help();
        } else {
            this.m_shell.help(command);
        }
    }

    public void importModule(String importFile) throws Exception {
        CmsImportParameters params = new CmsImportParameters(importFile, "/", true);
        OpenCms.getImportExportManager().importData(this.m_cms, new CmsShellReport(this.m_cms.getRequestContext().getLocale()), params);
    }

    public void importModuleFromDefault(String importFile) throws Exception {
        String exportPath = OpenCms.getSystemInfo().getPackagesRfsPath();
        String fileName = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(exportPath + CmsSystemInfo.FOLDER_MODULES + importFile);
        CmsImportParameters params = new CmsImportParameters(fileName, "/", true);
        OpenCms.getImportExportManager().importData(this.m_cms, new CmsShellReport(this.m_cms.getRequestContext().getLocale()), params);
    }

    public void importModulesFromSetupBean() {
    }

    public void importResources(String importFile, String importPath) throws Exception {
        CmsImportParameters params = new CmsImportParameters(OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(importFile), importPath, true);
        OpenCms.getImportExportManager().importData(this.m_cms, new CmsShellReport(this.m_cms.getRequestContext().getLocale()), params);
    }

    public void importResourcesWithTempProject(String importFile) throws Exception {
        CmsProject project = this.m_cms.createProject("SystemUpdate", this.getMessages().key("GUI_SHELL_IMPORT_TEMP_PROJECT_NAME_0"), OpenCms.getDefaultUsers().getGroupAdministrators(), OpenCms.getDefaultUsers().getGroupAdministrators(), CmsProject.PROJECT_TYPE_TEMPORARY);
        CmsUUID id = project.getUuid();
        this.m_cms.getRequestContext().setCurrentProject(project);
        this.m_cms.copyResourceToProject("/");
        CmsImportParameters params = new CmsImportParameters(importFile, "/", true);
        OpenCms.getImportExportManager().importData(this.m_cms, new CmsShellReport(this.m_cms.getRequestContext().getLocale()), params);
        this.m_cms.unlockProject(id);
        OpenCms.getPublishManager().publishProject(this.m_cms);
        OpenCms.getPublishManager().waitWhileRunning();
    }

    public void initShellCmsObject(CmsObject cms, CmsShell shell) {
        this.m_cms = cms;
        this.m_shell = shell;
    }

    public void listModules() throws Exception {
        Set modules = OpenCms.getModuleManager().getModuleNames();
        System.out.println("\n" + this.getMessages().key("GUI_SHELL_LIST_MODULES_1", new Integer(modules.size())));
        Iterator i = modules.iterator();
        while (i.hasNext()) {
            String moduleName = (String)i.next();
            System.out.println(moduleName);
        }
        System.out.println();
    }

    public void login(String username, String password) {
        username = OpenCms.getImportExportManager().translateUser(username);
        try {
            this.m_cms.loginUser(username, password);
            this.m_shell.initSettings();
            System.out.println(this.getMessages().key("GUI_SHELL_LOGIN_1", this.whoami().getName()));
            CmsLoginMessage message = OpenCms.getLoginManager().getLoginMessage();
            if (message != null && message.isActive()) {
                System.out.println(message.getMessage());
            }
        }
        catch (Exception exc) {
            System.out.println(this.getMessages().key("GUI_SHELL_LOGIN_FAILED_0"));
        }
    }

    public void ls() throws Exception {
        String folder = CmsResource.getFolderPath(this.m_cms.getRequestContext().getUri());
        List resources = this.m_cms.getResourcesInFolder(folder, CmsResourceFilter.IGNORE_EXPIRATION);
        System.out.println("\n" + this.getMessages().key("GUI_SHELL_LS_2", folder, new Integer(resources.size())));
        Iterator i = resources.iterator();
        while (i.hasNext()) {
            CmsResource r = (CmsResource)i.next();
            System.out.println(this.m_cms.getSitePath(r));
        }
        System.out.println();
    }

    public void lsacc(String resourceName) throws Exception {
        List acList = this.m_cms.getAccessControlEntries(resourceName);
        for (int i = 0; i < acList.size(); ++i) {
            CmsAccessControlEntry ace = (CmsAccessControlEntry)acList.get(i);
            I_CmsPrincipal acePrincipal = this.m_cms.lookupPrincipal(ace.getPrincipal());
            String pName = acePrincipal != null ? acePrincipal.getName() : ace.getPrincipal().toString();
            System.out.println(pName + ": " + ace.getPermissions().getPermissionString() + " " + ace);
        }
    }

    public void lsacc(String resourceName, String principalName) throws Exception {
        I_CmsPrincipal principal = this.m_cms.lookupPrincipal(principalName);
        List acList = this.m_cms.getAccessControlEntries(resourceName);
        for (int i = 0; i < acList.size(); ++i) {
            CmsAccessControlEntry ace = (CmsAccessControlEntry)acList.get(i);
            I_CmsPrincipal acePrincipal = this.m_cms.lookupPrincipal(ace.getPrincipal());
            if (!((Object)principal).equals(acePrincipal)) continue;
            String pName = acePrincipal != null ? acePrincipal.getName() : ace.getPrincipal().toString();
            System.out.println(pName + ": " + ace.getPermissions().getPermissionString() + " " + ace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perf() throws Exception {
        int maxTests = 50000;
        String storedSiteRoot = this.m_cms.getRequestContext().getSiteRoot();
        try {
            this.m_cms.getRequestContext().setSiteRoot("/");
            Random random = new Random();
            List testResources = this.m_cms.readResources("/", CmsResourceFilter.ALL);
            int resourceCount = testResources.size();
            System.out.println("#Resources:\t" + resourceCount);
            long totalTime = 0L;
            long minTime = Long.MAX_VALUE;
            long maxTime = Long.MIN_VALUE;
            System.out.print("readFileHeader:\t");
            for (int i = maxTests; i > 0; --i) {
                int index = random.nextInt(resourceCount);
                CmsResource resource = (CmsResource)testResources.get(index);
                long start = System.currentTimeMillis();
                this.m_cms.readResource(this.m_cms.getSitePath(resource), CmsResourceFilter.ALL);
                long time = System.currentTimeMillis() - start;
                totalTime += time;
                if (time < minTime) {
                    minTime = time;
                }
                if (time > maxTime) {
                    maxTime = time;
                }
                if (i % 100 != 0) continue;
                System.out.print('.');
            }
            System.out.println("\nreadFileHeader:\t" + minTime + "\t" + maxTime + "\t" + (float)totalTime / (float)maxTests + " ms");
        }
        finally {
            this.m_cms.getRequestContext().setSiteRoot(storedSiteRoot);
        }
    }

    public void prompt(String prompt) {
        this.m_shell.setPrompt(prompt);
    }

    public void publishProjectAndWait() throws Exception {
        OpenCms.getPublishManager().publishProject(this.m_cms);
        OpenCms.getPublishManager().waitWhileRunning();
    }

    public void purgeJspRepository() throws Exception {
        OpenCms.fireCmsEvent(new CmsEvent(8, new HashMap(0)));
    }

    public String pwd() throws Exception {
        return CmsResource.getFolderPath(this.m_cms.getRequestContext().getUri());
    }

    public void quit() {
        this.exit();
    }

    public String readFileContent(String filename) throws CmsException {
        filename = CmsLinkManager.getAbsoluteUri(filename, CmsResource.getFolderPath(this.m_cms.getRequestContext().getUri()));
        CmsFile file = this.m_cms.readFile(filename, CmsResourceFilter.IGNORE_EXPIRATION);
        return new String(file.getContents());
    }

    public CmsGroup readGroupOfProject(CmsUUID project) throws Exception {
        return this.m_cms.readGroup(this.m_cms.readProject(project));
    }

    public CmsGroup readManagerGroup(CmsUUID project) throws Exception {
        return this.m_cms.readManagerGroup(this.m_cms.readProject(project));
    }

    public CmsUser readOwnerOfProject(CmsUUID project) throws Exception {
        return this.m_cms.readOwner(this.m_cms.readProject(project));
    }

    public void rebuildAllIndexes() throws Exception {
        CmsShellReport report = new CmsShellReport(this.m_cms.getRequestContext().getLocale());
        OpenCms.getSearchManager().rebuildAllIndexes(report);
    }

    public void rebuildIndex(String index) throws Exception {
        OpenCms.getSearchManager().rebuildIndex(index, new CmsShellReport(this.m_cms.getRequestContext().getLocale()));
    }

    public void replaceModule(String moduleName, String importFile) throws Exception {
        if (OpenCms.getModuleManager().getModule(moduleName) != null) {
            OpenCms.getModuleManager().deleteModule(this.m_cms, moduleName, true, new CmsShellReport(this.m_cms.getRequestContext().getLocale()));
        }
        this.importModule(importFile);
    }

    public void replaceModuleFromDefault(String moduleName, String importFile) throws Exception {
        if (OpenCms.getModuleManager().getModule(moduleName) != null) {
            OpenCms.getModuleManager().deleteModule(this.m_cms, moduleName, true, new CmsShellReport(this.m_cms.getRequestContext().getLocale()));
        }
        this.importModuleFromDefault(importFile);
    }

    public CmsProject setCurrentProject(CmsUUID id) throws Exception {
        return this.m_cms.getRequestContext().setCurrentProject(this.m_cms.readProject(id));
    }

    public CmsProject setCurrentProject(String name) throws Exception {
        return this.m_cms.getRequestContext().setCurrentProject(this.m_cms.readProject(name));
    }

    public void setLocale(String localeName) throws CmsException {
        Locale locale = CmsLocaleManager.getLocale(localeName);
        System.out.println(this.getMessages().key("GUI_SHELL_SETLOCALE_2", locale, this.m_cms.getRequestContext().currentUser().getName()));
        this.m_shell.setLocale(locale);
        System.out.println(this.getMessages().key("GUI_SHELL_SETLOCALE_POST_1", locale));
    }

    public void shellExit() {
        System.out.println();
        System.out.println(this.getMessages().key("GUI_SHELL_GOODBYE_0"));
    }

    public void shellStart() {
        System.out.println();
        System.out.println(this.getMessages().key("GUI_SHELL_WELCOME_0"));
        System.out.println();
        this.version();
        this.copyright();
        this.help();
    }

    public void unlockCurrentProject() throws Exception {
        this.m_cms.unlockProject(this.m_cms.getRequestContext().currentProject().getUuid());
    }

    public CmsResource uploadFile(String localfile, String folder, String filename, String type) throws Exception, CmsIllegalArgumentException {
        int t = OpenCms.getResourceManager().getResourceType(type).getTypeId();
        return this.m_cms.createResource(folder + filename, t, CmsFileUtil.readFile(localfile), null);
    }

    public void version() {
        System.out.println();
        System.out.println(this.getMessages().key("GUI_SHELL_VERSION_1", OpenCms.getSystemInfo().getVersionNumber()));
    }

    public CmsUser whoami() {
        return this.m_cms.getRequestContext().currentUser();
    }

    protected CmsMessages getMessages() {
        return this.m_shell.getMessages();
    }
}

