/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsSecurityManager;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsSessionManager;
import org.opencms.main.Messages;
import org.opencms.main.OpenCms;
import org.opencms.publish.CmsPublishJobRunning;
import org.opencms.report.A_CmsReportThread;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public final class CmsThreadStore
extends Thread {
    private static final Log LOG = CmsLog.getLog(CmsThreadStore.class);
    private boolean m_alive;
    private CmsSecurityManager m_securityManager;
    private Map m_threads;

    protected CmsThreadStore(CmsSecurityManager securityManager) {
        super(new ThreadGroup("OpenCms Thread Store"), "OpenCms: Grim Reaper");
        this.setDaemon(true);
        this.m_threads = new Hashtable();
        this.m_alive = true;
        this.m_securityManager = securityManager;
        this.start();
    }

    public void addThread(A_CmsReportThread thread) {
        this.m_threads.put(thread.getUUID(), thread);
        if (LOG.isDebugEnabled()) {
            this.dumpThreads();
        }
    }

    public A_CmsReportThread retrieveThread(CmsUUID key) {
        if (LOG.isDebugEnabled()) {
            this.dumpThreads();
        }
        return (A_CmsReportThread)this.m_threads.get(key);
    }

    public void run() {
        int m_minutesForSessionUpdate = 0;
        int minutesForPublishEngineCheck = 0;
        while (this.m_alive) {
            block17: {
                try {
                    CmsThreadStore.sleep(60000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                try {
                    Iterator<Object> i = this.m_threads.keySet().iterator();
                    HashSet<CmsUUID> doomed = new HashSet<CmsUUID>();
                    while (i.hasNext()) {
                        CmsUUID key = (CmsUUID)i.next();
                        A_CmsReportThread thread = (A_CmsReportThread)this.m_threads.get(key);
                        if (!thread.isDoomed()) continue;
                        doomed.add(key);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_THREADSTORE_DOOMED_2", thread.getName(), thread.getUUID()));
                    }
                    i = doomed.iterator();
                    while (i.hasNext()) {
                        this.m_threads.remove(i.next());
                    }
                    if (LOG.isDebugEnabled()) {
                        this.dumpThreads();
                    }
                }
                catch (Throwable t) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_THREADSTORE_CHECK_THREADS_ERROR_0"), t);
                }
                if (++m_minutesForSessionUpdate >= 5) {
                    m_minutesForSessionUpdate = 0;
                    try {
                        CmsSessionManager sessionInfoManager = OpenCms.getSessionManager();
                        if (sessionInfoManager != null) {
                            sessionInfoManager.validateSessionInfos();
                        }
                    }
                    catch (Throwable t) {
                        LOG.error((Object)Messages.get().getBundle().key("LOG_THREADSTORE_CHECK_SESSIONS_ERROR_0"), t);
                    }
                    try {
                        this.m_securityManager.writeLocks();
                    }
                    catch (Throwable t) {
                        if (!LOG.isErrorEnabled()) break block17;
                        LOG.error((Object)org.opencms.lock.Messages.get().getBundle().key("ERR_WRITE_LOCKS_0"), t);
                    }
                }
            }
            if (++minutesForPublishEngineCheck < 10) continue;
            minutesForPublishEngineCheck = 0;
            try {
                A_CmsReportThread thread;
                CmsUUID uid;
                CmsPublishJobRunning publishJob = OpenCms.getPublishManager().getCurrentPublishJob();
                if (publishJob == null || (uid = publishJob.getThreadUUID()) == null || uid.isNullUUID() || (thread = (A_CmsReportThread)this.m_threads.get(uid)) == null || !CmsStringUtil.isEmptyOrWhitespaceOnly(thread.getReportUpdate())) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_THREADSTORE_PUBLISH_THREAD_INTERRUPT_2", thread.getName(), thread.getUUID()));
                }
                thread.interrupt();
                OpenCms.getPublishManager().checkCurrentPublishJobThread();
            }
            catch (Throwable t) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_THREADSTORE_CHECK_PUBLISH_THREAD_ERROR_0"), t);
            }
        }
    }

    protected synchronized void shutDown() {
        this.m_alive = false;
        this.interrupt();
    }

    private void dumpThreads() {
        if (LOG.isDebugEnabled()) {
            StringBuffer b = new StringBuffer(512);
            Iterator i = this.m_threads.keySet().iterator();
            while (i.hasNext()) {
                CmsUUID key = (CmsUUID)i.next();
                A_CmsReportThread thread = (A_CmsReportThread)this.m_threads.get(key);
                b.append(thread.getName());
                b.append(" - ");
                b.append(thread.getUUID());
                b.append('\n');
            }
            LOG.debug((Object)Messages.get().getBundle().key("LOG_THREADSTORE_POOL_CONTENT_2", new Integer(this.m_threads.size()), b.toString()));
        }
    }
}

