/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.configuration.CmsConfigurationManager;
import org.opencms.configuration.CmsImportExportConfiguration;
import org.opencms.configuration.CmsModuleConfiguration;
import org.opencms.configuration.CmsSearchConfiguration;
import org.opencms.configuration.CmsSystemConfiguration;
import org.opencms.configuration.CmsVfsConfiguration;
import org.opencms.configuration.CmsWorkplaceConfiguration;
import org.opencms.db.CmsDbEntryNotFoundException;
import org.opencms.db.CmsDefaultUsers;
import org.opencms.db.CmsLoginManager;
import org.opencms.db.CmsSecurityManager;
import org.opencms.db.CmsSqlManager;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.flex.CmsFlexCache;
import org.opencms.flex.CmsFlexCacheConfiguration;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsI18nInfo;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.importexport.CmsImportExportManager;
import org.opencms.jsp.util.CmsErrorBean;
import org.opencms.loader.CmsResourceManager;
import org.opencms.loader.I_CmsFlexCacheEnabledLoader;
import org.opencms.lock.CmsLockManager;
import org.opencms.main.CmsContextInfo;
import org.opencms.main.CmsEventManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsHttpAuthenticationSettings;
import org.opencms.main.CmsInitException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsResourceInitException;
import org.opencms.main.CmsSessionInfo;
import org.opencms.main.CmsSessionManager;
import org.opencms.main.CmsSystemInfo;
import org.opencms.main.CmsThreadStore;
import org.opencms.main.I_CmsRequestHandler;
import org.opencms.main.I_CmsResourceInit;
import org.opencms.main.I_CmsSessionStorageProvider;
import org.opencms.main.Messages;
import org.opencms.main.OpenCms;
import org.opencms.main.OpenCmsServlet;
import org.opencms.module.CmsModuleManager;
import org.opencms.monitor.CmsMemoryMonitor;
import org.opencms.monitor.CmsMemoryMonitorConfiguration;
import org.opencms.publish.CmsPublishEngine;
import org.opencms.publish.CmsPublishManager;
import org.opencms.repository.CmsRepositoryManager;
import org.opencms.scheduler.CmsScheduleManager;
import org.opencms.search.CmsSearchManager;
import org.opencms.security.CmsOrgUnitManager;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleManager;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.security.CmsSecurityException;
import org.opencms.security.I_CmsAuthorizationHandler;
import org.opencms.security.I_CmsPasswordHandler;
import org.opencms.security.I_CmsValidationHandler;
import org.opencms.site.CmsSite;
import org.opencms.site.CmsSiteManagerImpl;
import org.opencms.staticexport.CmsDefaultLinkSubstitutionHandler;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.staticexport.CmsStaticExportManager;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsPropertyUtils;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplaceManager;
import org.opencms.xml.CmsXmlContentTypeManager;

public final class OpenCmsCore {
    private static final Object LOCK = new Object();
    private static final Log LOG = CmsLog.getLog(OpenCmsCore.class);
    private static CmsMessageContainer m_errorCondition;
    private static OpenCmsCore m_instance;
    private I_CmsAuthorizationHandler m_authorizationHandler;
    private CmsConfigurationManager m_configurationManager;
    private List m_defaultFiles;
    private CmsDefaultUsers m_defaultUsers;
    private CmsEventManager m_eventManager;
    private Set m_exportPoints;
    private CmsImportExportManager m_importExportManager;
    private CmsLinkManager m_linkManager;
    private CmsLocaleManager m_localeManager;
    private CmsLoginManager m_loginManager;
    private CmsMemoryMonitor m_memoryMonitor;
    private CmsModuleManager m_moduleManager;
    private CmsOrgUnitManager m_orgUnitManager;
    private I_CmsPasswordHandler m_passwordHandler;
    private CmsPublishEngine m_publishEngine;
    private CmsPublishManager m_publishManager;
    private CmsRepositoryManager m_repositoryManager;
    private Map m_requestHandlers;
    private List m_resourceInitHandlers;
    private CmsResourceManager m_resourceManager;
    private CmsRoleManager m_roleManager;
    private int m_runLevel;
    private Map m_runtimeProperties;
    private CmsScheduleManager m_scheduleManager;
    private CmsSearchManager m_searchManager;
    private CmsSecurityManager m_securityManager;
    private CmsSessionManager m_sessionManager;
    private CmsSiteManagerImpl m_siteManager;
    private CmsStaticExportManager m_staticExportManager;
    private CmsSystemInfo m_systemInfo;
    private CmsThreadStore m_threadStore;
    private I_CmsValidationHandler m_validationHandler;
    private CmsWorkplaceManager m_workplaceManager;
    private CmsXmlContentTypeManager m_xmlContentTypeManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OpenCmsCore() throws CmsInitException {
        Object object = LOCK;
        synchronized (object) {
            if (m_instance != null && m_instance.getRunLevel() > 0) {
                throw new CmsInitException(Messages.get().container("ERR_ALREADY_INITIALIZED_0"));
            }
            this.initMembers();
            m_instance = this;
            this.setRunLevel(1);
        }
    }

    protected static OpenCmsCore getInstance() {
        if (m_errorCondition != null) {
            throw new CmsInitException(m_errorCondition, false);
        }
        if (m_instance == null) {
            try {
                m_instance = new OpenCmsCore();
            }
            catch (CmsInitException cmsInitException) {
                // empty catch block
            }
        }
        return m_instance;
    }

    protected static void setErrorCondition(CmsMessageContainer errorCondition) {
        if (m_instance != null && m_instance.getRunLevel() < 3) {
            if (!"ERR_CRITICAL_INIT_WIZARD_0".equals(errorCondition.getKey())) {
                m_errorCondition = errorCondition;
                System.err.println(Messages.get().getBundle().key("LOG_INIT_FAILURE_MESSAGE_1", errorCondition.key()));
            }
            LOG.error((Object)errorCondition.key(), (Throwable)new CmsException(errorCondition));
            m_instance = null;
        } else if (m_instance != null) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_INIT_INVALID_ERROR_2", new Integer(m_instance.getRunLevel()), errorCondition.key()));
        }
    }

    protected void addRequestHandler(I_CmsRequestHandler handler) {
        if (handler == null) {
            return;
        }
        String[] names = handler.getHandlerNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (this.m_requestHandlers.get(name) != null) {
                CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_DUPLICATE_REQUEST_HANDLER_1", name));
                continue;
            }
            this.m_requestHandlers.put(name, handler);
            if (!CmsLog.INIT.isInfoEnabled()) continue;
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADDED_REQUEST_HANDLER_2", name, handler.getClass().getName()));
        }
    }

    protected I_CmsAuthorizationHandler getAuthorizationHandler() {
        return this.m_authorizationHandler;
    }

    protected CmsConfigurationManager getConfigurationManager() {
        return this.m_configurationManager;
    }

    protected List getDefaultFiles() {
        return this.m_defaultFiles;
    }

    protected CmsDefaultUsers getDefaultUsers() {
        return this.m_defaultUsers;
    }

    protected CmsEventManager getEventManager() {
        return this.m_eventManager;
    }

    protected Set getExportPoints() {
        return this.m_exportPoints;
    }

    protected CmsImportExportManager getImportExportManager() {
        return this.m_importExportManager;
    }

    protected CmsLinkManager getLinkManager() {
        return this.m_linkManager;
    }

    protected CmsLocaleManager getLocaleManager() {
        return this.m_localeManager;
    }

    protected CmsLockManager getLockManager() {
        return this.m_securityManager.getLockManager();
    }

    protected CmsLoginManager getLoginManager() {
        return this.m_loginManager;
    }

    protected CmsMemoryMonitor getMemoryMonitor() {
        return this.m_memoryMonitor;
    }

    protected CmsModuleManager getModuleManager() {
        return this.m_moduleManager;
    }

    protected CmsOrgUnitManager getOrgUnitManager() {
        return this.m_orgUnitManager;
    }

    protected I_CmsPasswordHandler getPasswordHandler() {
        return this.m_passwordHandler;
    }

    protected String getPathInfo(HttpServletRequest req) {
        int pos;
        String requestErrorPageAttribute;
        String path = req.getPathInfo();
        if (path == null && (requestErrorPageAttribute = this.getSystemInfo().getServletContainerSettings().getRequestErrorPageAttribute()) != null && (path = (String)req.getAttribute(requestErrorPageAttribute)) != null && (pos = path.indexOf("/", 1)) > 0) {
            path = path.substring(pos);
        }
        if (path == null) {
            path = "/";
        }
        return path;
    }

    protected CmsPublishManager getPublishManager() {
        return this.m_publishManager;
    }

    protected CmsRepositoryManager getRepositoryManager() {
        return this.m_repositoryManager;
    }

    protected I_CmsRequestHandler getRequestHandler(String name) {
        return (I_CmsRequestHandler)this.m_requestHandlers.get(name);
    }

    protected CmsResourceManager getResourceManager() {
        return this.m_resourceManager;
    }

    protected CmsRoleManager getRoleManager() {
        return this.m_roleManager;
    }

    protected int getRunLevel() {
        return this.m_runLevel;
    }

    protected Object getRuntimeProperty(Object key) {
        return this.m_runtimeProperties.get(key);
    }

    protected CmsScheduleManager getScheduleManager() {
        return this.m_scheduleManager;
    }

    protected CmsSearchManager getSearchManager() {
        return this.m_searchManager;
    }

    protected CmsSecurityManager getSecurityManager() {
        return this.m_securityManager;
    }

    protected CmsSessionManager getSessionManager() {
        return this.m_sessionManager;
    }

    protected CmsSiteManagerImpl getSiteManager() {
        return this.m_siteManager;
    }

    protected CmsSqlManager getSqlManager() {
        return this.m_securityManager.getSqlManager();
    }

    protected CmsStaticExportManager getStaticExportManager() {
        return this.m_staticExportManager;
    }

    protected CmsSystemInfo getSystemInfo() {
        return this.m_systemInfo;
    }

    protected CmsThreadStore getThreadStore() {
        return this.m_threadStore;
    }

    protected I_CmsValidationHandler getValidationHandler() {
        return this.m_validationHandler;
    }

    protected CmsWorkplaceManager getWorkplaceManager() {
        return this.m_workplaceManager;
    }

    protected CmsXmlContentTypeManager getXmlContentTypeManager() {
        if (this.m_xmlContentTypeManager != null) {
            return this.m_xmlContentTypeManager;
        }
        if (this.getRunLevel() == 1) {
            this.m_xmlContentTypeManager = CmsXmlContentTypeManager.createTypeManagerForTestCases();
        }
        return this.m_xmlContentTypeManager;
    }

    protected CmsObject initCmsObject(CmsObject cms) throws CmsException {
        CmsContextInfo contextInfo = new CmsContextInfo(cms.getRequestContext());
        contextInfo.setRequestTime(-1L);
        return this.initCmsObject(contextInfo);
    }

    protected CmsObject initCmsObject(CmsObject adminCms, CmsContextInfo contextInfo) throws CmsRoleViolationException, CmsException {
        String userName = contextInfo.getUserName();
        if (!(adminCms != null && this.m_roleManager.hasRole(adminCms, CmsRole.ROOT_ADMIN) || userName.endsWith(this.getDefaultUsers().getUserGuest()) || userName.endsWith(this.getDefaultUsers().getUserExport()))) {
            CmsMessageContainer message = Messages.get().container("ERR_INVALID_INIT_USER_2", userName, adminCms != null ? adminCms.getRequestContext().currentUser().getName() : "");
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)message.key());
            }
            throw new CmsRoleViolationException(message);
        }
        return this.initCmsObject(contextInfo);
    }

    protected CmsObject initCmsObject(String user) throws CmsException {
        return this.initCmsObject(null, new CmsContextInfo(user));
    }

    protected CmsObject initCmsObjectFromSession(HttpServletRequest req) throws CmsException {
        CmsSessionInfo sessionInfo = this.m_sessionManager.getSessionInfo(req);
        if (sessionInfo == null) {
            return null;
        }
        CmsSite site = this.getSiteManager().matchRequest(req);
        CmsUUID project = sessionInfo.getProject();
        String siteroot = null;
        if (this.getSiteManager().getWorkplaceSiteMatcher().equals(site.getSiteMatcher())) {
            siteroot = sessionInfo.getSiteRoot();
        }
        if (siteroot == null) {
            siteroot = site.getSiteRoot();
        }
        return this.initCmsObject(req, this.m_securityManager.readUser(null, sessionInfo.getUserId()), siteroot, project, sessionInfo.getOrganizationalUnitFqn());
    }

    protected synchronized void initConfiguration(ExtendedProperties configuration) throws CmsInitException {
        CmsObject adminCms;
        CmsFlexCache flexCache;
        CmsSystemConfiguration systemConfiguration;
        block24: {
            String systemEncoding = null;
            try {
                systemEncoding = System.getProperty("file.encoding");
            }
            catch (SecurityException se) {
                // empty catch block
            }
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_FILE_ENCODING_1", systemEncoding));
            }
            String ethernetAddress = configuration.getString("server.ethernet.address", CmsUUID.getDummyEthernetAddress());
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ETHERNET_ADDRESS_1", ethernetAddress));
            }
            CmsUUID.init(ethernetAddress);
            String serverName = configuration.getString("server.name", "OpenCmsServer");
            this.getSystemInfo().setServerName(serverName);
            try {
                if (CmsLog.INIT.isInfoEnabled()) {
                    String jdkinfo = System.getProperty("java.vm.name") + " ";
                    jdkinfo = jdkinfo + System.getProperty("java.vm.version") + " ";
                    jdkinfo = jdkinfo + System.getProperty("java.vm.info") + " ";
                    jdkinfo = jdkinfo + System.getProperty("java.vm.vendor") + " ";
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_JAVA_VM_1", jdkinfo));
                    String osinfo = System.getProperty("os.name") + " ";
                    osinfo = osinfo + System.getProperty("os.version") + " ";
                    osinfo = osinfo + System.getProperty("os.arch") + " ";
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_OPERATING_SYSTEM_1", osinfo));
                }
            }
            catch (Exception e) {
                throw new CmsInitException(Messages.get().container("ERR_CRITICAL_INIT_PROP_0"), (Throwable)e);
            }
            this.m_configurationManager = new CmsConfigurationManager(this.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(CmsSystemInfo.FOLDER_CONFIG));
            this.m_configurationManager.setConfiguration(configuration);
            try {
                this.m_configurationManager.loadXmlConfiguration();
            }
            catch (Exception e) {
                throw new CmsInitException(Messages.get().container("ERR_CRITICAL_INIT_XML_0"), (Throwable)e);
            }
            systemConfiguration = (CmsSystemConfiguration)this.m_configurationManager.getConfiguration(CmsSystemConfiguration.class);
            CmsMemoryMonitorConfiguration memoryMonitorConfiguration = systemConfiguration.getCmsMemoryMonitorConfiguration();
            try {
                this.m_memoryMonitor = CmsStringUtil.isNotEmptyOrWhitespaceOnly(memoryMonitorConfiguration.getClassName()) ? (CmsMemoryMonitor)Class.forName(memoryMonitorConfiguration.getClassName()).newInstance() : new CmsMemoryMonitor();
            }
            catch (Exception e) {
                throw new CmsInitException(Messages.get().container("ERR_CRITICAL_INIT_MEMORY_MONITOR_1", memoryMonitorConfiguration.getClassName()), (Throwable)e);
            }
            this.m_memoryMonitor.initialize(systemConfiguration);
            CmsEventManager configuredEventManager = systemConfiguration.getEventManager();
            configuredEventManager.initialize(this.m_eventManager);
            this.m_eventManager = configuredEventManager;
            String setEncoding = systemConfiguration.getDefaultContentEncoding();
            String defaultEncoding = CmsEncoder.lookupEncoding(setEncoding, null);
            if (defaultEncoding == null) {
                throw new CmsInitException(Messages.get().container("ERR_CRITICAL_INIT_ENCODING_1", setEncoding));
            }
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_OPENCMS_ENCODING_1", defaultEncoding));
            }
            this.getSystemInfo().setDefaultEncoding(defaultEncoding);
            this.getSystemInfo().setVersionHistorySettings(systemConfiguration.isHistoryEnabled(), systemConfiguration.getHistoryVersions(), systemConfiguration.getHistoryVersionsAfterDeletion());
            this.getSystemInfo().setMailSettings(systemConfiguration.getMailSettings());
            this.getSystemInfo().setHttpAuthenticationSettings(systemConfiguration.getHttpAuthenticationSettings());
            this.getSystemInfo().setNotificationTime(systemConfiguration.getNotificationTime());
            this.getSystemInfo().setNotificationProject(systemConfiguration.getNotificationProject());
            this.m_scheduleManager = systemConfiguration.getScheduleManager();
            this.m_resourceInitHandlers = systemConfiguration.getResourceInitHandlers();
            Iterator it = systemConfiguration.getRequestHandlers().iterator();
            while (it.hasNext()) {
                I_CmsRequestHandler handler = (I_CmsRequestHandler)it.next();
                this.addRequestHandler(handler);
                if (!CmsLog.INIT.isInfoEnabled()) continue;
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_REQUEST_HANDLER_CLASS_1", handler.getClass().getName()));
            }
            this.m_defaultUsers = systemConfiguration.getCmsDefaultUsers();
            this.m_siteManager = systemConfiguration.getSiteManager();
            CmsVfsConfiguration vfsConfiguation = (CmsVfsConfiguration)this.m_configurationManager.getConfiguration(CmsVfsConfiguration.class);
            this.m_resourceManager = vfsConfiguation.getResourceManager();
            this.m_xmlContentTypeManager = vfsConfiguation.getXmlContentTypeManager();
            this.m_defaultFiles = vfsConfiguation.getDefaultFiles();
            this.m_resourceManager.setTranslators(vfsConfiguation.getFolderTranslator(), vfsConfiguation.getFileTranslator());
            flexCache = null;
            try {
                if (CmsLog.INIT.isInfoEnabled()) {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_FLEX_CACHE_STARTING_0"));
                }
                CmsFlexCacheConfiguration flexCacheConfiguration = systemConfiguration.getCmsFlexCacheConfiguration();
                flexCache = new CmsFlexCache(flexCacheConfiguration);
                if (CmsLog.INIT.isInfoEnabled()) {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_FLEX_CACHE_FINISHED_0"));
                }
            }
            catch (Exception e) {
                if (!CmsLog.INIT.isWarnEnabled()) break block24;
                CmsLog.INIT.warn((Object)Messages.get().getBundle().key("INIT_FLEX_CACHE_ERROR_1", e.getMessage()));
            }
        }
        if (flexCache != null) {
            Iterator i = this.m_resourceManager.getLoaders().iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof I_CmsFlexCacheEnabledLoader)) continue;
                ((I_CmsFlexCacheEnabledLoader)o).setFlexCache(flexCache);
            }
        }
        CmsImportExportConfiguration importExportConfiguration = (CmsImportExportConfiguration)this.m_configurationManager.getConfiguration(CmsImportExportConfiguration.class);
        this.m_importExportManager = importExportConfiguration.getImportExportManager();
        this.m_staticExportManager = importExportConfiguration.getStaticExportManager();
        this.m_repositoryManager = importExportConfiguration.getRepositoryManager();
        CmsSearchConfiguration searchConfiguration = (CmsSearchConfiguration)this.m_configurationManager.getConfiguration(CmsSearchConfiguration.class);
        this.m_searchManager = searchConfiguration.getSearchManager();
        CmsWorkplaceConfiguration workplaceConfiguration = (CmsWorkplaceConfiguration)this.m_configurationManager.getConfiguration(CmsWorkplaceConfiguration.class);
        this.m_workplaceManager = workplaceConfiguration.getWorkplaceManager();
        this.addExportPoints(this.m_workplaceManager.getExportPoints());
        CmsModuleConfiguration moduleConfiguration = (CmsModuleConfiguration)this.m_configurationManager.getConfiguration(CmsModuleConfiguration.class);
        this.m_moduleManager = moduleConfiguration.getModuleManager();
        this.m_passwordHandler = systemConfiguration.getPasswordHandler();
        this.m_validationHandler = systemConfiguration.getValidationHandler();
        this.m_authorizationHandler = systemConfiguration.getAuthorizationHandler();
        this.m_loginManager = systemConfiguration.getLoginManager();
        this.m_publishEngine = new CmsPublishEngine(systemConfiguration.getRuntimeInfoFactory());
        this.m_securityManager = CmsSecurityManager.newInstance(this.m_configurationManager, systemConfiguration.getRuntimeInfoFactory(), this.m_publishEngine);
        this.m_publishManager = systemConfiguration.getPublishManager();
        this.m_roleManager = new CmsRoleManager(this.m_securityManager);
        this.m_orgUnitManager = new CmsOrgUnitManager(this.m_securityManager);
        this.m_threadStore = new CmsThreadStore(this.m_securityManager);
        this.m_linkManager = new CmsLinkManager(this.m_staticExportManager.getLinkSubstitutionHandler());
        this.m_runtimeProperties.putAll(systemConfiguration.getRuntimeProperties());
        I_CmsSessionStorageProvider sessionStorageProvider = systemConfiguration.getSessionStorageProvider();
        try {
            adminCms = this.initCmsObject(null, null, this.getDefaultUsers().getUserAdmin(), (String)null, (String)null);
        }
        catch (CmsException e) {
            throw new CmsInitException(Messages.get().container("ERR_CRITICAL_INIT_ADMINCMS_0"), (Throwable)e);
        }
        try {
            this.m_scheduleManager.initialize(this.initCmsObject(adminCms));
            this.m_localeManager = systemConfiguration.getLocaleManager();
            this.m_localeManager.initialize(this.initCmsObject(adminCms));
            this.m_siteManager.initialize(this.initCmsObject(adminCms));
            this.m_staticExportManager.initialize(this.initCmsObject(adminCms));
            this.m_xmlContentTypeManager.initialize(this.initCmsObject(adminCms));
            this.m_publishManager.setPublishEngine(this.m_publishEngine);
            this.m_publishManager.setSecurityManager(this.m_securityManager);
            this.m_publishManager.initialize(this.initCmsObject(adminCms));
            this.m_moduleManager.initialize(this.initCmsObject(adminCms), this.m_configurationManager);
            this.m_resourceManager.initialize(this.initCmsObject(adminCms));
            this.m_searchManager.initialize(this.initCmsObject(adminCms));
            this.m_workplaceManager.initialize(this.initCmsObject(adminCms));
            this.m_sessionManager.initialize(sessionStorageProvider);
            this.m_publishManager.startPublishing();
        }
        catch (CmsException e) {
            throw new CmsInitException(Messages.get().container("ERR_CRITICAL_INIT_MANAGERS_0"), (Throwable)e);
        }
    }

    protected synchronized void initContext(ServletContext context) throws CmsInitException {
        int i;
        ExtendedProperties configuration;
        String servletMapping = context.getInitParameter("OpenCmsServlet");
        if (servletMapping == null) {
            throw new CmsInitException(Messages.get().container("ERR_CRITICAL_INIT_SERVLET_0"));
        }
        String webInfPath = context.getInitParameter("OpenCmsHome");
        if (CmsStringUtil.isEmpty(webInfPath) && CmsStringUtil.isEmpty(webInfPath = CmsFileUtil.searchWebInfFolder(context.getRealPath("/")))) {
            throw new CmsInitException(Messages.get().container("ERR_CRITICAL_INIT_FOLDER_0"));
        }
        String defaultWebApplication = context.getInitParameter("DefaultWebApplication");
        if (defaultWebApplication == null) {
            defaultWebApplication = "ROOT";
        }
        String webApplicationContext = context.getInitParameter("WebApplicationContext");
        String servletContainerName = context.getServerInfo();
        this.getSystemInfo().init(webInfPath, servletMapping, webApplicationContext, defaultWebApplication, servletContainerName, true);
        try {
            configuration = CmsPropertyUtils.loadProperties(this.getSystemInfo().getConfigurationFileRfsPath());
        }
        catch (Exception e) {
            throw new CmsInitException(Messages.get().container("ERR_CRITICAL_INIT_PROPFILE_1", this.getSystemInfo().getConfigurationFileRfsPath()), (Throwable)e);
        }
        this.getSystemInfo().getServletContainerSettings().setServletThrowsException(configuration.getBoolean("servlet.exception.enabled", true));
        if (configuration.getBoolean("wizard.enabled", true)) {
            throw new CmsInitException(Messages.get().container("ERR_CRITICAL_INIT_WIZARD_0"));
        }
        System.err.println(Messages.get().getBundle().key("LOG_STARTUP_CONSOLE_NOTE_2", OpenCms.getSystemInfo().getVersionNumber(), this.getSystemInfo().getWebApplicationName()));
        for (i = 0; i < Messages.COPYRIGHT_BY_ALKACON.length; ++i) {
            System.err.println(Messages.COPYRIGHT_BY_ALKACON[i]);
        }
        System.err.println();
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DOT_0"));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DOT_0"));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DOT_0"));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DOT_0"));
            for (i = 0; i < Messages.COPYRIGHT_BY_ALKACON.length; ++i) {
                CmsLog.INIT.info((Object)(". " + Messages.COPYRIGHT_BY_ALKACON[i]));
            }
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_LINE_0"));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_STARTUP_TIME_1", new Date(System.currentTimeMillis())));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_OPENCMS_VERSION_1", OpenCms.getSystemInfo().getVersionNumber()));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SERVLET_CONTAINER_1", context.getServerInfo()));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_WEBAPP_NAME_1", this.getSystemInfo().getWebApplicationName()));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SERVLET_PATH_1", this.getSystemInfo().getServletPath()));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_OPENCMS_CONTEXT_1", this.getSystemInfo().getOpenCmsContext()));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_WEBINF_PATH_1", this.getSystemInfo().getWebInfRfsPath()));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_PROPERTY_FILE_1", this.getSystemInfo().getConfigurationFileRfsPath()));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_LOG_FILE_1", this.getSystemInfo().getLogFileRfsPath()));
        }
        this.initConfiguration(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initMembers() {
        Object object = LOCK;
        synchronized (object) {
            this.m_resourceInitHandlers = new ArrayList();
            this.m_requestHandlers = new HashMap();
            this.m_systemInfo = new CmsSystemInfo();
            this.m_exportPoints = Collections.EMPTY_SET;
            this.m_defaultUsers = new CmsDefaultUsers();
            this.m_localeManager = new CmsLocaleManager(Locale.ENGLISH);
            this.m_sessionManager = new CmsSessionManager();
            this.m_runtimeProperties = new Hashtable();
            this.m_eventManager = new CmsEventManager();
            this.m_linkManager = new CmsLinkManager(new CmsDefaultLinkSubstitutionHandler());
        }
    }

    protected CmsResource initResource(CmsObject cms, String resourceName, HttpServletRequest req, HttpServletResponse res) throws CmsException {
        CmsResource resource;
        CmsException tmpException = null;
        try {
            resource = cms.readDefaultFile(resourceName);
        }
        catch (CmsException e) {
            tmpException = e;
            resource = null;
        }
        if (resource != null) {
            boolean secure;
            cms.getRequestContext().setUri(cms.getSitePath(resource));
            if (resource.isInternal()) {
                throw new CmsException(Messages.get().container("ERR_READ_INTERNAL_RESOURCE_1", cms.getRequestContext().getUri()));
            }
            if (cms.getRequestContext().currentProject().isOnlineProject() && (secure = Boolean.valueOf(cms.readPropertyObject(cms.getSitePath(resource), "secure", true).getValue()).booleanValue())) {
                CmsSite site = OpenCms.getSiteManager().getCurrentSite(cms);
                boolean usingSec = req.getRequestURL().toString().toUpperCase().startsWith(site.getSecureUrl().toUpperCase());
                if (site.isExclusiveUrl() && !usingSec) {
                    resource = null;
                    if (site.isExclusiveError()) {
                        throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_REQUEST_SECURE_RESOURCE_0"));
                    }
                    String uri = req.getRequestURL().toString();
                    String target = site.getSecureUrl() + uri.substring(uri.indexOf("/", uri.indexOf("//") + 2));
                    try {
                        res.sendRedirect(target);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        Iterator i = this.m_resourceInitHandlers.iterator();
        while (i.hasNext()) {
            try {
                resource = ((I_CmsResourceInit)i.next()).initResource(resource, cms, req, res);
            }
            catch (CmsResourceInitException e) {
                // empty catch block
                break;
            }
        }
        if (resource == null && tmpException != null) {
            throw tmpException;
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initServlet(OpenCmsServlet servlet) {
        Object object = LOCK;
        synchronized (object) {
            this.addRequestHandler(servlet);
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SYSTEM_RUNNING_1", CmsStringUtil.formatRuntime(this.getSystemInfo().getRuntime())));
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_LINE_0"));
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DOT_0"));
            }
        }
    }

    protected void setRuntimeProperty(Object key, Object value) {
        this.m_runtimeProperties.put(key, value);
    }

    protected void showResource(HttpServletRequest req, HttpServletResponse res) {
        CmsObject cms = null;
        try {
            cms = this.initCmsObject(req, res);
            CmsResource resource = this.initResource(cms, cms.getRequestContext().getUri(), req, res);
            if (resource != null) {
                this.m_resourceManager.loadResource(cms, resource, req, res);
                this.m_sessionManager.updateSessionInfo(cms, req);
            }
        }
        catch (Throwable t) {
            this.errorHandling(cms, req, res, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutDown() {
        Object object = LOCK;
        synchronized (object) {
            if (this.getRunLevel() > 0) {
                System.err.println(Messages.get().getBundle().key("LOG_SHUTDOWN_CONSOLE_NOTE_2", this.getSystemInfo().getVersionNumber(), this.getSystemInfo().getWebApplicationName()));
                if (CmsLog.INIT.isInfoEnabled()) {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DOT_0"));
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DOT_0"));
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_LINE_0"));
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SHUTDOWN_START_1", this.getSystemInfo().getVersionNumber()));
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_CURRENT_RUNLEVEL_1", new Integer(this.getRunLevel())));
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SHUTDOWN_TIME_1", new Date(System.currentTimeMillis())));
                }
                this.setRunLevel(0);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_SHUTDOWN_TRACE_0"), (Throwable)new Exception());
                }
                try {
                    this.m_publishEngine.shutDown();
                }
                catch (Throwable e) {
                    CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_ERROR_PUBLISH_SHUTDOWN_1", e.getMessage()), e);
                }
                try {
                    if (this.m_staticExportManager != null) {
                        this.m_staticExportManager.shutDown();
                    }
                }
                catch (Throwable e) {
                    CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_ERROR_EXPORT_SHUTDOWN_1", e.getMessage()), e);
                }
                try {
                    if (this.m_moduleManager != null) {
                        this.m_moduleManager.shutDown();
                    }
                }
                catch (Throwable e) {
                    CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_ERROR_MODULE_SHUTDOWN_1", e.getMessage()), e);
                }
                try {
                    if (this.m_scheduleManager != null) {
                        this.m_scheduleManager.shutDown();
                    }
                }
                catch (Throwable e) {
                    CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_ERROR_SCHEDULE_SHUTDOWN_1", e.getMessage()), e);
                }
                try {
                    if (this.m_resourceManager != null) {
                        this.m_resourceManager.shutDown();
                    }
                }
                catch (Throwable e) {
                    CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_ERROR_RESOURCE_SHUTDOWN_1", e.getMessage()), e);
                }
                try {
                    if (this.m_threadStore != null) {
                        this.m_threadStore.shutDown();
                    }
                }
                catch (Throwable e) {
                    CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_ERROR_THREAD_SHUTDOWN_1", e.getMessage()), e);
                }
                try {
                    if (this.m_securityManager != null) {
                        this.m_securityManager.destroy();
                    }
                }
                catch (Throwable e) {
                    CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_ERROR_SECURITY_SHUTDOWN_1", e.getMessage()), e);
                }
                try {
                    if (this.m_sessionManager != null) {
                        this.m_sessionManager.shutdown();
                    }
                }
                catch (Throwable e) {
                    CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_ERROR_SESSION_MANAGER_SHUTDOWN_1", e.getMessage()), e);
                }
                try {
                    if (this.m_memoryMonitor != null) {
                        this.m_memoryMonitor.shutdown();
                    }
                }
                catch (Throwable e) {
                    CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_ERROR_MEMORY_MONITOR_SHUTDOWN_1", e.getMessage()), e);
                }
                String runtime = CmsStringUtil.formatRuntime(this.getSystemInfo().getRuntime());
                if (CmsLog.INIT.isInfoEnabled()) {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_OPENCMS_STOPPED_1", runtime));
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_LINE_0"));
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DOT_0"));
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DOT_0"));
                }
                System.err.println(Messages.get().getBundle().key("LOG_CONSOLE_TOTAL_RUNTIME_1", runtime));
            }
            m_instance = null;
        }
    }

    protected CmsObject updateContext(HttpServletRequest request, CmsObject cms) throws CmsException {
        CmsSite site = OpenCms.getSiteManager().matchRequest(request);
        return this.initCmsObject(request, cms.getRequestContext().currentUser(), site.getSiteRoot(), cms.getRequestContext().currentProject().getUuid(), cms.getRequestContext().getOuFqn());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OpenCmsCore upgradeRunlevel(ExtendedProperties configuration) throws CmsInitException {
        Object object = LOCK;
        synchronized (object) {
            if (m_instance != null && this.getRunLevel() >= 2) {
                return m_instance;
            }
            if (this.getRunLevel() != 1) {
                CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_WRONG_INIT_SEQUENCE_2", new Integer(3), new Integer(this.getRunLevel())));
                return m_instance;
            }
            this.setRunLevel(2);
            m_instance.initConfiguration(configuration);
            this.setRunLevel(3);
            return m_instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OpenCmsCore upgradeRunlevel(ServletContext context) throws CmsInitException {
        Object object = LOCK;
        synchronized (object) {
            block7: {
                if (m_instance != null && this.getRunLevel() >= 4) {
                    return m_instance;
                }
                if (this.getRunLevel() != 1) {
                    CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_WRONG_INIT_SEQUENCE_2", new Integer(4), new Integer(this.getRunLevel())));
                    return m_instance;
                }
                this.setRunLevel(2);
                m_instance.initContext(context);
                this.setRunLevel(4);
                try {
                    OpenCmsCore.m_instance.m_securityManager.readLocks();
                }
                catch (CmsException e) {
                    if (!LOG.isErrorEnabled()) break block7;
                    LOG.error((Object)org.opencms.lock.Messages.get().getBundle().key("ERR_READ_LOCKS_0"), (Throwable)e);
                }
            }
            return m_instance;
        }
    }

    protected void writeConfiguration(Class clazz) {
        try {
            this.m_configurationManager.writeConfiguration(clazz);
        }
        catch (IOException e) {
            CmsLog.getLog(CmsConfigurationManager.class).error((Object)Messages.get().getBundle().key("LOG_ERROR_WRITING_CONFIG_1", clazz.getName()), (Throwable)e);
        }
        catch (CmsConfigurationException e) {
            CmsLog.getLog(CmsConfigurationManager.class).error((Object)Messages.get().getBundle().key("LOG_ERROR_WRITING_CONFIG_1", clazz.getName()), (Throwable)e);
        }
    }

    private void addExportPoints(Set exportPoints) {
        HashSet newSet = new HashSet(this.m_exportPoints.size() + exportPoints.size());
        newSet.addAll(exportPoints);
        newSet.addAll(this.m_exportPoints);
        this.m_exportPoints = Collections.unmodifiableSet(newSet);
    }

    private String createErrorBox(Throwable t, HttpServletRequest request, CmsObject cms) {
        Throwable cause;
        String errorUri = CmsFlexController.getThrowableResourceUri((ServletRequest)request);
        if (errorUri == null) {
            errorUri = cms.getRequestContext().getUri();
        }
        if ((cause = CmsFlexController.getThrowable((ServletRequest)request)) == null) {
            cause = t;
        }
        CmsErrorBean errorBean = new CmsErrorBean(cms, cause);
        errorBean.setParamAction(errorUri);
        return errorBean.toHtml();
    }

    private void errorHandling(CmsObject cms, HttpServletRequest req, HttpServletResponse res, Throwable t) {
        CmsFlexController.removeController((ServletRequest)req);
        boolean canWrite = !res.isCommitted() && !res.containsHeader("Location");
        int status = -1;
        boolean isGuest = true;
        if (t instanceof ServletException) {
            ServletException s = (ServletException)t;
            if (s.getRootCause() != null) {
                t = s.getRootCause();
            }
        } else if (t instanceof CmsSecurityException) {
            if (canWrite) {
                try {
                    this.requestAuthorization(req, res);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                return;
            }
        } else if (t instanceof CmsDbEntryNotFoundException) {
            status = 503;
            isGuest = false;
        } else if (t instanceof CmsVfsResourceNotFoundException) {
            status = 404;
        } else if (t instanceof CmsException && t.getCause() != null) {
            t = t.getCause();
        }
        if (status < 1) {
            status = 500;
        }
        res.setStatus(status);
        try {
            if (cms != null && cms.getRequestContext().currentUser() != null) {
                isGuest = isGuest && (cms.getRequestContext().currentUser().isGuestUser() || cms.userInGroup(cms.getRequestContext().currentUser().getName(), OpenCms.getDefaultUsers().getGroupGuests()));
            }
        }
        catch (CmsException e) {
            // empty catch block
        }
        if (canWrite) {
            res.setContentType("text/html");
            CmsRequestUtil.setNoCacheHeaders(res);
            if (!isGuest && cms != null && !cms.getRequestContext().currentProject().isOnlineProject()) {
                try {
                    res.setStatus(200);
                    res.getWriter().print(this.createErrorBox(t, req, cms));
                }
                catch (IOException e) {}
            } else {
                try {
                    res.sendError(status, t.toString());
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    private CmsObject initCmsObject(CmsContextInfo contextInfo) throws CmsException {
        CmsProject project;
        CmsUser user = contextInfo.getUser();
        if (user == null) {
            user = this.m_securityManager.readUser(null, contextInfo.getUserName());
        }
        if ((project = contextInfo.getProject()) == null) {
            project = this.m_securityManager.readProject(contextInfo.getProjectName());
        }
        CmsRequestContext context = new CmsRequestContext(user, project, contextInfo.getRequestedUri(), contextInfo.getSiteRoot(), contextInfo.getLocale(), contextInfo.getEncoding(), contextInfo.getRemoteAddr(), contextInfo.getRequestTime(), this.m_resourceManager.getFolderTranslator(), this.m_resourceManager.getFileTranslator(), contextInfo.getOuFqn());
        return new CmsObject(this.m_securityManager, context);
    }

    private CmsObject initCmsObject(HttpServletRequest request, CmsUser user, String siteRoot, CmsUUID projectId, String ouFqn) throws CmsException {
        CmsI18nInfo i18nInfo;
        String remoteAddr;
        CmsProject project = null;
        try {
            project = this.m_securityManager.readProject(projectId);
        }
        catch (CmsDbEntryNotFoundException e) {
            project = this.m_securityManager.readProject(CmsProject.ONLINE_PROJECT_ID);
        }
        String requestedResource = null;
        Long requestTimeAttr = null;
        if (request != null) {
            HttpSession session;
            requestedResource = this.getPathInfo(request);
            remoteAddr = request.getHeader("x-forwarded-for");
            if (remoteAddr == null) {
                remoteAddr = request.getRemoteAddr();
            }
            if ((session = request.getSession(false)) != null) {
                requestTimeAttr = (Long)session.getAttribute("__org.opencms.main.CmsContextInfo#m_requestTime");
            }
        } else {
            remoteAddr = "127.0.0.1";
        }
        if (requestedResource == null) {
            requestedResource = "/";
        }
        long requestTime = requestTimeAttr == null ? System.currentTimeMillis() : requestTimeAttr;
        if (this.m_localeManager.isInitialized()) {
            String resourceName = requestedResource.startsWith("/system/") ? requestedResource : siteRoot.concat(requestedResource);
            i18nInfo = this.m_localeManager.getI18nInfo(request, user, project, resourceName);
        } else {
            i18nInfo = new CmsI18nInfo(Locale.ENGLISH, this.getSystemInfo().getDefaultEncoding());
        }
        requestedResource = CmsEncoder.decode(requestedResource);
        CmsContextInfo contextInfo = new CmsContextInfo(user, project, requestedResource, siteRoot, i18nInfo.getLocale(), i18nInfo.getEncoding(), remoteAddr, requestTime, ouFqn);
        return this.initCmsObject(contextInfo);
    }

    private CmsObject initCmsObject(HttpServletRequest req, HttpServletResponse res) throws IOException, CmsException {
        CmsObject cms = this.initCmsObjectFromSession(req);
        if (cms != null) {
            return cms;
        }
        cms = this.m_authorizationHandler.initCmsObject(req);
        if (cms != null) {
            return cms;
        }
        CmsSite site = this.getSiteManager().matchRequest(req);
        this.requestAuthorization(req, res);
        cms = this.initCmsObject(req, this.m_securityManager.readUser(null, OpenCms.getDefaultUsers().getUserGuest()), site.getSiteRoot(), CmsProject.ONLINE_PROJECT_ID, "");
        return cms;
    }

    private CmsObject initCmsObject(HttpServletRequest req, HttpServletResponse res, String user, String password, String ouFqn) throws CmsException {
        String siteroot = null;
        if (req != null && res != null) {
            siteroot = OpenCms.getSiteManager().matchRequest(req).getSiteRoot();
        }
        if (user == null) {
            user = this.getDefaultUsers().getUserGuest();
        }
        if (siteroot == null) {
            siteroot = "/";
        }
        CmsObject cms = this.initCmsObject(req, this.m_securityManager.readUser(null, user), siteroot, CmsProject.ONLINE_PROJECT_ID, ouFqn);
        if (password != null && !this.getDefaultUsers().isUserGuest(user)) {
            cms.loginUser(user, password, "127.0.0.1");
        }
        return cms;
    }

    private void requestAuthorization(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String redirectURL;
        CmsProperty propertyLoginForm;
        String path;
        CmsObject adminCms;
        block10: {
            try {
                adminCms = this.initCmsObject(req, res, this.getDefaultUsers().getUserAdmin(), null, null);
            }
            catch (CmsException e) {
                throw new IOException(Messages.get().getBundle().key("ERR_INVALID_INIT_USER_2", this.getDefaultUsers().getUserAdmin(), null));
            }
            path = adminCms.getRequestContext().getUri();
            propertyLoginForm = null;
            redirectURL = null;
            try {
                propertyLoginForm = adminCms.readPropertyObject(path, "login-form", true);
            }
            catch (Throwable t) {
                if (!LOG.isWarnEnabled()) break block10;
                LOG.warn((Object)Messages.get().getBundle().key("LOG_ERROR_READING_AUTH_PROP_2", "login-form", path), t);
            }
        }
        CmsHttpAuthenticationSettings httpAuthenticationSettings = this.getSystemInfo().getHttpAuthenticationSettings();
        String pathWithParams = CmsRequestUtil.encodeParamsWithUri(path, req);
        if (propertyLoginForm != null && propertyLoginForm != CmsProperty.getNullProperty() && CmsStringUtil.isNotEmpty(propertyLoginForm.getValue())) {
            redirectURL = propertyLoginForm.getValue() + "?__loginform=true&" + "requestedResource" + "=" + pathWithParams;
        } else if (!httpAuthenticationSettings.useBrowserBasedHttpAuthentication() && CmsStringUtil.isNotEmpty(httpAuthenticationSettings.getFormBasedHttpAuthenticationUri())) {
            redirectURL = httpAuthenticationSettings.getFormBasedHttpAuthenticationUri() + "?" + "requestedResource" + "=" + pathWithParams;
        }
        if (redirectURL == null) {
            res.setHeader("WWW-Authenticate", "BASIC realm=\"" + this.getSystemInfo().getOpenCmsContext() + "\"");
            res.setStatus(401);
        } else {
            redirectURL = this.m_linkManager.substituteLink(adminCms, redirectURL, null, true);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_AUTHENTICATE_PROPERTY_2", redirectURL, path));
            }
            res.sendRedirect(redirectURL);
        }
    }

    private void setRunLevel(int level) {
        if (m_instance != null) {
            if (OpenCmsCore.m_instance.m_runLevel >= 1 && CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_RUNLEVEL_CHANGE_2", new Integer(OpenCmsCore.m_instance.m_runLevel), new Integer(level)));
            }
            OpenCmsCore.m_instance.m_runLevel = level;
        }
    }
}

