/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.module;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.opencms.configuration.CmsVfsConfiguration;
import org.opencms.configuration.CmsWorkplaceConfiguration;
import org.opencms.db.CmsExportPoint;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.CmsLog;
import org.opencms.module.CmsModule;
import org.opencms.module.CmsModuleDependency;
import org.opencms.module.CmsModuleVersion;
import org.opencms.module.Messages;
import org.opencms.util.CmsDateUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;

public class CmsModuleXmlHandler {
    public static final String A_NAME = "name";
    public static final String A_VERSION = "version";
    public static final String N_AUTHOREMAIL = "authoremail";
    public static final String N_AUTHORNAME = "authorname";
    public static final String N_CLASS = "class";
    public static final String N_DATECREATED = "datecreated";
    public static final String N_DATEINSTALLED = "dateinstalled";
    public static final String N_DEPENDENCIES = "dependencies";
    public static final String N_DEPENDENCY = "dependency";
    public static final String N_DESCRIPTION = "description";
    public static final String N_GROUP = "group";
    public static final String N_MODULE = "module";
    public static final String N_NAME = "name";
    public static final String N_NICENAME = "nicename";
    public static final String N_PARAM = "param";
    public static final String N_PARAMETERS = "parameters";
    public static final String N_RESOURCES = "resources";
    public static final String N_USERINSTALLED = "userinstalled";
    public static final String N_VERSION = "version";
    private static final Log LOG = CmsLog.getLog(CmsModuleXmlHandler.class);
    private List m_dependencies;
    private List m_explorerTypeSettings;
    private List m_exportPoints = new ArrayList();
    private CmsModule m_module;
    private boolean m_oldModule;
    private Map m_parameters;
    private List m_resources;
    private List m_resourceTypes;

    public CmsModuleXmlHandler() {
        this.m_dependencies = new ArrayList();
        this.m_resources = new ArrayList();
        this.m_parameters = new HashMap();
        this.m_resourceTypes = new ArrayList();
        this.m_explorerTypeSettings = new ArrayList();
    }

    public static void addXmlDigesterRules(Digester digester) {
        digester.addObjectCreate("*/module", CmsModuleXmlHandler.class);
        digester.addSetNext("*/module", "setModule");
        digester.addCallMethod("*/module", "createdModule", 11);
        digester.addCallParam("*/module/name", 0);
        digester.addCallParam("*/module/nicename", 1);
        digester.addCallParam("*/module/group", 2);
        digester.addCallParam("*/module/class", 3);
        digester.addCallParam("*/module/description", 4);
        digester.addCallParam("*/module/version", 5);
        digester.addCallParam("*/module/authorname", 6);
        digester.addCallParam("*/module/authoremail", 7);
        digester.addCallParam("*/module/datecreated", 8);
        digester.addCallParam("*/module/userinstalled", 9);
        digester.addCallParam("*/module/dateinstalled", 10);
        digester.addCallMethod("*/module/dependencies/dependency", "addDependency", 2);
        digester.addCallParam("*/module/dependencies/dependency", 0, "name");
        digester.addCallParam("*/module/dependencies/dependency", 1, "version");
        digester.addCallMethod("*/module/exportpoints/exportpoint", "addExportPoint", 2);
        digester.addCallParam("*/module/exportpoints/exportpoint", 0, "uri");
        digester.addCallParam("*/module/exportpoints/exportpoint", 1, "destination");
        digester.addCallMethod("*/module/resources/resource", "addResource", 1);
        digester.addCallParam("*/module/resources/resource", 0, "uri");
        digester.addCallMethod("*/module/parameters/param", "addParameter", 2);
        digester.addCallParam("*/module/parameters/param", 0, "name");
        digester.addCallParam("*/module/parameters/param", 1);
        digester.addCallMethod("*/param", "addConfigurationParameter", 2);
        digester.addCallParam("*/param", 0, "name");
        digester.addCallParam("*/param", 1);
        CmsVfsConfiguration.addResourceTypeXmlRules(digester);
        CmsWorkplaceConfiguration.addExplorerTypeXmlRules(digester);
        CmsModuleXmlHandler.addXmlDigesterRulesForVersion5Modules(digester);
    }

    public static Element generateXml(CmsModule module) {
        List explorerTypes;
        List resourceTypes;
        Document doc = DocumentHelper.createDocument();
        Element moduleElement = doc.addElement(N_MODULE);
        moduleElement.addElement("name").setText(module.getName());
        if (!module.getName().equals(module.getNiceName())) {
            moduleElement.addElement(N_NICENAME).addCDATA(module.getNiceName());
        } else {
            moduleElement.addElement(N_NICENAME);
        }
        if (CmsStringUtil.isNotEmpty(module.getGroup())) {
            moduleElement.addElement(N_GROUP).setText(module.getGroup());
        }
        if (CmsStringUtil.isNotEmpty(module.getActionClass())) {
            moduleElement.addElement(N_CLASS).setText(module.getActionClass());
        } else {
            moduleElement.addElement(N_CLASS);
        }
        if (CmsStringUtil.isNotEmpty(module.getDescription())) {
            moduleElement.addElement(N_DESCRIPTION).addCDATA(module.getDescription());
        } else {
            moduleElement.addElement(N_DESCRIPTION);
        }
        moduleElement.addElement("version").setText(module.getVersion().toString());
        if (CmsStringUtil.isNotEmpty(module.getAuthorName())) {
            moduleElement.addElement(N_AUTHORNAME).addCDATA(module.getAuthorName());
        } else {
            moduleElement.addElement(N_AUTHORNAME);
        }
        if (CmsStringUtil.isNotEmpty(module.getAuthorEmail())) {
            moduleElement.addElement(N_AUTHOREMAIL).addCDATA(module.getAuthorEmail());
        } else {
            moduleElement.addElement(N_AUTHOREMAIL);
        }
        if (module.getDateCreated() != 0L) {
            moduleElement.addElement(N_DATECREATED).setText(CmsDateUtil.getHeaderDate(module.getDateCreated()));
        } else {
            moduleElement.addElement(N_DATECREATED);
        }
        if (CmsStringUtil.isNotEmpty(module.getUserInstalled())) {
            moduleElement.addElement(N_USERINSTALLED).setText(module.getUserInstalled());
        } else {
            moduleElement.addElement(N_USERINSTALLED);
        }
        if (module.getDateInstalled() != 0L) {
            moduleElement.addElement(N_DATEINSTALLED).setText(CmsDateUtil.getHeaderDate(module.getDateInstalled()));
        } else {
            moduleElement.addElement(N_DATEINSTALLED);
        }
        Element dependenciesElement = moduleElement.addElement(N_DEPENDENCIES);
        for (int i = 0; i < module.getDependencies().size(); ++i) {
            CmsModuleDependency dependency = (CmsModuleDependency)module.getDependencies().get(i);
            dependenciesElement.addElement(N_DEPENDENCY).addAttribute("name", dependency.getName()).addAttribute("version", dependency.getVersion().toString());
        }
        Element exportpointsElement = moduleElement.addElement("exportpoints");
        for (int i = 0; i < module.getExportPoints().size(); ++i) {
            CmsExportPoint point = (CmsExportPoint)module.getExportPoints().get(i);
            exportpointsElement.addElement("exportpoint").addAttribute("uri", point.getUri()).addAttribute("destination", point.getConfiguredDestination());
        }
        Element resourcesElement = moduleElement.addElement(N_RESOURCES);
        for (int i = 0; i < module.getResources().size(); ++i) {
            String resource = (String)module.getResources().get(i);
            resourcesElement.addElement("resource").addAttribute("uri", resource);
        }
        Element parametersElement = moduleElement.addElement(N_PARAMETERS);
        SortedMap parameters = module.getParameters();
        if (parameters != null) {
            ArrayList parameterList = new ArrayList(parameters.keySet());
            Collections.sort(parameterList);
            Iterator it = parameterList.iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                String value = parameters.get(name).toString();
                Element paramNode = parametersElement.addElement(N_PARAM);
                paramNode.addAttribute("name", name);
                paramNode.addText(value);
            }
        }
        if ((resourceTypes = module.getResourceTypes()).size() > 0) {
            Element resourcetypesElement = moduleElement.addElement("resourcetypes");
            CmsVfsConfiguration.generateResourceTypeXml(resourcetypesElement, resourceTypes, true);
        }
        if ((explorerTypes = module.getExplorerTypes()).size() > 0) {
            Element explorerTypesElement = moduleElement.addElement("explorertypes");
            CmsWorkplaceConfiguration.generateExplorerTypesXml(explorerTypesElement, explorerTypes, true);
        }
        moduleElement.detach();
        return moduleElement;
    }

    public static String makeValidJavaClassName(String className) {
        StringBuffer result = new StringBuffer(className.length());
        int length = className.length();
        boolean nodot = true;
        for (int i = 0; i < length; ++i) {
            char ch = className.charAt(i);
            if (nodot) {
                if (ch == '.') continue;
                if (Character.isJavaIdentifierStart(ch)) {
                    nodot = false;
                    result.append(ch);
                    continue;
                }
                result.append('_');
                continue;
            }
            if (ch == '.') {
                nodot = true;
                result.append(ch);
                continue;
            }
            if (Character.isJavaIdentifierPart(ch)) {
                nodot = false;
                result.append(ch);
                continue;
            }
            result.append('_');
        }
        return result.toString();
    }

    private static void addXmlDigesterRulesForVersion5Modules(Digester digester) {
        digester.addCallMethod("*/module/author", "setOldModule");
        digester.addCallParam("*/module/author", 6);
        digester.addCallParam("*/module/email", 7);
        digester.addCallParam("*/module/creationdate", 8);
        digester.addCallParam("*/module/dependencies/dependency/name", 0);
        digester.addCallParam("*/module/dependencies/dependency/minversion", 1);
        digester.addCallMethod("*/module/exportpoint", "addExportPoint", 2);
        digester.addCallParam("*/module/exportpoint/source", 0);
        digester.addCallParam("*/module/exportpoint/destination", 1);
        digester.addCallMethod("*/module/parameters/para", "addParameter", 2);
        digester.addCallParam("*/module/parameters/para/name", 0);
        digester.addCallParam("*/module/parameters/para/value", 1);
    }

    public void addDependency(String name, String version) {
        CmsModuleVersion moduleVersion = new CmsModuleVersion(version);
        CmsModuleDependency dependency = new CmsModuleDependency(name, moduleVersion);
        this.m_dependencies.add(dependency);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_ADD_MOD_DEPENDENCY_2", name, version));
        }
    }

    public void addExplorerTypeSetting(CmsExplorerTypeSettings settings) {
        settings.setAddititionalModuleExplorerType(true);
        this.m_explorerTypeSettings.add(settings);
    }

    public void addExportPoint(String uri, String destination) {
        CmsExportPoint point = new CmsExportPoint(uri, destination);
        this.m_exportPoints.add(point);
        if (CmsLog.INIT.isInfoEnabled() && point.getDestinationPath() != null) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_EXPORT_POINT_2", point.getUri(), point.getDestinationPath()));
        }
    }

    public void addParameter(String key, String value) {
        if (CmsStringUtil.isNotEmpty(key)) {
            key = key.trim();
        }
        if (CmsStringUtil.isNotEmpty(value)) {
            value = value.trim();
        }
        this.m_parameters.put(key, value);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_ADD_MOD_PARAM_KEY_2", key, value));
        }
    }

    public void addResource(String resource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_ADD_MOD_RESOURCE_1", resource));
        }
        this.m_resources.add(resource);
    }

    public void addResourceType(I_CmsResourceType resourceType) {
        resourceType.setAdditionalModuleResourceType(true);
        this.m_resourceTypes.add(resourceType);
    }

    public void createdModule(String name, String niceName, String group, String actionClass, String description, String version, String authorName, String authorEmail, String dateCreated, String userInstalled, String dateInstalled) {
        String moduleName;
        if (!CmsStringUtil.isValidJavaClassName(name)) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_INVALID_MOD_NAME_IMPORTED_1", name));
            moduleName = CmsModuleXmlHandler.makeValidJavaClassName(name);
            LOG.error((Object)Messages.get().getBundle().key("LOG_CORRECTED_MOD_NAME_1", moduleName));
        } else {
            moduleName = name;
        }
        CmsModuleVersion moduleVersion = new CmsModuleVersion(version);
        long moduleDateCreated = 0L;
        if (dateCreated != null) {
            try {
                moduleDateCreated = CmsDateUtil.parseHeaderDate(dateCreated);
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        long moduleDateInstalled = 0L;
        if (dateInstalled != null) {
            try {
                moduleDateInstalled = CmsDateUtil.parseHeaderDate(dateInstalled);
            }
            catch (ParseException e1) {
                // empty catch block
            }
        }
        if (this.m_oldModule) {
            String modulePath = "/system/modules/" + name + "/";
            this.m_resources.add(modulePath);
        }
        this.m_module = new CmsModule(moduleName, niceName, group, actionClass, description, moduleVersion, authorName, authorEmail, moduleDateCreated, userInstalled, moduleDateInstalled, this.m_dependencies, this.m_exportPoints, this.m_resources, this.m_parameters);
        this.m_module.setResourceTypes(this.m_resourceTypes);
        this.m_module.setExplorerTypes(this.m_explorerTypeSettings);
    }

    public CmsModule getModule() {
        return this.m_module;
    }

    public void setOldModule() {
        this.m_oldModule = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_OLD_MODULE_IMPORTED_0"));
        }
    }
}

