/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.monitor;

class CmsMemoryStatus {
    private int m_count;
    private long m_freeMemory;
    private long m_maxMemory;
    private long m_totalMemory;
    private long m_usage;
    private long m_usedMemory;

    public CmsMemoryStatus() {
        this.update();
    }

    public void calculateAverage(CmsMemoryStatus currentStatus) {
        int newCount = this.m_count + 1;
        this.m_maxMemory = ((long)this.m_count * this.m_maxMemory + currentStatus.getMaxMemory()) / (long)newCount;
        this.m_totalMemory = ((long)this.m_count * this.m_totalMemory + currentStatus.getTotalMemory()) / (long)newCount;
        this.m_usedMemory = ((long)this.m_count * this.m_usedMemory + currentStatus.getUsedMemory()) / (long)newCount;
        this.m_freeMemory = ((long)this.m_count * this.m_freeMemory + currentStatus.getFreeMemory()) / (long)newCount;
        this.m_usage = this.m_usedMemory * 100L / this.m_maxMemory;
        this.m_count = newCount;
    }

    public int getCount() {
        return this.m_count;
    }

    public long getFreeMemory() {
        return this.m_freeMemory;
    }

    public long getMaxMemory() {
        return this.m_maxMemory;
    }

    public long getTotalMemory() {
        return this.m_totalMemory;
    }

    public long getUsage() {
        return this.m_usage;
    }

    public long getUsedMemory() {
        return this.m_usedMemory;
    }

    public void update() {
        this.m_maxMemory = Runtime.getRuntime().maxMemory() / 0x100000L;
        this.m_totalMemory = Runtime.getRuntime().totalMemory() / 0x100000L;
        this.m_usedMemory = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L;
        this.m_freeMemory = this.m_maxMemory - this.m_usedMemory;
        this.m_usage = this.m_usedMemory * 100L / this.m_maxMemory;
    }
}

