/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.newsletter;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.mail.MessagingException;
import org.apache.commons.mail.Email;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.mail.CmsHtmlMail;
import org.opencms.mail.CmsSimpleMail;
import org.opencms.mail.CmsVfsDataSource;
import org.opencms.main.CmsException;
import org.opencms.newsletter.CmsNewsletterContentType;
import org.opencms.newsletter.I_CmsNewsletter;
import org.opencms.newsletter.I_CmsNewsletterContent;
import org.opencms.newsletter.I_CmsNewsletterRecipient;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;

public class CmsNewsletter
implements I_CmsNewsletter {
    private List m_attachments;
    private List m_contents = new ArrayList();
    private String m_subject;

    public CmsNewsletter() {
        this.m_attachments = new ArrayList();
    }

    public void addAttachment(CmsObject cms, CmsResource resource) {
        this.m_attachments.add(resource);
    }

    public void addContent(I_CmsNewsletterContent content) {
        this.m_contents.add(content);
    }

    public Email getEmail(CmsObject cms, I_CmsNewsletterRecipient recipient) throws MessagingException, CmsException {
        Object email;
        StringBuffer htmlMsg = new StringBuffer(1024);
        StringBuffer txtMsg = new StringBuffer(1024);
        Iterator contents = this.m_contents.iterator();
        while (contents.hasNext()) {
            I_CmsNewsletterContent content = (I_CmsNewsletterContent)contents.next();
            if (!recipient.isSubscriber(content)) continue;
            if (content.getType().equals(CmsNewsletterContentType.TYPE_HTML)) {
                htmlMsg.append(content.getContent());
                continue;
            }
            txtMsg.append(content.getContent());
        }
        if (htmlMsg.length() > 0 || !this.m_attachments.isEmpty()) {
            CmsHtmlMail htmlMail = new CmsHtmlMail();
            htmlMail.setHtmlMsg(this.replaceMacros(htmlMsg.toString(), recipient));
            Iterator attachments = this.m_attachments.iterator();
            while (attachments.hasNext()) {
                String propertyTitle;
                CmsResource resource = (CmsResource)attachments.next();
                String description = "";
                String propertyDescription = cms.readPropertyObject(cms.getSitePath(resource), "Description", true).getValue();
                description = CmsStringUtil.isNotEmptyOrWhitespaceOnly(propertyDescription) ? propertyDescription : (propertyTitle = cms.readPropertyObject(cms.getSitePath(resource), "Title", true).getValue());
                htmlMail.attach(new CmsVfsDataSource(cms, resource), resource.getName(), description);
            }
            htmlMail.setTextMsg(this.replaceMacros(txtMsg.toString(), recipient));
            email = htmlMail;
        } else {
            CmsSimpleMail textMail = new CmsSimpleMail();
            textMail.setMsg(this.replaceMacros(txtMsg.toString(), recipient));
            email = textMail;
        }
        email.addTo(recipient.getEmail());
        email.setSubject(this.m_subject);
        return email;
    }

    public void setSubject(String subject) {
        this.m_subject = subject;
    }

    private String replaceMacros(String msg, I_CmsNewsletterRecipient recipient) {
        CmsMacroResolver resolver = CmsMacroResolver.newInstance();
        resolver.addMacro("firstname", recipient.getFirstname());
        resolver.addMacro("lastname", recipient.getLastname());
        resolver.addMacro("fullname", recipient.getFullName());
        resolver.addMacro("email", recipient.getEmail());
        resolver.addMacro("date", DateFormat.getDateTimeInstance().format(new Date(System.currentTimeMillis())));
        return resolver.resolveMacros(msg);
    }
}

