/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.newsletter;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.mail.Email;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsLog;
import org.opencms.newsletter.I_CmsNewsletter;
import org.opencms.newsletter.I_CmsNewsletterRecipient;

public class CmsNewsletterDistributor {
    private static final Log LOG = CmsLog.getLog(CmsNewsletterDistributor.class);

    public void distribute(CmsObject cms, List recipients, I_CmsNewsletter newsletter) {
        Iterator recipientsIterator = recipients.iterator();
        while (recipientsIterator.hasNext()) {
            I_CmsNewsletterRecipient recipient = (I_CmsNewsletterRecipient)recipientsIterator.next();
            try {
                Email mail = newsletter.getEmail(cms, recipient);
                mail.addTo(recipient.getEmail(), recipient.getFullName());
                mail.send();
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

