/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.publish;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUtils;
import org.apache.commons.collections.buffer.TypedBuffer;
import org.apache.commons.collections.buffer.UnboundedFifoBuffer;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsDbContext;
import org.opencms.db.CmsDriverManager;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.publish.CmsPublishEngine;
import org.opencms.publish.CmsPublishHistory;
import org.opencms.publish.CmsPublishJobEnqueued;
import org.opencms.publish.CmsPublishJobInfoBean;
import org.opencms.publish.Messages;

public class CmsPublishQueue {
    private static final Log LOG = CmsLog.getLog(CmsPublishHistory.class);
    protected final CmsPublishEngine m_publishEngine;

    protected CmsPublishQueue(CmsPublishEngine publishEngine) {
        this.m_publishEngine = publishEngine;
    }

    public static Buffer getQueue() {
        return BufferUtils.synchronizedBuffer((Buffer)TypedBuffer.decorate((Buffer)new UnboundedFifoBuffer(){
            private static final long serialVersionUID = 606444342980861724L;

            public Object remove() {
                CmsPublishJobInfoBean publishJob = (CmsPublishJobInfoBean)super.remove();
                return publishJob;
            }
        }, (Class)CmsPublishJobInfoBean.class));
    }

    protected boolean abortPublishJob(CmsPublishJobInfoBean publishJob) {
        if (OpenCms.getMemoryMonitor().getCachedPublishJob(publishJob.getPublishHistoryId().toString()) != null) {
            OpenCms.getMemoryMonitor().uncachePublishJob(publishJob);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(CmsPublishJobInfoBean publishJob) throws CmsException {
        publishJob.enqueue();
        OpenCms.getMemoryMonitor().cachePublishJob(publishJob);
        if (OpenCms.getMemoryMonitor().requiresPersistency()) {
            CmsDbContext dbc = this.m_publishEngine.getDbContextFactory().getDbContext();
            try {
                this.m_publishEngine.getDriverManager().createPublishJob(dbc, publishJob);
            }
            finally {
                dbc.clear();
            }
        }
    }

    protected List asList() {
        List cachedPublishJobs = OpenCms.getMemoryMonitor().getAllCachedPublishJobs();
        ArrayList<CmsPublishJobEnqueued> result = new ArrayList<CmsPublishJobEnqueued>(cachedPublishJobs.size());
        Iterator it = cachedPublishJobs.iterator();
        while (it.hasNext()) {
            CmsPublishJobInfoBean publishJob = (CmsPublishJobInfoBean)it.next();
            result.add(new CmsPublishJobEnqueued(publishJob));
        }
        return Collections.unmodifiableList(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(CmsObject adminCms, boolean revive) {
        block15: {
            CmsDriverManager driverManager = this.m_publishEngine.getDriverManager();
            try {
                List publishJobs;
                OpenCms.getMemoryMonitor().flushPublishJobs();
                if (!revive) break block15;
                CmsDbContext dbc = this.m_publishEngine.getDbContextFactory().getDbContext();
                try {
                    publishJobs = driverManager.readPublishJobs(dbc, 0L, 0L);
                }
                finally {
                    dbc.clear();
                    dbc = null;
                }
                Iterator i = publishJobs.iterator();
                while (i.hasNext()) {
                    CmsPublishJobInfoBean job = (CmsPublishJobInfoBean)i.next();
                    dbc = this.m_publishEngine.getDbContextFactory().getDbContext();
                    if (!job.isStarted()) {
                        try {
                            job.revive(adminCms, driverManager.readPublishList(dbc, job.getPublishHistoryId()));
                            this.m_publishEngine.lockPublishList(job);
                            OpenCms.getMemoryMonitor().cachePublishJob(job);
                            continue;
                        }
                        catch (CmsException exc) {
                            if (LOG.isErrorEnabled()) {
                                LOG.error((Object)Messages.get().getBundle().key("ERR_PUBLISH_JOB_INVALID_1", job.getPublishHistoryId()), (Throwable)exc);
                            }
                            this.m_publishEngine.getDriverManager().deletePublishJob(dbc, job.getPublishHistoryId());
                            continue;
                        }
                        finally {
                            dbc.clear();
                            continue;
                        }
                    }
                    try {
                        job.revive(adminCms, driverManager.readPublishList(dbc, job.getPublishHistoryId()));
                        this.m_publishEngine.unlockPublishList(job);
                        new CmsPublishJobEnqueued((CmsPublishJobInfoBean)job).m_publishJob.finish();
                        this.m_publishEngine.getPublishHistory().add(job);
                    }
                    catch (CmsException exc) {
                        LOG.error((Object)exc.getLocalizedMessage(), (Throwable)exc);
                    }
                }
            }
            catch (CmsException exc) {
                if (!LOG.isErrorEnabled()) break block15;
                LOG.error((Object)exc.getLocalizedMessage(), (Throwable)exc);
            }
        }
    }

    protected boolean isEmpty() {
        return OpenCms.getMemoryMonitor() == null || OpenCms.getMemoryMonitor().getFirstCachedPublishJob() == null;
    }

    protected CmsPublishJobInfoBean next() {
        CmsPublishJobInfoBean publishJob = OpenCms.getMemoryMonitor().getFirstCachedPublishJob();
        if (publishJob != null) {
            OpenCms.getMemoryMonitor().uncachePublishJob(publishJob);
        }
        return publishJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(CmsPublishJobInfoBean publishJob) throws CmsException {
        this.m_publishEngine.publishJobRemoved(publishJob);
        OpenCms.getMemoryMonitor().uncachePublishJob(publishJob);
        if (OpenCms.getMemoryMonitor().requiresPersistency()) {
            CmsDbContext dbc = this.m_publishEngine.getDbContextFactory().getDbContext();
            try {
                this.m_publishEngine.getDriverManager().deletePublishJob(dbc, publishJob.getPublishHistoryId());
            }
            finally {
                dbc.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(CmsPublishJobInfoBean publishJob) throws CmsException {
        if (OpenCms.getMemoryMonitor().requiresPersistency()) {
            CmsDbContext dbc = this.m_publishEngine.getDbContextFactory().getDbContext();
            try {
                this.m_publishEngine.getDriverManager().writePublishJob(dbc, publishJob);
            }
            finally {
                dbc.clear();
            }
        }
    }
}

