/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.relations;

import org.opencms.file.CmsResource;
import org.opencms.util.CmsUUID;

public class CmsCategory {
    private String m_description;
    private String m_path;
    private CmsUUID m_structureId;
    private String m_title;

    public CmsCategory(CmsUUID structureId, String path, String title, String description) {
        this.m_structureId = structureId;
        this.m_path = path;
        this.m_title = title;
        this.m_description = description;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CmsCategory)) {
            return false;
        }
        CmsCategory compareCategory = (CmsCategory)obj;
        return compareCategory.getId().equals(this.m_structureId);
    }

    public String getDescription() {
        return this.m_description;
    }

    public CmsUUID getId() {
        return this.m_structureId;
    }

    public String getName() {
        String result = CmsResource.getName(this.m_path);
        if (CmsResource.isFolder(result)) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public String getPath() {
        return this.m_path;
    }

    public String getTitle() {
        return this.m_title;
    }

    public int hashCode() {
        return this.m_structureId.hashCode();
    }
}

