/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.relations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.CmsResourceTypeFolder;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsCategory;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationType;
import org.opencms.relations.Messages;
import org.opencms.util.CmsStringUtil;

public class CmsCategoryService {
    private static final String BASE_PATH = "/system/categories/";
    private static final Log LOG = CmsLog.getLog(CmsCategoryService.class);
    private static CmsCategoryService m_instance;

    public static CmsCategoryService getInstance() {
        if (m_instance == null) {
            m_instance = new CmsCategoryService();
        }
        return m_instance;
    }

    public void addResourceToCategory(CmsObject cms, String resourceName, String categoryPath) throws CmsException {
        CmsCategory category = this.readCategory(cms, categoryPath);
        if (!this.readResourceCategories(cms, resourceName).contains(category)) {
            cms.addRelationToResource(resourceName, this.getCategoryFolderPath(categoryPath), CmsRelationType.CATEGORY.getName());
            if (categoryPath.endsWith("/")) {
                categoryPath = categoryPath.substring(0, categoryPath.lastIndexOf("/"));
            }
            if (categoryPath.lastIndexOf(47) > 0) {
                this.addResourceToCategory(cms, resourceName, categoryPath.substring(0, categoryPath.lastIndexOf(47) + 1));
            }
        }
    }

    public CmsCategory createCategory(CmsObject cms, CmsCategory parent, String name, String title, String description) throws CmsException {
        CmsResource resource;
        ArrayList<CmsProperty> properties = new ArrayList<CmsProperty>();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(title)) {
            properties.add(new CmsProperty("Title", title, null));
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(description)) {
            properties.add(new CmsProperty("Description", description, null));
        }
        String folderPath = "";
        if (parent != null) {
            folderPath = folderPath + parent.getPath() + "/";
        }
        folderPath = name.startsWith("/") ? folderPath + name.substring(1) : folderPath + name;
        folderPath = this.getCategoryFolderPath(folderPath);
        try {
            resource = cms.createResource(folderPath, 0, null, properties);
        }
        catch (CmsVfsResourceNotFoundException e) {
            cms.createResource(BASE_PATH, 0, null, null);
            resource = cms.createResource(folderPath, 0, null, properties);
        }
        return new CmsCategory(resource.getStructureId(), this.getCategoryPath(folderPath), title, description);
    }

    public void deleteCategory(CmsObject cms, String categoryPath) throws CmsException {
        cms.deleteResource(this.getCategoryFolderPath(categoryPath), CmsResource.DELETE_PRESERVE_SIBLINGS);
    }

    public void moveCategory(CmsObject cms, String oldCatPath, String newCatPath) throws CmsException {
        cms.moveResource(this.getCategoryFolderPath(oldCatPath), this.getCategoryFolderPath(newCatPath));
    }

    public List readAllCategories(CmsObject cms, boolean includeSubCats) throws CmsException {
        return this.internalReadCategories(cms, "", includeSubCats);
    }

    public CmsCategory readCategory(CmsObject cms, String categoryPath) throws CmsException {
        CmsResource resource = cms.readResource(this.getCategoryFolderPath(categoryPath));
        CmsProperty title = cms.readPropertyObject(resource, "Title", false);
        CmsProperty description = cms.readPropertyObject(resource, "Description", false);
        return new CmsCategory(resource.getStructureId(), this.getCategoryPath(resource.getRootPath()), title.getValue(), description.getValue());
    }

    public List readCategoryResources(CmsObject cms, String categoryPath, boolean recursive) throws CmsException {
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        CmsRelationFilter filter = CmsRelationFilter.SOURCES.filterType(CmsRelationType.CATEGORY);
        if (recursive) {
            filter = filter.filterIncludeChildren();
        }
        Iterator itRelations = cms.getRelationsForResource(this.getCategoryFolderPath(categoryPath), filter).iterator();
        while (itRelations.hasNext()) {
            CmsRelation relation = (CmsRelation)itRelations.next();
            try {
                result.add(relation.getSource(cms, CmsResourceFilter.DEFAULT));
            }
            catch (CmsException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public List readResourceCategories(CmsObject cms, String resourceName) throws CmsException {
        ArrayList<CmsCategory> result = new ArrayList<CmsCategory>();
        Iterator itRelations = cms.getRelationsForResource(resourceName, CmsRelationFilter.TARGETS.filterType(CmsRelationType.CATEGORY)).iterator();
        while (itRelations.hasNext()) {
            CmsRelation relation = (CmsRelation)itRelations.next();
            try {
                CmsResource resource = relation.getTarget(cms, CmsResourceFilter.DEFAULT_FOLDERS);
                CmsCategory category = new CmsCategory(resource.getStructureId(), resource.getRootPath().substring(BASE_PATH.length()), cms.readPropertyObject(resource, "Title", false).getValue(), cms.readPropertyObject(resource, "Description", false).getValue());
                result.add(category);
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public List readSubCategories(CmsObject cms, String categoryPath, boolean includeSubCats) throws CmsException {
        this.readCategory(cms, categoryPath);
        return this.internalReadCategories(cms, categoryPath, includeSubCats);
    }

    public void removeResourceFromCategory(CmsObject cms, String resourceName, String categoryPath) throws CmsException {
        this.readCategory(cms, categoryPath);
        CmsRelationFilter filter = CmsRelationFilter.TARGETS;
        filter = filter.filterType(CmsRelationType.CATEGORY);
        filter = filter.filterResource(cms.readResource(this.getCategoryFolderPath(categoryPath)));
        filter = filter.filterIncludeChildren();
        cms.deleteRelationsFromResource(resourceName, filter);
    }

    private String getCategoryFolderPath(String categoryPath) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(categoryPath)) {
            return null;
        }
        String path = categoryPath;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return BASE_PATH + path;
    }

    private String getCategoryPath(String rootPath) {
        if (rootPath.startsWith(BASE_PATH)) {
            return rootPath.substring(BASE_PATH.length());
        }
        return null;
    }

    private List internalReadCategories(CmsObject cms, String baseCategory, boolean includeSubCats) throws CmsException {
        List resources;
        block5: {
            resources = Collections.EMPTY_LIST;
            try {
                resources = cms.readResources(BASE_PATH + baseCategory, CmsResourceFilter.DEFAULT.addRequireType(0), includeSubCats);
            }
            catch (CmsVfsResourceNotFoundException cvrnfe) {
                if (!CmsStringUtil.isEmptyOrWhitespaceOnly(baseCategory)) break block5;
                Locale wpLocale = OpenCms.getWorkplaceManager().getDefaultLocale();
                try {
                    cms.createResource(BASE_PATH, CmsResourceTypeFolder.getStaticTypeId());
                }
                catch (Exception ex) {
                    LOG.error((Object)Messages.get().getBundle(wpLocale).key("LOG_ERR_CREATE_CATEGORY_FOLDER_1", new String[]{BASE_PATH}));
                }
            }
        }
        ArrayList<CmsCategory> categories = new ArrayList<CmsCategory>();
        Iterator it = resources.iterator();
        while (it.hasNext()) {
            CmsResource resource = (CmsResource)it.next();
            CmsProperty title = cms.readPropertyObject(resource, "Title", false);
            CmsProperty description = cms.readPropertyObject(resource, "Description", false);
            categories.add(new CmsCategory(resource.getStructureId(), this.getCategoryPath(resource.getRootPath()), title.getValue(), description.getValue()));
        }
        return categories;
    }
}

