/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.relations;

import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.wrapper.CmsObjectWrapper;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsLinkUpdateUtil;
import org.opencms.relations.CmsRelationType;
import org.opencms.relations.Messages;
import org.opencms.staticexport.CmsLinkProcessor;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.util.CmsUriSplitter;

public class CmsLink {
    public static final String ATTRIBUTE_INTERNAL = "internal";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_TYPE = "type";
    public static final String DEFAULT_NAME = "ref";
    public static final CmsRelationType DEFAULT_TYPE = CmsRelationType.XML_WEAK;
    public static final String NODE_ANCHOR = "anchor";
    public static final String NODE_QUERY = "query";
    public static final String NODE_TARGET = "target";
    public static final String NODE_UUID = "uuid";
    public static final CmsLink NULL_LINK = new CmsLink();
    private static final Log LOG = CmsLog.getLog(CmsLink.class);
    private String m_anchor;
    private Element m_element;
    private boolean m_internal;
    private String m_name;
    private Map m_parameters;
    private String m_query;
    private String m_siteRoot;
    private CmsUUID m_structureId;
    private String m_target;
    private CmsRelationType m_type;
    private String m_uri;

    public CmsLink(Element element) {
        this.m_element = element;
        Attribute attrName = element.attribute(ATTRIBUTE_NAME);
        this.m_name = attrName != null ? attrName.getValue() : DEFAULT_NAME;
        Attribute attrType = element.attribute(ATTRIBUTE_TYPE);
        this.m_type = attrType != null ? CmsRelationType.valueOfXml(attrType.getValue()) : DEFAULT_TYPE;
        Attribute attrInternal = element.attribute(ATTRIBUTE_INTERNAL);
        this.m_internal = attrInternal != null ? Boolean.valueOf(attrInternal.getValue()) : true;
        Element uuid = element.element(NODE_UUID);
        Element target = element.element(NODE_TARGET);
        Element anchor = element.element(NODE_ANCHOR);
        Element query = element.element(NODE_QUERY);
        this.m_structureId = uuid != null ? new CmsUUID(uuid.getText()) : null;
        this.m_target = target != null ? target.getText() : null;
        this.m_anchor = anchor != null ? anchor.getText() : null;
        this.setQuery(query != null ? query.getText() : null);
        this.setUri();
    }

    public CmsLink(String name, CmsRelationType type, CmsUUID structureId, String uri, boolean internal) {
        this.m_element = null;
        this.m_name = name;
        this.m_type = type;
        this.m_internal = internal;
        this.m_structureId = structureId;
        this.m_uri = uri;
        this.setComponents();
    }

    public CmsLink(String name, CmsRelationType type, String uri, boolean internal) {
        this(name, type, null, uri, internal);
    }

    private CmsLink() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkConsistency(CmsObject cms) {
        if (!this.m_internal || cms == null) {
            return;
        }
        try {
            if (this.m_structureId == null) {
                throw new CmsException(Messages.get().container("LOG_BROKEN_LINK_NO_ID_0"));
            }
            CmsResource res = cms.readResource(this.m_structureId, CmsResourceFilter.ALL);
            if (!res.getRootPath().equals(this.m_target)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_BROKEN_LINK_UPDATED_BY_ID_3", this.m_structureId, this.m_target, res.getRootPath()));
                }
                this.m_target = res.getRootPath();
                this.setUri();
                CmsLinkUpdateUtil.updateXml(this, this.m_element, true);
            }
        }
        catch (CmsException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_BROKEN_LINK_BY_ID_2", this.m_target, this.m_structureId), (Throwable)e);
            }
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_target)) {
                return;
            }
            String siteRoot = cms.getRequestContext().getSiteRoot();
            try {
                cms.getRequestContext().setSiteRoot("");
                CmsResource res = cms.readResource(this.m_target, CmsResourceFilter.ALL);
                if (!res.getStructureId().equals(this.m_structureId)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_BROKEN_LINK_UPDATED_BY_NAME_3", this.m_target, this.m_structureId, res.getStructureId()));
                    }
                    this.m_target = res.getRootPath();
                    this.m_structureId = res.getStructureId();
                    CmsLinkUpdateUtil.updateXml(this, this.m_element, true);
                }
            }
            catch (CmsException e1) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_BROKEN_LINK_BY_NAME_1", this.m_target), (Throwable)e1);
                }
                this.m_structureId = null;
            }
            finally {
                cms.getRequestContext().setSiteRoot(siteRoot);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsLink) {
            CmsLink other = (CmsLink)obj;
            return this.m_type == other.m_type && CmsStringUtil.isEqual(this.m_target, other.m_target);
        }
        return false;
    }

    public String getAnchor() {
        return this.m_anchor;
    }

    public Element getElement() {
        return this.m_element;
    }

    public String getLink(CmsObject cms) {
        if (this.m_internal) {
            if (cms == null || this.m_uri.length() == 0 || this.m_uri.charAt(0) == '#') {
                return this.m_uri;
            }
            this.checkConsistency(cms);
            CmsObjectWrapper wrapper = (CmsObjectWrapper)cms.getRequestContext().getAttribute("org.opencms.file.wrapper.CmsObjectWrapper");
            if (wrapper != null) {
                this.m_uri = wrapper.rewriteLink(this.m_uri);
            }
            if (cms.getRequestContext().getSiteRoot().length() == 0 && cms.getRequestContext().getAttribute(CmsRequestContext.ATTRIBUTE_EDITOR) == null) {
                return OpenCms.getLinkManager().substituteLink(cms, this.m_uri);
            }
            String siteRoot = this.getSiteRoot();
            if (siteRoot == null) {
                return OpenCms.getLinkManager().substituteLink(cms, this.m_uri);
            }
            if (cms.getRequestContext().getAttribute(CmsRequestContext.ATTRIBUTE_FULLLINKS) != null) {
                return OpenCms.getLinkManager().getServerLink(cms, this.m_uri);
            }
            return OpenCms.getLinkManager().substituteLink(cms, this.getVfsUri(), siteRoot);
        }
        return this.m_uri;
    }

    public String getLink(CmsObject cms, boolean processEditorLinks) {
        return this.getLink(cms);
    }

    public String getName() {
        return this.m_name;
    }

    public String getParameter(String name) {
        String[] p = (String[])this.getParameterMap().get(name);
        if (p != null) {
            return p[0];
        }
        return null;
    }

    public Map getParameterMap() {
        if (this.m_parameters == null) {
            this.m_parameters = CmsRequestUtil.createParameterMap(this.m_query);
        }
        return this.m_parameters;
    }

    public Set getParameterNames() {
        return this.getParameterMap().keySet();
    }

    public String[] getParameterValues(String name) {
        return (String[])this.getParameterMap().get(name);
    }

    public String getQuery() {
        return this.m_query;
    }

    public String getSiteRoot() {
        if (this.m_internal && this.m_siteRoot == null) {
            this.m_siteRoot = OpenCms.getSiteManager().getSiteRoot(this.m_target);
            if (this.m_siteRoot == null) {
                this.m_siteRoot = "";
            }
        }
        return this.m_siteRoot;
    }

    public CmsUUID getStructureId() {
        return this.m_structureId;
    }

    public String getTarget() {
        return this.m_target;
    }

    public CmsRelationType getType() {
        return this.m_type;
    }

    public String getUri() {
        return this.m_uri;
    }

    public String getVfsUri() {
        if (this.m_internal) {
            String siteRoot = this.getSiteRoot();
            if (siteRoot != null) {
                return this.m_uri.substring(siteRoot.length());
            }
            return this.m_uri;
        }
        return null;
    }

    public int hashCode() {
        int result = this.m_type.hashCode();
        if (this.m_target != null) {
            result += this.m_target.hashCode();
        }
        return result;
    }

    public boolean isInternal() {
        return this.m_internal;
    }

    public String toString() {
        return this.m_uri;
    }

    public void updateLink(String uri) {
        this.m_uri = uri;
        this.setComponents();
        CmsLinkUpdateUtil.updateXml(this, this.m_element, true);
    }

    public void updateLink(String target, String anchor, String query) {
        this.m_target = target;
        this.m_anchor = anchor;
        this.setQuery(query);
        this.setUri();
        CmsLinkUpdateUtil.updateXml(this, this.m_element, true);
    }

    private void setComponents() {
        CmsUriSplitter splitter = new CmsUriSplitter(this.m_uri, true);
        this.m_target = splitter.getPrefix();
        this.m_anchor = splitter.getAnchor();
        this.setQuery(splitter.getQuery());
    }

    private void setQuery(String query) {
        this.m_query = CmsLinkProcessor.unescapeLink(query);
        this.m_parameters = null;
    }

    private void setUri() {
        StringBuffer uri = new StringBuffer(64);
        uri.append(this.m_target);
        if (this.m_query != null) {
            uri.append('?');
            uri.append(this.m_query);
        }
        if (this.m_anchor != null) {
            uri.append('#');
            uri.append(this.m_anchor);
        }
        this.m_uri = uri.toString();
    }
}

