/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.relations;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsPublishList;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelationValidatorInfoEntry;

public class CmsRelationPublishValidator {
    private static final Log LOG = CmsLog.getLog(CmsRelationPublishValidator.class);
    protected Map m_brokenRelations;
    private CmsObject m_cms;

    public CmsRelationPublishValidator(CmsObject cms, CmsPublishList publishList) {
        try {
            this.m_cms = OpenCms.initCmsObject(cms);
        }
        catch (CmsException e) {
            this.m_cms = cms;
        }
        try {
            this.m_brokenRelations = OpenCms.getPublishManager().validateRelations(this.m_cms, publishList, null);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new CmsRuntimeException(e.getMessageContainer(), (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsRelationValidatorInfoEntry getInfoEntry(String resourceName) {
        String resName = resourceName;
        String siteRoot = this.m_cms.getRequestContext().getSiteRoot();
        String siteName = null;
        if (resName.startsWith(this.m_cms.getRequestContext().getSiteRoot())) {
            resName = this.m_cms.getRequestContext().removeSiteRoot(resName);
        } else {
            siteName = siteRoot = OpenCms.getSiteManager().getSiteRoot(resName);
            if (siteRoot != null) {
                String oldSite = this.m_cms.getRequestContext().getSiteRoot();
                try {
                    this.m_cms.getRequestContext().setSiteRoot("/");
                    siteName = this.m_cms.readPropertyObject(siteRoot, "Title", false).getValue(siteRoot);
                }
                catch (CmsException e) {
                    siteName = siteRoot;
                }
                finally {
                    this.m_cms.getRequestContext().setSiteRoot(oldSite);
                }
                resName = resName.substring(siteRoot.length());
            } else {
                siteName = "/";
            }
        }
        return new CmsRelationValidatorInfoEntry(resourceName, resName, siteName, siteRoot, Collections.unmodifiableList((List)this.m_brokenRelations.get(resourceName)));
    }

    public boolean isEmpty() {
        return this.m_brokenRelations.isEmpty();
    }

    public Set keySet() {
        return this.m_brokenRelations.keySet();
    }

    public Collection values() {
        return this.m_brokenRelations.values();
    }
}

