/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.report;

import java.io.PrintStream;
import java.util.Locale;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.report.CmsHtmlReport;
import org.opencms.workplace.CmsReport;

public class CmsPrintStreamReport
extends CmsHtmlReport {
    private PrintStream m_printStream;
    private boolean m_writeHtml;

    public CmsPrintStreamReport(PrintStream printStream, Locale locale, boolean writeHtml) {
        super(locale, null, true, true);
        this.m_printStream = printStream;
        this.m_writeHtml = writeHtml;
    }

    public void close() {
        if (this.m_printStream != null) {
            this.m_printStream.close();
            this.m_printStream = null;
        }
    }

    public void finish() {
        if (this.m_writeHtml) {
            this.m_printStream.println(CmsReport.generatePageEndExtended());
        }
        this.close();
    }

    public synchronized String getReportUpdate() {
        return "";
    }

    public synchronized void print(String value, int format) {
        if (this.m_writeHtml) {
            super.print(value, format);
            this.m_printStream.print(super.getReportUpdate());
            return;
        }
        switch (format) {
            case 2: {
                StringBuffer buf = new StringBuffer();
                buf.append("------ ");
                buf.append(value);
                this.m_printStream.print(buf);
                break;
            }
            case 1: {
                StringBuffer buf = new StringBuffer();
                buf.append("!!! ");
                buf.append(value);
                this.m_printStream.print(buf);
                this.addWarning(value);
                break;
            }
            case 5: {
                StringBuffer buf = new StringBuffer();
                buf.append("!!! ");
                buf.append(value);
                this.m_printStream.print(buf);
                this.addError(value);
                break;
            }
            default: {
                this.m_printStream.print(value);
            }
        }
    }

    public synchronized void println() {
        if (this.m_writeHtml) {
            super.println();
            this.m_printStream.print(super.getReportUpdate());
            return;
        }
        this.m_printStream.println();
    }

    public synchronized void println(Throwable t) {
        if (this.m_writeHtml) {
            super.println(t);
            this.m_printStream.print(super.getReportUpdate());
            return;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.getMessages().key("RPT_EXCEPTION_0"));
        buf.append(t.getMessage());
        this.println(new String(buf), 5);
        t.printStackTrace(this.m_printStream);
    }

    public void start() {
        if (this.m_writeHtml) {
            try {
                this.m_printStream.println(CmsReport.generatePageStartExtended(OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserGuest()), OpenCms.getSystemInfo().getDefaultEncoding()));
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
        }
    }

    protected String getLineBreak() {
        return "<br>";
    }
}

