/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.report;

import java.util.Locale;
import org.opencms.report.A_CmsReport;

public class CmsStringBufferReport
extends A_CmsReport {
    private StringBuffer m_strBuf;

    public CmsStringBufferReport(Locale locale) {
        this.init(locale, null);
        this.m_strBuf = new StringBuffer();
    }

    public String getReportUpdate() {
        return "";
    }

    public void print(String value, int format) {
        switch (format) {
            case 1: 
            case 2: {
                this.addWarning(value);
                this.m_strBuf.append(value);
                break;
            }
            case 5: {
                this.addError(value);
                this.m_strBuf.append(value);
                break;
            }
            default: {
                this.m_strBuf.append(value);
            }
        }
    }

    public void println() {
        this.m_strBuf.append("\n");
    }

    public void println(Throwable t) {
        this.print(this.getMessages().key("RPT_EXCEPTION_0"), 1);
        this.println(t.getMessage(), 5);
        StackTraceElement[] stackTrace = t.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement element = stackTrace[i];
            this.println(element.toString());
        }
    }

    public String toString() {
        return this.m_strBuf.toString();
    }
}

