/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.file.wrapper.CmsObjectWrapper;
import org.opencms.file.wrapper.I_CmsResourceWrapper;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.repository.A_CmsRepository;
import org.opencms.repository.CmsRepositorySession;
import org.opencms.repository.I_CmsRepositorySession;
import org.opencms.repository.Messages;

public class CmsRepository
extends A_CmsRepository {
    private static final Log LOG = CmsLog.getLog(CmsRepository.class);
    private static final String PARAM_WRAPPER = "wrapper";
    private List m_wrappers = new ArrayList();

    public void initConfiguration() throws CmsConfigurationException {
        if (this.getConfiguration().containsKey(PARAM_WRAPPER)) {
            String[] wrappers = (String[])this.getConfiguration().get(PARAM_WRAPPER);
            for (int i = 0; i < wrappers.length; ++i) {
                I_CmsResourceWrapper wrapper;
                Class<?> nameClazz;
                String classname = wrappers[i].trim();
                try {
                    nameClazz = Class.forName(classname);
                }
                catch (ClassNotFoundException e) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_WRAPPER_CLASS_NOT_FOUND_1", classname), (Throwable)e);
                    return;
                }
                try {
                    wrapper = (I_CmsResourceWrapper)nameClazz.newInstance();
                }
                catch (InstantiationException e) {
                    throw new CmsConfigurationException(Messages.get().container("ERR_INVALID_WRAPPER_NAME_1", classname));
                }
                catch (IllegalAccessException e) {
                    throw new CmsConfigurationException(Messages.get().container("ERR_INVALID_WRAPPER_NAME_1", classname));
                }
                catch (ClassCastException e) {
                    throw new CmsConfigurationException(Messages.get().container("ERR_INVALID_WRAPPER_NAME_1", classname));
                }
                this.m_wrappers.add(wrapper);
                if (!CmsLog.INIT.isInfoEnabled()) continue;
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_WRAPPER_1", wrapper.getClass().getName()));
            }
        }
        this.m_wrappers = Collections.unmodifiableList(this.m_wrappers);
        super.initConfiguration();
    }

    public I_CmsRepositorySession login(String userName, String password) throws CmsException {
        CmsObject cms = OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserGuest());
        cms.loginUser(userName, password);
        CmsUserSettings settings = new CmsUserSettings(cms);
        cms.getRequestContext().setSiteRoot(settings.getStartSite());
        cms.getRequestContext().setCurrentProject(cms.readProject(settings.getStartProject()));
        CmsObjectWrapper objWrapper = new CmsObjectWrapper(cms, this.m_wrappers);
        cms.getRequestContext().setAttribute("org.opencms.file.wrapper.CmsObjectWrapper", objWrapper);
        return new CmsRepositorySession(objWrapper, this.getFilter());
    }
}

