/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.scheduler.jobs;

import java.io.File;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.loader.CmsImageLoader;
import org.opencms.main.CmsLog;
import org.opencms.scheduler.I_CmsScheduledJob;
import org.opencms.scheduler.jobs.Messages;

public class CmsImageCacheCleanupJob
implements I_CmsScheduledJob {
    public static final String PARAM_MAXAGE = "maxage";
    private static final Log LOG = CmsLog.getLog(CmsImageCacheCleanupJob.class);

    public static int cleanImageCache(float maxAge) {
        long expireDate = System.currentTimeMillis() - (long)(maxAge * 60.0f * 60.0f * 1000.0f);
        File basedir = new File(CmsImageLoader.getImageRepositoryPath());
        return CmsImageCacheCleanupJob.cleanImageCache(expireDate, basedir);
    }

    private static int cleanImageCache(long maxAge, File directory) {
        int count = 0;
        if (directory.canRead() && directory.isDirectory()) {
            File[] files = directory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                if (f.isDirectory()) {
                    count += CmsImageCacheCleanupJob.cleanImageCache(maxAge, f);
                }
                if (!f.canWrite() || f.lastModified() >= maxAge) continue;
                try {
                    f.delete();
                    ++count;
                    continue;
                }
                catch (Exception e) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_IMAGE_CACHE_UNABLE_TO_DELETE_1", f.getAbsolutePath()));
                }
            }
            if (directory.listFiles().length <= 0) {
                try {
                    directory.delete();
                    ++count;
                }
                catch (Exception e) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_IMAGE_CACHE_UNABLE_TO_DELETE_1", directory.getAbsolutePath()));
                }
            }
        }
        return count;
    }

    public String launch(CmsObject cms, Map parameters) throws Exception {
        float maxAge;
        if (!CmsImageLoader.isEnabled() || CmsImageLoader.getImageRepositoryPath() == null) {
            return Messages.get().getBundle().key("LOG_IMAGE_SCALING_DISABLED_0");
        }
        String maxAgeStr = (String)parameters.get(PARAM_MAXAGE);
        try {
            maxAge = Float.parseFloat(maxAgeStr);
        }
        catch (NumberFormatException e) {
            maxAge = 168.0f;
            LOG.error((Object)Messages.get().getBundle().key("LOG_IMAGE_CACHE_BAD_MAXAGE_2", maxAgeStr, new Float(maxAge)));
        }
        int count = CmsImageCacheCleanupJob.cleanImageCache(maxAge);
        return Messages.get().getBundle().key("LOG_IMAGE_CACHE_CLEANUP_COUNT_1", new Integer(count));
    }
}

