/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.scheduler.jobs;

import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.notification.CmsPublishNotification;
import org.opencms.report.CmsLogReport;
import org.opencms.scheduler.I_CmsScheduledJob;
import org.opencms.scheduler.jobs.Messages;

public class CmsPublishJob
implements I_CmsScheduledJob {
    public static final String PARAM_LINKCHECK = "linkcheck";
    public static final String PARAM_UNLOCK = "unlock";
    public static final String PARAM_USER = "mail-to-user";
    private static final Log LOG = CmsLog.getLog(CmsPublishJob.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    public String launch(CmsObject cms, Map parameters) throws Exception {
        void var4_8;
        block13: {
            String finishMessage;
            Date jobStart = new Date();
            String unlock = (String)parameters.get(PARAM_UNLOCK);
            String linkcheck = (String)parameters.get(PARAM_LINKCHECK);
            CmsProject project = cms.getRequestContext().currentProject();
            CmsLogReport report = new CmsLogReport(cms.getRequestContext().getLocale(), CmsPublishJob.class);
            try {
                if (Boolean.valueOf(unlock).booleanValue()) {
                    cms.unlockProject(project.getUuid());
                }
                if (Boolean.valueOf(linkcheck).booleanValue()) {
                    OpenCms.getPublishManager().validateRelations(cms, OpenCms.getPublishManager().getPublishList(cms), report);
                }
                OpenCms.getPublishManager().publishProject(cms, report);
                OpenCms.getPublishManager().waitWhileRunning();
                finishMessage = Messages.get().getBundle().key("LOG_PUBLISH_FINISHED_1", project.getName());
                Object var11_9 = null;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (report.hasWarning() || report.hasError()) {
                    try {
                        String userName = (String)parameters.get(PARAM_USER);
                        CmsUser user = cms.readUser(userName);
                        CmsPublishNotification notification = new CmsPublishNotification(cms, user, report);
                        DateFormat df = DateFormat.getDateTimeInstance(3, 3);
                        notification.addMacro("jobStart", df.format(jobStart));
                        notification.send();
                    }
                    catch (Exception e2) {
                        LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISH_SEND_NOTIFICATION_FAILED_0"), (Throwable)e2);
                    }
                }
                throw throwable;
            }
            if (report.hasWarning() || report.hasError()) {
                try {
                    String userName = (String)parameters.get(PARAM_USER);
                    CmsUser user = cms.readUser(userName);
                    CmsPublishNotification notification = new CmsPublishNotification(cms, user, report);
                    DateFormat df = DateFormat.getDateTimeInstance(3, 3);
                    notification.addMacro("jobStart", df.format(jobStart));
                    notification.send();
                }
                catch (Exception e2) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISH_SEND_NOTIFICATION_FAILED_0"), (Throwable)e2);
                }
            }
            break block13;
            {
                catch (CmsException e) {
                    finishMessage = Messages.get().getBundle().key("LOG_PUBLISH_FAILED_2", project.getName(), e.getMessageContainer().key());
                    report.addError(finishMessage);
                    Object var11_10 = null;
                    if (report.hasWarning() || report.hasError()) {
                        try {
                            String userName = (String)parameters.get(PARAM_USER);
                            CmsUser user = cms.readUser(userName);
                            CmsPublishNotification notification = new CmsPublishNotification(cms, user, report);
                            DateFormat df = DateFormat.getDateTimeInstance(3, 3);
                            notification.addMacro("jobStart", df.format(jobStart));
                            notification.send();
                        }
                        catch (Exception e2) {
                            LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISH_SEND_NOTIFICATION_FAILED_0"), (Throwable)e2);
                        }
                    }
                }
            }
        }
        return var4_8;
    }
}

