/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import org.apache.commons.logging.Log;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsLog;
import org.opencms.report.I_CmsReport;
import org.opencms.search.CmsIndexException;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.Messages;
import org.opencms.search.documents.I_CmsDocumentFactory;

public class CmsIndexingThread
extends Thread {
    private static final Log LOG = CmsLog.getLog(CmsIndexingThread.class);
    private CmsObject m_cms;
    private I_CmsDocumentFactory m_documentType;
    private CmsSearchIndex m_index;
    private I_CmsReport m_report;
    private CmsResource m_res;
    private IndexWriter m_writer;

    public CmsIndexingThread(CmsObject cms, IndexWriter writer, CmsResource res, I_CmsDocumentFactory documentType, CmsSearchIndex index, I_CmsReport report) {
        super("OpenCms: Indexing '" + res.getName() + "'");
        this.m_cms = cms;
        this.m_writer = writer;
        this.m_res = res;
        this.m_documentType = documentType;
        this.m_index = index;
        this.m_report = report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block19: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_INDEXING_WITH_FACTORY_2", this.m_res.getRootPath(), this.m_documentType.getName()));
            }
            boolean docOk = false;
            try {
                try {
                    Document doc;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_CREATING_INDEX_DOC_0"));
                    }
                    if ((doc = this.m_documentType.createDocument(this.m_cms, this.m_res, this.m_index)) == null) {
                        throw new CmsIndexException(Messages.get().container("ERR_CREATING_INDEX_DOC_0"));
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_WRITING_INDEX_TO_WRITER_1", String.valueOf(this.m_writer)));
                    }
                    if (!this.isInterrupted()) {
                        this.m_writer.addDocument(doc);
                    }
                    docOk = true;
                    if (this.m_report != null && !this.isInterrupted()) {
                        this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)Messages.get().getBundle().key("LOG_WRITE_SUCCESS_0"));
                        }
                    }
                    if (this.isInterrupted() && LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_ABANDONED_THREAD_FINISHED_1", this.m_res.getRootPath()));
                    }
                }
                catch (Exception exc) {
                    Throwable cause = exc.getCause();
                    if (cause != null && cause instanceof CmsIndexException && ((CmsIndexException)cause).getMessageContainer().getKey().equals("ERR_NO_CONTENT_1") || exc instanceof CmsIndexException && ((CmsIndexException)exc).getMessageContainer().getKey().equals("ERR_NO_CONTENT_1")) {
                        this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                    } else {
                        if (this.m_report != null) {
                            this.m_report.println(org.opencms.report.Messages.get().container("RPT_FAILED_0"), 5);
                            this.m_report.println(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", exc.toString()), 5);
                        }
                        if (LOG.isErrorEnabled()) {
                            LOG.error((Object)Messages.get().getBundle().key("ERR_INDEX_RESOURCE_FAILED_2", this.m_res.getRootPath(), this.m_index.getName()), (Throwable)exc);
                        }
                    }
                    docOk = true;
                    Object var5_5 = null;
                    if (docOk) return;
                    if (this.m_report != null) {
                        this.m_report.println(org.opencms.report.Messages.get().container("RPT_FAILED_0"), 5);
                        this.m_report.println(Messages.get().container("ERR_INDEX_RESOURCE_FAILED_2", this.m_res.getRootPath(), this.m_index.getName()), 5);
                    }
                    if (!LOG.isErrorEnabled()) return;
                    LOG.error((Object)Messages.get().getBundle().key("ERR_INDEX_RESOURCE_FAILED_2", this.m_res.getRootPath(), this.m_index.getName()));
                    return;
                }
                Object var5_4 = null;
                if (docOk) return;
                if (this.m_report == null) break block19;
                this.m_report.println(org.opencms.report.Messages.get().container("RPT_FAILED_0"), 5);
                this.m_report.println(Messages.get().container("ERR_INDEX_RESOURCE_FAILED_2", this.m_res.getRootPath(), this.m_index.getName()), 5);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (docOk) throw throwable;
                if (this.m_report != null) {
                    this.m_report.println(org.opencms.report.Messages.get().container("RPT_FAILED_0"), 5);
                    this.m_report.println(Messages.get().container("ERR_INDEX_RESOURCE_FAILED_2", this.m_res.getRootPath(), this.m_index.getName()), 5);
                }
                if (!LOG.isErrorEnabled()) throw throwable;
                LOG.error((Object)Messages.get().getBundle().key("ERR_INDEX_RESOURCE_FAILED_2", this.m_res.getRootPath(), this.m_index.getName()));
                throw throwable;
            }
        }
        if (!LOG.isErrorEnabled()) return;
        LOG.error((Object)Messages.get().getBundle().key("ERR_INDEX_RESOURCE_FAILED_2", this.m_res.getRootPath(), this.m_index.getName()));
    }
}

