/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import java.io.File;
import java.io.IOException;
import java.lang.constant.Constable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.opencms.configuration.I_CmsConfigurationParameterHandler;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsIndexException;
import org.opencms.search.CmsSearchCategoryCollector;
import org.opencms.search.CmsSearchException;
import org.opencms.search.CmsSearchIndexSource;
import org.opencms.search.CmsSearchParameters;
import org.opencms.search.CmsSearchResult;
import org.opencms.search.CmsSearchResultList;
import org.opencms.search.Messages;
import org.opencms.search.documents.I_CmsDocumentFactory;
import org.opencms.search.documents.I_CmsTermHighlighter;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.util.CmsStringUtil;

public class CmsSearchIndex
implements I_CmsConfigurationParameterHandler {
    public static final String EXCERPT = CmsSearchIndex.class.getName() + ".createExcerpt";
    public static final String PERMISSIONS = CmsSearchIndex.class.getName() + ".checkPermissions";
    public static final String PRIORITY = CmsSearchIndex.class.getName() + ".priority";
    public static final String REBUILD_MODE_AUTO = "auto";
    public static final String REBUILD_MODE_MANUAL = "manual";
    public static final String ROOT_PATH_SUFFIX = "";
    public static final String ROOT_PATH_TOKEN = "root";
    static final String[] DOC_META_FIELDS = new String[]{"meta", "content"};
    private static final Log LOG = CmsLog.getLog(CmsSearchIndex.class);
    List m_sources;
    private boolean m_createExcerpt = true;
    private Map m_documenttypes;
    private boolean m_dontCheckPermissions;
    private boolean m_enabled = true;
    private CmsSearchFieldConfiguration m_fieldConfiguration;
    private String m_fieldConfigurationName;
    private Locale m_locale;
    private String m_name;
    private String m_path;
    private int m_priority = -1;
    private String m_project;
    private String m_rebuild;
    private List m_sourceNames = new ArrayList();

    public CmsSearchIndex() {
        this.m_documenttypes = new HashMap();
    }

    public CmsSearchIndex(String name) throws CmsIllegalArgumentException {
        this();
        this.setName(name);
    }

    public static String rootPathRewrite(String path) {
        StringBuffer result = new StringBuffer(256);
        String[] elements = CmsSearchIndex.rootPathSplit(path);
        for (int i = 0; i < elements.length; ++i) {
            result.append(elements[i]);
            if (i + 1 >= elements.length) continue;
            result.append(' ');
        }
        return result.toString();
    }

    public static String[] rootPathSplit(String path) {
        if (CmsStringUtil.isEmpty(path)) {
            return new String[]{ROOT_PATH_TOKEN};
        }
        String[] elements = CmsStringUtil.splitAsArray(path, '/');
        String[] result = new String[elements.length + 1];
        result[0] = ROOT_PATH_TOKEN;
        System.arraycopy(elements, 0, result, 1, elements.length);
        return result;
    }

    public void addConfigurationParameter(String key, String value) {
        if (PERMISSIONS.equals(key)) {
            this.m_dontCheckPermissions = Boolean.valueOf(value) == false;
        } else if (EXCERPT.equals(key)) {
            this.m_createExcerpt = Boolean.valueOf(value);
        } else if (PRIORITY.equals(key)) {
            this.m_priority = Integer.parseInt(value);
            if (this.m_priority < 1) {
                this.m_priority = 1;
                LOG.error((Object)Messages.get().getBundle().key("LOG_SEARCH_PRIORITY_TOO_LOW_2", value, new Integer(1)));
            } else if (this.m_priority > 10) {
                this.m_priority = 10;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_SEARCH_PRIORITY_TOO_HIGH_2", value, new Integer(10)));
            }
        }
    }

    public void addSourceName(String sourceName) {
        this.m_sourceNames.add(sourceName);
    }

    public boolean checkConfiguration(CmsObject cms) {
        if (this.isEnabled()) {
            try {
                cms.readProject(this.getProject());
                this.setEnabled(true);
            }
            catch (CmsException e) {
                this.setEnabled(false);
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_SEARCHINDEX_CREATE_BAD_PROJECT_2", this.getProject(), this.getName()));
                }
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_SEARCHINDEX_DISABLED_1", this.getName()));
        }
        return this.isEnabled();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsSearchIndex) {
            return ((CmsSearchIndex)obj).m_name.equals(this.m_name);
        }
        return false;
    }

    public Map getConfiguration() {
        TreeMap<String, Constable> result = new TreeMap<String, Constable>();
        if (this.m_priority > 0) {
            result.put(PRIORITY, new Integer(this.m_priority));
        }
        if (!this.m_createExcerpt) {
            result.put(EXCERPT, Boolean.valueOf(this.m_createExcerpt));
        }
        if (this.m_dontCheckPermissions) {
            result.put(PERMISSIONS, Boolean.valueOf(!this.m_dontCheckPermissions));
        }
        return result;
    }

    public I_CmsDocumentFactory getDocumentFactory(CmsResource res) {
        I_CmsDocumentFactory result;
        if (res != null && this.m_sources != null && (result = OpenCms.getSearchManager().getDocumentFactory(res)) != null) {
            Iterator i = this.m_sources.iterator();
            while (i.hasNext()) {
                CmsSearchIndexSource source = (CmsSearchIndexSource)i.next();
                if (!source.isIndexing(res.getRootPath(), result.getName())) continue;
                return result;
            }
        }
        return null;
    }

    public List getDocumenttypes(String path) {
        List documenttypes = null;
        if (this.m_documenttypes != null) {
            Iterator i = this.m_documenttypes.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                String key = (String)e.getKey();
                if (!path.startsWith(key)) continue;
                documenttypes = (List)e.getValue();
                break;
            }
        }
        if (documenttypes == null) {
            documenttypes = OpenCms.getSearchManager().getDocumentTypes();
        }
        return documenttypes;
    }

    public CmsSearchFieldConfiguration getFieldConfiguration() {
        return this.m_fieldConfiguration;
    }

    public String getFieldConfigurationName() {
        return this.m_fieldConfigurationName;
    }

    public IndexWriter getIndexWriter(boolean create) throws CmsIndexException {
        IndexWriter indexWriter;
        Analyzer analyzer = OpenCms.getSearchManager().getAnalyzer(this.m_locale);
        try {
            File f = new File(this.m_path);
            if (f.exists()) {
                indexWriter = new IndexWriter(this.m_path, analyzer, create);
            } else {
                if ((f = f.getParentFile()) != null && !f.exists()) {
                    f.mkdirs();
                }
                indexWriter = new IndexWriter(this.m_path, analyzer, true);
            }
        }
        catch (Exception e) {
            throw new CmsIndexException(Messages.get().container("ERR_IO_INDEX_WRITER_OPEN_2", this.m_path, this.m_name), (Throwable)e);
        }
        return indexWriter;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public String getLocaleString() {
        return this.getLocale().toString();
    }

    public String getName() {
        return this.m_name;
    }

    public String getPath() {
        return this.m_path;
    }

    public String getProject() {
        return this.m_project;
    }

    public String getRebuildMode() {
        return this.m_rebuild;
    }

    public List getSourceNames() {
        return this.m_sourceNames;
    }

    public List getSources() {
        return this.m_sources;
    }

    public int hashCode() {
        return this.m_name != null ? this.m_name.hashCode() : 0;
    }

    public void initConfiguration() {
    }

    public void initialize() throws CmsSearchException {
        if (!this.isEnabled()) {
            return;
        }
        String sourceName = null;
        CmsSearchIndexSource indexSource = null;
        List searchIndexSourceDocumentTypes = null;
        List resourceNames = null;
        String resourceName = null;
        this.m_sources = new ArrayList();
        this.m_path = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(OpenCms.getSearchManager().getDirectory() + "/" + this.m_name);
        int n = this.m_sourceNames.size();
        for (int i = 0; i < n; ++i) {
            try {
                sourceName = (String)this.m_sourceNames.get(i);
                indexSource = OpenCms.getSearchManager().getIndexSource(sourceName);
                this.m_sources.add(indexSource);
                resourceNames = indexSource.getResourcesNames();
                searchIndexSourceDocumentTypes = indexSource.getDocumentTypes();
                int m = resourceNames.size();
                for (int j = 0; j < m; ++j) {
                    resourceName = (String)resourceNames.get(j);
                    this.m_documenttypes.put(resourceName, searchIndexSourceDocumentTypes);
                }
                continue;
            }
            catch (Exception e) {
                this.setEnabled(false);
                throw new CmsSearchException(Messages.get().container("ERR_INDEX_SOURCE_ASSOCIATION_1", sourceName), (Throwable)e);
            }
        }
        if (this.m_fieldConfigurationName == null) {
            this.m_fieldConfigurationName = "standard";
        }
        this.m_fieldConfiguration = OpenCms.getSearchManager().getFieldConfiguration(this.m_fieldConfigurationName);
        if (this.m_fieldConfiguration == null) {
            throw new CmsSearchException(Messages.get().container("ERR_FIELD_CONFIGURATION_UNKNOWN_2", this.m_name, this.m_fieldConfigurationName));
        }
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void removeSourceName(String sourceName) {
        this.m_sourceNames.remove(sourceName);
    }

    /*
     * Loose catch block
     */
    public synchronized CmsSearchResultList search(CmsObject cms, CmsSearchParameters params) throws CmsSearchException {
        long timeResultProcessing;
        Hits hits;
        long timeLucene;
        CmsSearchResultList searchResults;
        CmsProject currentProject;
        CmsRequestContext context;
        block34: {
            Query fieldsQuery;
            String[] roots;
            long timeTotal = -System.currentTimeMillis();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_SEARCH_PARAMS_2", params, this.m_name));
            }
            context = cms.getRequestContext();
            currentProject = context.currentProject();
            IndexSearcher searcher = null;
            searchResults = new CmsSearchResultList();
            int previousPriority = Thread.currentThread().getPriority();
            if (this.m_priority > 0) {
                Thread.currentThread().setPriority(this.m_priority);
            }
            context.setCurrentProject(cms.readProject(this.m_project));
            if (params.getRoots() != null && params.getRoots().size() > 0) {
                roots = new String[params.getRoots().size()];
                for (int i = 0; i < params.getRoots().size(); ++i) {
                    roots[i] = cms.getRequestContext().addSiteRoot((String)params.getRoots().get(i));
                }
            } else {
                roots = new String[]{cms.getRequestContext().getSiteRoot()};
            }
            timeLucene = -System.currentTimeMillis();
            Analyzer languageAnalyzer = OpenCms.getSearchManager().getAnalyzer(this.m_locale);
            BooleanQuery query = new BooleanQuery();
            BooleanQuery pathQuery = new BooleanQuery();
            for (int i = 0; i < roots.length; ++i) {
                String[] paths = CmsSearchIndex.rootPathSplit(roots[i]);
                PhraseQuery phrase = new PhraseQuery();
                for (int j = 0; j < paths.length; ++j) {
                    Term term = new Term(ROOT_PATH_TOKEN, paths[j]);
                    phrase.add(term);
                }
                pathQuery.add((Query)phrase, BooleanClause.Occur.SHOULD);
            }
            query.add((Query)pathQuery, BooleanClause.Occur.MUST);
            if (params.getCategories() != null && params.getCategories().size() > 0) {
                BooleanQuery categoryQuery = new BooleanQuery();
                for (int i = 0; i < params.getCategories().size(); ++i) {
                    Term term = new Term("category", (String)params.getCategories().get(i));
                    TermQuery termQuery = new TermQuery(term);
                    categoryQuery.add((Query)termQuery, BooleanClause.Occur.SHOULD);
                }
                query.add((Query)categoryQuery, BooleanClause.Occur.MUST);
            }
            searcher = new IndexSearcher(this.m_path);
            if (params.getFields() != null && params.getFields().size() > 0) {
                BooleanQuery booleanFieldsQuery = new BooleanQuery();
                for (int i = 0; i < params.getFields().size(); ++i) {
                    QueryParser p = new QueryParser((String)params.getFields().get(i), languageAnalyzer);
                    booleanFieldsQuery.add(p.parse(params.getQuery()), BooleanClause.Occur.SHOULD);
                }
                fieldsQuery = searcher.rewrite((Query)booleanFieldsQuery);
            } else {
                QueryParser p = new QueryParser("content", languageAnalyzer);
                fieldsQuery = searcher.rewrite(p.parse(params.getQuery()));
            }
            query.add(fieldsQuery, BooleanClause.Occur.MUST);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_BASE_QUERY_1", query));
                LOG.debug((Object)Messages.get().getBundle().key("LOG_FIELDS_QUERY_1", fieldsQuery));
            }
            if (params.isCalculateCategories()) {
                CmsSearchCategoryCollector categoryCollector = new CmsSearchCategoryCollector(searcher);
                searcher.search((Query)query, (HitCollector)categoryCollector);
                searchResults.setCategories(categoryCollector.getCategoryCountResult());
            }
            hits = searcher.search((Query)query, params.getSort());
            timeLucene += System.currentTimeMillis();
            timeResultProcessing = -System.currentTimeMillis();
            if (hits != null) {
                int hitCount = hits.length();
                int page = params.getSearchPage();
                int start = -1;
                int end = -1;
                if (params.getMatchesPerPage() > 0 && page > 0 && hitCount > 0) {
                    start = params.getMatchesPerPage() * (page - 1);
                    end = start + params.getMatchesPerPage();
                    start = start > hitCount ? hitCount : start;
                    end = end > hitCount ? hitCount : end;
                } else {
                    start = 0;
                    end = hitCount;
                }
                int visibleHitCount = hitCount;
                int cnt = 0;
                for (int i = 0; i < hitCount && cnt < end; ++i) {
                    try {
                        Document doc = hits.doc(i);
                        if (this.isInTimeRange(doc, params) && this.hasReadPermission(cms, doc)) {
                            if (cnt >= start) {
                                String excerpt = null;
                                if (this.m_createExcerpt) {
                                    I_CmsTermHighlighter highlighter = OpenCms.getSearchManager().getHighlighter();
                                    excerpt = highlighter.getExcerpt(doc, this, params, fieldsQuery, languageAnalyzer);
                                }
                                CmsSearchResult searchResult = new CmsSearchResult(Math.round(hits.score(i) * 100.0f), doc, excerpt);
                                searchResults.add(searchResult);
                            }
                            ++cnt;
                            continue;
                        }
                        --visibleHitCount;
                        continue;
                    }
                    catch (Exception e) {
                        if (!LOG.isWarnEnabled()) continue;
                        LOG.warn((Object)Messages.get().getBundle().key("LOG_RESULT_ITERATION_FAILED_0"), (Throwable)e);
                    }
                }
                searchResults.setHitCount(visibleHitCount);
            } else {
                searchResults.setHitCount(0);
            }
            timeResultProcessing += System.currentTimeMillis();
            Object var33_44 = null;
            Thread.currentThread().setPriority(previousPriority);
            if (searcher == null) break block34;
            try {
                searcher.close();
                break block34;
            }
            catch (IOException exc) {
                // empty catch block
            }
            {
                break block34;
                catch (RuntimeException e) {
                    throw new CmsSearchException(Messages.get().container("ERR_SEARCH_PARAMS_1", params), (Throwable)e);
                }
                catch (Exception e) {
                    throw new CmsSearchException(Messages.get().container("ERR_SEARCH_PARAMS_1", params), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var33_45 = null;
                Thread.currentThread().setPriority(previousPriority);
                if (searcher != null) {
                    try {
                        searcher.close();
                    }
                    catch (IOException exc) {
                        // empty catch block
                    }
                }
                context.setCurrentProject(currentProject);
                throw throwable;
            }
        }
        context.setCurrentProject(currentProject);
        Object[] logParams = new Object[]{new Integer(hits == null ? 0 : hits.length()), new Long(timeTotal += System.currentTimeMillis()), new Long(timeLucene), new Long(timeResultProcessing)};
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_STAT_RESULTS_TIME_4", logParams));
        }
        return searchResults;
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    public void setFieldConfiguration(CmsSearchFieldConfiguration fieldConfiguration) {
        this.m_fieldConfiguration = fieldConfiguration;
    }

    public void setFieldConfigurationName(String fieldConfigurationName) {
        this.m_fieldConfigurationName = fieldConfigurationName;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public void setLocaleString(String locale) {
        this.setLocale(CmsLocaleManager.getLocale(locale));
    }

    public void setName(String name) throws CmsIllegalArgumentException {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(name)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_SEARCHINDEX_CREATE_MISSING_NAME_0"));
        }
        if (!name.equals(this.m_name) && OpenCms.getRunLevel() > 2) {
            Iterator itIdxNames = OpenCms.getSearchManager().getIndexNames().iterator();
            while (itIdxNames.hasNext()) {
                if (!itIdxNames.next().equals(name)) continue;
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_SEARCHINDEX_CREATE_INVALID_NAME_1", name));
            }
        }
        this.m_name = name;
    }

    public void setProject(String projectName) {
        this.setProjectName(projectName);
    }

    public void setProjectName(String projectName) {
        this.m_project = projectName;
    }

    public void setRebuildMode(String rebuildMode) {
        this.m_rebuild = rebuildMode;
    }

    public String toString() {
        return this.getName();
    }

    protected boolean hasReadPermission(CmsObject cms, Document doc) {
        if (this.m_dontCheckPermissions) {
            return true;
        }
        Field typeField = doc.getField("type");
        Field pathField = doc.getField("path");
        if (typeField == null || pathField == null) {
            return true;
        }
        String type = typeField.stringValue();
        if (!"VFS".equals(type) && !OpenCms.getResourceManager().hasResourceType(type)) {
            return true;
        }
        String contextPath = cms.getRequestContext().removeSiteRoot(pathField.stringValue());
        return cms.existsResource(contextPath);
    }

    protected boolean isInTimeRange(Document doc, CmsSearchParameters params) {
        try {
            Date dateCreated = DateTools.stringToDate((String)doc.getField("created").stringValue());
            if (params.getMinDateCreated() > Long.MIN_VALUE && dateCreated.getTime() < params.getMinDateCreated()) {
                return false;
            }
            if (params.getMaxDateCreated() < Long.MAX_VALUE && dateCreated.getTime() > params.getMaxDateCreated()) {
                return false;
            }
            Date dateLastModified = DateTools.stringToDate((String)doc.getField("lastmodified").stringValue());
            if (params.getMinDateLastModified() > Long.MIN_VALUE && dateLastModified.getTime() < params.getMinDateLastModified()) {
                return false;
            }
            if (params.getMaxDateLastModified() < Long.MAX_VALUE && dateLastModified.getTime() > params.getMaxDateLastModified()) {
                return false;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return true;
    }
}

