/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import java.util.ArrayList;
import java.util.List;
import org.opencms.db.CmsPublishedResource;
import org.opencms.search.CmsSearchIndexSource;
import org.opencms.search.I_CmsIndexer;

public class CmsSearchIndexUpdateData {
    private I_CmsIndexer m_indexer;
    private List m_resourcesToDelete;
    private List m_resourcesToUpdate;
    private CmsSearchIndexSource m_source;

    public CmsSearchIndexUpdateData(CmsSearchIndexSource source, I_CmsIndexer indexer) {
        this.m_source = source;
        this.m_indexer = indexer;
        this.m_resourcesToDelete = new ArrayList();
        this.m_resourcesToUpdate = new ArrayList();
    }

    public void addResourceToDelete(CmsPublishedResource resource) {
        this.m_resourcesToDelete.add(resource);
    }

    public void addResourceToUpdate(CmsPublishedResource resource) {
        this.m_resourcesToUpdate.add(resource);
    }

    public I_CmsIndexer getIndexer() {
        return this.m_indexer;
    }

    public List getResourcesToDelete() {
        return this.m_resourcesToDelete;
    }

    public List getResourcesToUpdate() {
        return this.m_resourcesToUpdate;
    }

    public CmsSearchIndexSource getSource() {
        return this.m_source;
    }

    public boolean hasResourcesToDelete() {
        return !this.m_resourcesToDelete.isEmpty();
    }

    public boolean hasResourceToUpdate() {
        return !this.m_resourcesToUpdate.isEmpty();
    }

    public boolean isEmpty() {
        return this.m_resourcesToDelete.isEmpty() && this.m_resourcesToUpdate.isEmpty();
    }
}

