/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.opencms.monitor.CmsMemoryMonitor;
import org.opencms.monitor.I_CmsMemoryMonitorable;
import org.opencms.util.CmsStringUtil;

public class CmsSearchResult
implements I_CmsMemoryMonitorable,
Comparable {
    protected Date m_dateCreated;
    protected Date m_dateLastModified;
    protected String m_documentType;
    protected String m_excerpt;
    protected String m_path;
    protected int m_score;
    Map m_fields;
    private int m_memorySize;

    protected CmsSearchResult(int score, Document doc, String excerpt) {
        this.m_score = score;
        this.m_excerpt = excerpt;
        this.m_fields = new HashMap();
        Iterator i = doc.getFields().iterator();
        while (i.hasNext()) {
            Field field = (Field)i.next();
            if (field == null || !field.isStored()) continue;
            String name = field.name();
            String value = field.stringValue();
            if (!CmsStringUtil.isNotEmpty(value) || "path".equals(name) || "created".equals(name) || "lastmodified".equals(name)) continue;
            this.m_fields.put(name, value);
        }
        Field f = doc.getField("path");
        this.m_path = f != null ? f.stringValue() : null;
        f = doc.getField("created");
        if (f != null) {
            try {
                this.m_dateCreated = DateTools.stringToDate((String)f.stringValue());
            }
            catch (ParseException exc) {
                this.m_dateCreated = null;
            }
        } else {
            this.m_dateCreated = null;
        }
        if ((f = doc.getField("lastmodified")) != null) {
            try {
                this.m_dateLastModified = DateTools.stringToDate((String)f.stringValue());
            }
            catch (ParseException exc) {
                this.m_dateLastModified = null;
            }
        } else {
            this.m_dateLastModified = null;
        }
        this.m_documentType = (f = doc.getField("type")) != null ? f.stringValue() : null;
    }

    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (obj instanceof CmsSearchResult) {
            return ((CmsSearchResult)obj).m_score - this.m_score;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsSearchResult) {
            CmsSearchResult other = (CmsSearchResult)obj;
            return this.m_documentType.equals(other.m_documentType) && this.m_path.equals(other.m_path);
        }
        return false;
    }

    public Date getDateCreated() {
        return (Date)this.m_dateCreated.clone();
    }

    public Date getDateLastModified() {
        return (Date)this.m_dateLastModified.clone();
    }

    public String getDescription() {
        return this.getField("description");
    }

    public String getDocumentType() {
        return this.m_documentType;
    }

    public String getExcerpt() {
        return this.m_excerpt;
    }

    public String getField(String fieldName) {
        return (String)this.m_fields.get(fieldName);
    }

    public String getKeywords() {
        return this.getField("keywords");
    }

    public int getMemorySize() {
        if (this.m_memorySize == 0) {
            int result = 8;
            if (this.m_dateCreated != null) {
                result += CmsMemoryMonitor.getMemorySize(this.m_dateCreated);
            }
            if (this.m_dateLastModified != null) {
                result += CmsMemoryMonitor.getMemorySize(this.m_dateLastModified);
            }
            if (this.m_path != null) {
                result += CmsMemoryMonitor.getMemorySize(this.m_path);
            }
            if (this.m_fields != null) {
                Iterator entries = this.m_fields.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry entry = entries.next();
                    result += CmsMemoryMonitor.getMemorySize(entry.getKey());
                    result += CmsMemoryMonitor.getMemorySize(entry.getValue());
                }
            }
            if (this.m_excerpt != null) {
                result += CmsMemoryMonitor.getMemorySize(this.m_excerpt);
            }
            this.m_memorySize = result;
        }
        return this.m_memorySize;
    }

    public String getPath() {
        return this.m_path;
    }

    public int getScore() {
        return this.m_score;
    }

    public String getTitle() {
        return this.getField("title-key");
    }

    public int hashCode() {
        return this.m_documentType.hashCode() * 1109 + this.m_path.hashCode();
    }
}

