/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.documents;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsIndexException;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.documents.CmsExtractionResultCache;
import org.opencms.search.documents.I_CmsDocumentFactory;
import org.opencms.search.documents.Messages;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.search.fields.CmsSearchFieldMapping;
import org.opencms.util.CmsStringUtil;

public abstract class A_CmsVfsDocument
implements I_CmsDocumentFactory {
    public static final String SEARCH_PRIORITY_HIGH_VALUE = "high";
    public static final String SEARCH_PRIORITY_LOW_VALUE = "low";
    public static final String SEARCH_PRIORITY_MAX_VALUE = "max";
    public static final String SEARCH_PRIORITY_NORMAL_VALUE = "normal";
    public static final String VFS_DOCUMENT_KEY_PREFIX = "VFS";
    private static final Log LOG = CmsLog.getLog(A_CmsVfsDocument.class);
    protected String m_name;
    private CmsExtractionResultCache m_cache;

    public A_CmsVfsDocument(String name) {
        this.m_name = name;
    }

    public static String getDocumentKey(String type, String mimeType) {
        StringBuffer result = new StringBuffer(16);
        result.append(VFS_DOCUMENT_KEY_PREFIX);
        result.append('_');
        result.append(type);
        if (mimeType != null) {
            result.append(':');
            result.append(mimeType);
        }
        return result.toString();
    }

    public Document createDocument(CmsObject cms, CmsResource resource, CmsSearchIndex index) throws CmsException {
        Field field;
        String path = cms.getRequestContext().removeSiteRoot(resource.getRootPath());
        I_CmsExtractionResult content = null;
        String cacheName = null;
        CmsExtractionResultCache cache = this.getCache();
        if (cache != null) {
            cacheName = cache.getCacheName(resource, this.isLocaleDependend() ? index.getLocale() : null);
            content = (I_CmsExtractionResult)cache.getCacheObject(cacheName);
        }
        if (content == null) {
            try {
                content = this.extractContent(cms, resource, index);
                if (cache != null) {
                    cache.saveCacheObject(cacheName, content);
                }
            }
            catch (Exception e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_TEXT_EXTRACTION_1", resource.getRootPath()), (Throwable)e);
            }
        }
        Document document = new Document();
        CmsSearchFieldConfiguration fieldConfiguration = index.getFieldConfiguration();
        Iterator fieldConfigs = fieldConfiguration.getFields().iterator();
        while (fieldConfigs.hasNext()) {
            CmsSearchField fieldConfig = (CmsSearchField)fieldConfigs.next();
            StringBuffer text = new StringBuffer();
            Iterator mappings = fieldConfig.getMappings().iterator();
            while (mappings.hasNext()) {
                CmsSearchFieldMapping mapping = (CmsSearchFieldMapping)mappings.next();
                String mapResult = mapping.getStringValue(cms, resource, content);
                if (mapResult == null) continue;
                text.append(mapResult);
                text.append('\n');
            }
            if (text.length() <= 0) continue;
            Field field2 = fieldConfig.createField(text.toString());
            document.add((Fieldable)field2);
        }
        String value = cms.readPropertyObject(path, "category", true).getValue();
        if (CmsStringUtil.isNotEmpty(value)) {
            if ((value = value.trim().toLowerCase()).length() > 0) {
                field = new Field("category", value, Field.Store.YES, Field.Index.UN_TOKENIZED);
                field.setBoost(0.0f);
                document.add((Fieldable)field);
            }
        } else {
            field = new Field("category", "unknown", Field.Store.YES, Field.Index.UN_TOKENIZED);
            document.add((Fieldable)field);
        }
        String rootPath = CmsSearchIndex.rootPathRewrite(resource.getRootPath());
        field = new Field("root", rootPath, Field.Store.YES, Field.Index.TOKENIZED);
        field.setBoost(0.0f);
        document.add((Fieldable)field);
        document.add((Fieldable)new Field("path", resource.getRootPath(), Field.Store.YES, Field.Index.UN_TOKENIZED));
        field = new Field("created", DateTools.dateToString((Date)new Date(resource.getDateCreated()), (DateTools.Resolution)DateTools.Resolution.MILLISECOND), Field.Store.YES, Field.Index.UN_TOKENIZED);
        field.setBoost(0.0f);
        document.add((Fieldable)field);
        field = new Field("lastmodified", DateTools.dateToString((Date)new Date(resource.getDateLastModified()), (DateTools.Resolution)DateTools.Resolution.MILLISECOND), Field.Store.YES, Field.Index.UN_TOKENIZED);
        field.setBoost(0.0f);
        document.add((Fieldable)field);
        I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(resource.getTypeId());
        String typeName = VFS_DOCUMENT_KEY_PREFIX;
        if (type != null) {
            typeName = type.getTypeName();
        }
        document.add((Fieldable)new Field("type", typeName, Field.Store.YES, Field.Index.UN_TOKENIZED));
        float boost = 1.0f;
        value = cms.readPropertyObject(path, "search.priority", true).getValue();
        if (value != null) {
            if ((value = value.trim().toLowerCase()).equals(SEARCH_PRIORITY_MAX_VALUE)) {
                boost = 2.0f;
            } else if (value.equals(SEARCH_PRIORITY_HIGH_VALUE)) {
                boost = 1.5f;
            } else if (value.equals(SEARCH_PRIORITY_LOW_VALUE)) {
                boost = 0.5f;
            }
        }
        if (boost != 1.0f) {
            document.setBoost(boost);
        }
        return document;
    }

    public CmsExtractionResultCache getCache() {
        return this.m_cache;
    }

    public List getDocumentKeys(List resourceTypes, List mimeTypes) throws CmsException {
        ArrayList<String> keys = new ArrayList<String>();
        if (resourceTypes.contains("*")) {
            ArrayList<String> allTypes = new ArrayList<String>();
            Iterator i = OpenCms.getResourceManager().getResourceTypes().iterator();
            while (i.hasNext()) {
                I_CmsResourceType resourceType = (I_CmsResourceType)i.next();
                allTypes.add(resourceType.getTypeName());
            }
            resourceTypes = allTypes;
        }
        try {
            Iterator i = resourceTypes.iterator();
            while (i.hasNext()) {
                String typeName = OpenCms.getResourceManager().getResourceType((String)i.next()).getTypeName();
                Iterator j = mimeTypes.iterator();
                while (j.hasNext()) {
                    keys.add(A_CmsVfsDocument.getDocumentKey(typeName, (String)j.next()));
                }
                if (!mimeTypes.isEmpty()) continue;
                keys.add(A_CmsVfsDocument.getDocumentKey(typeName, null));
            }
        }
        catch (Exception exc) {
            throw new CmsException(Messages.get().container("ERR_CREATE_DOC_KEY_0"), (Throwable)exc);
        }
        return keys;
    }

    public String getName() {
        return this.m_name;
    }

    public void setCache(CmsExtractionResultCache cache) {
        this.m_cache = cache;
    }

    protected CmsFile readFile(CmsObject cms, CmsResource resource) throws CmsException, CmsIndexException {
        CmsFile file = cms.readFile(resource);
        if (file.getLength() <= 0) {
            throw new CmsIndexException(Messages.get().container("ERR_NO_CONTENT_1", resource.getRootPath()));
        }
        return file;
    }
}

