/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.documents;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.cache.CmsVfsDiskCache;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsLog;
import org.opencms.search.documents.Messages;
import org.opencms.util.CmsFileUtil;

public class CmsExtractionResultCache {
    private static final Log LOG = CmsLog.getLog(CmsExtractionResultCache.class);
    private String m_rfsRepository;

    public CmsExtractionResultCache(String basepath, String foldername) {
        this.m_rfsRepository = CmsFileUtil.normalizePath(basepath + foldername + File.separatorChar);
    }

    public synchronized int cleanCache(float maxAge) {
        File[] files;
        long expireDate = System.currentTimeMillis() - (long)(maxAge * 60.0f * 60.0f * 1000.0f);
        File basedir = new File(this.m_rfsRepository);
        int count = 0;
        if (basedir.canRead() && basedir.isDirectory() && (files = basedir.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                if (!f.canWrite() || f.lastModified() >= expireDate) continue;
                try {
                    f.delete();
                    ++count;
                    continue;
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_EXCERPT_CACHE_DELETE_ERROR_1", f.getAbsolutePath()), (Throwable)e);
                }
            }
        }
        return count;
    }

    public String getCacheName(CmsResource resource, Locale locale) {
        StringBuffer buf = new StringBuffer(this.m_rfsRepository.length() + 36);
        buf.append(this.m_rfsRepository);
        buf.append('/');
        buf.append(resource.getResourceId().toString());
        if (locale != null) {
            buf.append('_');
            buf.append(locale.toString());
        }
        buf.append('_');
        buf.append(resource.getDateContent());
        buf.append(".ext");
        return buf.toString();
    }

    public Object getCacheObject(String rfsName) {
        try {
            File f = new File(rfsName);
            if (f.exists()) {
                byte[] byteContent;
                long age = f.lastModified();
                if (System.currentTimeMillis() - age > 3600000L) {
                    f.setLastModified(System.currentTimeMillis());
                }
                if ((byteContent = CmsFileUtil.readFile(f)) != null) {
                    ByteArrayInputStream in = new ByteArrayInputStream(byteContent);
                    ObjectInputStream oin = new ObjectInputStream(in);
                    Object result = oin.readObject();
                    oin.close();
                    return result;
                }
            }
        }
        catch (IOException e) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public String getRepositoryPath() {
        return this.m_rfsRepository;
    }

    public void saveCacheObject(String rfsName, Object object) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(512);
        ObjectOutputStream oout = new ObjectOutputStream(out);
        oout.writeObject(object);
        oout.close();
        byte[] byteContent = out.toByteArray();
        CmsVfsDiskCache.saveFile(rfsName, byteContent);
    }
}

