/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.extractors;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.extractors.I_CmsTextExtractor;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;

public abstract class A_CmsTextExtractor
implements I_CmsTextExtractor {
    protected byte[] m_inputBuffer;

    public I_CmsExtractionResult extractText(byte[] content) throws Exception {
        return this.extractText(content, null);
    }

    public I_CmsExtractionResult extractText(byte[] content, String encoding) throws Exception {
        this.m_inputBuffer = content;
        return this.extractText(new ByteArrayInputStream(content), encoding);
    }

    public I_CmsExtractionResult extractText(InputStream in) throws Exception {
        return this.extractText(in, null);
    }

    public I_CmsExtractionResult extractText(InputStream in, String encoding) throws Exception {
        byte[] text = CmsFileUtil.readFully(in);
        return this.extractText(text, encoding);
    }

    public InputStream getStreamCopy(InputStream in) throws IOException {
        if (this.m_inputBuffer != null) {
            return new ByteArrayInputStream(this.m_inputBuffer);
        }
        this.m_inputBuffer = CmsFileUtil.readFully(in);
        return new ByteArrayInputStream(this.m_inputBuffer);
    }

    protected void combineContentItem(String itemValue, String itemKey, StringBuffer content, Map contentItems) {
        if (CmsStringUtil.isNotEmpty(itemValue)) {
            contentItems.put(itemKey, itemValue);
            content.append('\n');
            content.append(itemValue);
        }
    }

    protected String removeControlChars(String content) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(content)) {
            return "";
        }
        char[] chars = content.toCharArray();
        StringBuffer result = new StringBuffer(chars.length);
        boolean wasUnwanted = false;
        block4: for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            int type = Character.getType(ch);
            switch (type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 9: 
                case 12: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 26: 
                case 29: 
                case 30: {
                    result.append(ch);
                    wasUnwanted = false;
                    continue block4;
                }
                case 13: {
                    result.append('\n');
                    wasUnwanted = true;
                    continue block4;
                }
                default: {
                    if (wasUnwanted) continue block4;
                    result.append('\n');
                    wasUnwanted = true;
                }
            }
        }
        return result.toString();
    }
}

