/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.extractors;

import java.io.InputStream;
import java.util.HashMap;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.Section;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.opencms.search.extractors.A_CmsTextExtractor;
import org.opencms.search.extractors.CmsExtractionResult;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.util.CmsStringUtil;

public abstract class A_CmsTextExtractorMsOfficeBase
extends A_CmsTextExtractor
implements POIFSReaderListener {
    protected static final String ENCODING_CP1252 = "Cp1252";
    protected static final String ENCODING_UTF16 = "UTF-16";
    protected static final String POWERPOINT_EVENT_NAME = "PowerPoint Document";
    protected static final int PPT_TEXTBYTE_ATOM = 4008;
    protected static final int PPT_TEXTCHAR_ATOM = 4000;
    private DocumentSummaryInformation m_documentSummary;
    private SummaryInformation m_summary;

    public void processPOIFSReaderEvent(POIFSReaderEvent event) {
        try {
            if (this.m_summary == null && event.getName().startsWith("\u0005SummaryInformation")) {
                this.m_summary = (SummaryInformation)PropertySetFactory.create((InputStream)event.getStream());
                return;
            }
            if (this.m_documentSummary == null && event.getName().startsWith("\u0005DocumentSummaryInformation")) {
                this.m_documentSummary = (DocumentSummaryInformation)PropertySetFactory.create((InputStream)event.getStream());
                return;
            }
        }
        catch (RuntimeException e) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void cleanup() {
        this.m_summary = null;
        this.m_documentSummary = null;
    }

    protected I_CmsExtractionResult createExtractionResult(String rawContent) {
        Section section;
        HashMap<String, String> contentItems = new HashMap<String, String>();
        if (CmsStringUtil.isNotEmpty(rawContent)) {
            contentItems.put("__raw", rawContent);
        }
        StringBuffer content = new StringBuffer(rawContent);
        if (this.m_summary != null) {
            section = (Section)this.m_summary.getSections().get(0);
            this.combineContentItem((String)section.getProperty(2), "title", content, contentItems);
            this.combineContentItem((String)section.getProperty(5), "keywords", content, contentItems);
            this.combineContentItem((String)section.getProperty(3), "subject", content, contentItems);
            this.combineContentItem((String)section.getProperty(6), "comments", content, contentItems);
            this.combineContentItem((String)section.getProperty(4), "author", content, contentItems);
        }
        if (this.m_documentSummary != null) {
            section = (Section)this.m_documentSummary.getSections().get(0);
            this.combineContentItem((String)section.getProperty(15), "company", content, contentItems);
            this.combineContentItem((String)section.getProperty(14), "manager", content, contentItems);
            this.combineContentItem((String)section.getProperty(2), "category", content, contentItems);
        }
        this.cleanup();
        return new CmsExtractionResult(content.toString(), contentItems);
    }
}

