/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.extractors;

import java.io.InputStream;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.util.LittleEndian;
import org.opencms.i18n.CmsEncoder;
import org.opencms.search.extractors.A_CmsTextExtractorMsOfficeBase;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.extractors.I_CmsTextExtractor;

public final class CmsExtractorMsPowerPoint
extends A_CmsTextExtractorMsOfficeBase
implements POIFSReaderListener {
    private StringBuffer m_buffer = new StringBuffer(4096);

    private CmsExtractorMsPowerPoint() {
    }

    public static I_CmsTextExtractor getExtractor() {
        return new CmsExtractorMsPowerPoint();
    }

    public I_CmsExtractionResult extractText(InputStream in, String encoding) throws Exception {
        POIFSReader reader = new POIFSReader();
        reader.registerListener((POIFSReaderListener)this);
        reader.read(in);
        String rawContent = this.removeControlChars(this.m_buffer.toString());
        this.m_buffer = new StringBuffer(4096);
        return this.createExtractionResult(rawContent);
    }

    public void processPOIFSReaderEvent(POIFSReaderEvent event) {
        try {
            super.processPOIFSReaderEvent(event);
            if (!event.getName().startsWith("PowerPoint Document")) {
                return;
            }
            DocumentInputStream input = event.getStream();
            byte[] buffer = new byte[input.available()];
            input.read(buffer, 0, input.available());
            for (int i = 0; i < buffer.length - 20; ++i) {
                int type = LittleEndian.getUShort((byte[])buffer, (int)(i + 2));
                int size = (int)LittleEndian.getUInt((byte[])buffer, (int)(i + 4)) + 3;
                String encoding = null;
                switch (type) {
                    case 4008: {
                        encoding = "Cp1252";
                    }
                    case 4000: {
                        if (encoding == null) {
                            encoding = "UTF-16";
                        }
                        int start = i + 4 + 1;
                        int end = start + size;
                        byte[] buf = new byte[size];
                        System.arraycopy(buffer, start, buf, 0, buf.length);
                        this.m_buffer.append(CmsEncoder.createString(buf, encoding));
                        i = end;
                    }
                }
            }
        }
        catch (RuntimeException e) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

