/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.extractors;

import java.io.InputStream;
import java.util.List;
import java.util.ListIterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.opencms.search.extractors.A_CmsTextExtractor;
import org.opencms.search.extractors.CmsExtractionResult;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.extractors.I_CmsTextExtractor;

public final class CmsExtractorOpenOffice
extends A_CmsTextExtractor {
    private static final CmsExtractorOpenOffice INSTANCE = new CmsExtractorOpenOffice();

    private CmsExtractorOpenOffice() {
    }

    public static I_CmsTextExtractor getExtractor() {
        return INSTANCE;
    }

    public I_CmsExtractionResult extractText(InputStream in, String encoding) throws Exception {
        ZipInputStream zin = new ZipInputStream(in);
        boolean FOUND_CONTENT = false;
        String result = "";
        while (!FOUND_CONTENT) {
            ZipEntry ze = zin.getNextEntry();
            FOUND_CONTENT = ze.getName().equalsIgnoreCase("content.xml");
            if (!FOUND_CONTENT) continue;
            result = this.readContent(zin);
            try {
                zin.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        result = this.removeControlChars(result);
        return new CmsExtractionResult(result);
    }

    private String readContent(InputStream in) throws Exception {
        StringBuffer resultBuffer = new StringBuffer();
        SAXReader reader = new SAXReader();
        Document doc = reader.read(in);
        List textlist = doc.selectNodes("//text:p[@*] | //text:span[@*]");
        ListIterator li = textlist.listIterator();
        while (li.hasNext()) {
            Node textNode = (Node)li.next();
            String text = textNode.getText();
            if (text.length() <= 1) continue;
            text = " " + text + " ";
            resultBuffer.append(text);
        }
        return resultBuffer.toString();
    }
}

